/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.config.ConfigFileUtil;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.PermissionParser;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.TextNode;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;

class AdminConfigFile {
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final List<String> keyOrder = ImmutableList.of((Object)"general", (Object)"users", (Object)"roles", (Object)"web", (Object)"storage", (Object)"smtp", (Object)"httpProxy", (Object)"ldap", (Object)"pagerDuty", (Object)"slack", (Object)"healthchecksIo");
    private final File file;
    private final ObjectNode rootObjectNode;
    private final boolean readOnly;

    AdminConfigFile(List<File> confDirs, boolean readOnly) {
        File defaultFile;
        this.file = new File(confDirs.get(0), "admin.json");
        this.rootObjectNode = this.file.exists() ? AdminConfigFile.readRootObjectNode(this.file) : ((defaultFile = AdminConfigFile.getAdminConfigDefaultFile(confDirs)) == null ? mapper.createObjectNode() : AdminConfigFile.readRootObjectNode(defaultFile));
        this.readOnly = readOnly;
    }

    <T> T getConfig(String key, Class<T> clazz) {
        return (T)ConfigFileUtil.getConfig((ObjectNode)this.rootObjectNode, (String)key, clazz);
    }

    <T> T getConfig(String key, TypeReference<T> typeReference) {
        return (T)ConfigFileUtil.getConfig((ObjectNode)this.rootObjectNode, (String)key, typeReference);
    }

    void writeConfig(String key, Object config) {
        if (this.readOnly) {
            throw new IllegalStateException("Running with config.readOnly=true so config updates are not allowed");
        }
        this.rootObjectNode.replace(key, mapper.valueToTree(config));
        try {
            ConfigFileUtil.writeToFileIfNeeded((File)this.file, (ObjectNode)this.rootObjectNode, keyOrder, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void writeConfigsOnStartup(Map<String, Object> configs) throws IOException {
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            this.rootObjectNode.replace(entry.getKey(), mapper.valueToTree(entry.getValue()));
        }
        ConfigFileUtil.writeToFileIfNeeded((File)this.file, (ObjectNode)this.rootObjectNode, keyOrder, (boolean)this.readOnly);
    }

    private static ObjectNode readRootObjectNode(File file) {
        ObjectNode rootObjectNode = ConfigFileUtil.getRootObjectNode((File)file);
        AdminConfigFile.upgradeRolesIfNeeded(rootObjectNode);
        AdminConfigFile.upgradeSmtpIfNeeded(rootObjectNode);
        AdminConfigFile.upgradeHttpProxyIfNeeded(rootObjectNode);
        AdminConfigFile.upgradeLdapIfNeeded(rootObjectNode);
        return rootObjectNode;
    }

    private static @Nullable File getAdminConfigDefaultFile(List<File> confDirs) {
        for (File confDir : confDirs) {
            File defaultFile = new File(confDir, "admin-default.json");
            if (!defaultFile.exists()) continue;
            return defaultFile;
        }
        return null;
    }

    private static void upgradeRolesIfNeeded(ObjectNode adminRootObjectNode) {
        JsonNode rolesNode = adminRootObjectNode.get("roles");
        if (rolesNode == null || !rolesNode.isArray()) {
            return;
        }
        for (JsonNode roleNode : rolesNode) {
            JsonNode permissionsNode = roleNode.get("permissions");
            if (permissionsNode == null || !permissionsNode.isArray()) continue;
            ArrayList permissions = Lists.newArrayList();
            ArrayNode permissionsArrayNode = (ArrayNode)permissionsNode;
            for (int i = 0; i < permissionsArrayNode.size(); ++i) {
                JsonNode permissionNode = permissionsArrayNode.get(i);
                if (!permissionNode.isTextual()) continue;
                permissions.add(permissionNode.asText());
            }
            boolean upgraded = PermissionParser.upgradeAgentPermissionsFrom_0_9_1_to_0_9_2(permissions);
            if (upgraded && permissions.contains("admin:view") && permissions.contains("admin:edit")) {
                permissions.remove("admin:view");
                permissions.remove("admin:edit");
                permissions.add("admin");
            }
            AdminConfigFile.update(permissions, "agent:alert", "agent:incident");
            AdminConfigFile.update(permissions, "agent:transaction:profile", "agent:transaction:threadProfile");
            AdminConfigFile.update(permissions, "agent:config:edit:gauge", "agent:config:edit:gauges");
            AdminConfigFile.update(permissions, "agent:config:edit:syntheticMonitor", "agent:config:edit:syntheticMonitors");
            AdminConfigFile.update(permissions, "agent:config:edit:alert", "agent:config:edit:alerts");
            AdminConfigFile.update(permissions, "agent:config:edit:plugin", "agent:config:edit:plugins");
            AdminConfigFile.update(permissions, "agent:config:edit:ui", "agent:config:edit:uiDefaults");
            permissionsArrayNode.removeAll();
            for (String permission : permissions) {
                permissionsArrayNode.add((JsonNode)new TextNode(permission));
            }
        }
    }

    private static void update(List<String> permissions, String from, String to) {
        int index = permissions.indexOf(from);
        if (index != -1) {
            permissions.set(index, to);
        }
    }

    private static void upgradeSmtpIfNeeded(ObjectNode adminRootObjectNode) {
        JsonNode passwordNode;
        JsonNode smtpNode = adminRootObjectNode.get("smtp");
        if (smtpNode == null || !smtpNode.isObject()) {
            return;
        }
        ObjectNode smtpObjectNode = (ObjectNode)smtpNode;
        JsonNode sslNode = smtpObjectNode.remove("ssl");
        if (sslNode != null && sslNode.isBoolean() && sslNode.asBoolean()) {
            smtpObjectNode.put("connectionSecurity", "ssl-tls");
        }
        if ((passwordNode = smtpObjectNode.remove("password")) != null) {
            smtpObjectNode.set("encryptedPassword", passwordNode);
        }
    }

    private static void upgradeHttpProxyIfNeeded(ObjectNode adminRootObjectNode) {
        JsonNode httpProxyNode = adminRootObjectNode.get("httpProxy");
        if (httpProxyNode == null || !httpProxyNode.isObject()) {
            return;
        }
        ObjectNode httpProxyObjectNode = (ObjectNode)httpProxyNode;
        JsonNode passwordNode = httpProxyObjectNode.remove("password");
        if (passwordNode != null) {
            httpProxyObjectNode.set("encryptedPassword", passwordNode);
        }
    }

    private static void upgradeLdapIfNeeded(ObjectNode adminRootObjectNode) {
        JsonNode ldapNode = adminRootObjectNode.get("ldap");
        if (ldapNode == null || !ldapNode.isObject()) {
            return;
        }
        ObjectNode ldapObjectNode = (ObjectNode)ldapNode;
        JsonNode passwordNode = ldapObjectNode.remove("password");
        if (passwordNode != null) {
            ldapObjectNode.set("encryptedPassword", passwordNode);
        }
    }
}

