/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Schemas.Column", generator="Immutables")
@Immutable
public final class ImmutableColumn
implements Schemas.Column {
    private final String name;
    private final Schemas.ColumnType type;

    private ImmutableColumn(String name, Schemas.ColumnType type) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
    }

    private ImmutableColumn(ImmutableColumn original, String name, Schemas.ColumnType type) {
        this.name = name;
        this.type = type;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="type")
    public Schemas.ColumnType type() {
        return this.type;
    }

    public final ImmutableColumn withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableColumn(this, newValue, this.type);
    }

    public final ImmutableColumn withType(Schemas.ColumnType value) {
        Schemas.ColumnType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableColumn(this, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumn && this.equalTo(0, (ImmutableColumn)another);
    }

    private boolean equalTo(int synthetic, ImmutableColumn another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Column").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableColumn fromJson(Json json) {
        Builder builder = ImmutableColumn.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableColumn of(String name, Schemas.ColumnType type) {
        return new ImmutableColumn(name, type);
    }

    public static ImmutableColumn copyOf(Schemas.Column instance) {
        if (instance instanceof ImmutableColumn) {
            return (ImmutableColumn)instance;
        }
        return ImmutableColumn.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Schemas.Column", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private Schemas.ColumnType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(Schemas.Column instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.type(instance.type());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Schemas.ColumnType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableColumn build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumn(null, this.name, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Column, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Schemas.Column", generator="Immutables")
    static final class Json
    implements Schemas.Column {
        @Nullable
        String name;
        @Nullable
        Schemas.ColumnType type;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(Schemas.ColumnType type) {
            this.type = type;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Schemas.ColumnType type() {
            throw new UnsupportedOperationException();
        }
    }
}

