/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.util;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableH2Table;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.RepoAdmin;
import org.glowroot.agent.embedded.shaded.org.h2.jdbc.JdbcConnection;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.ResultSetCloser;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.embedded.util.StatementCloser;
import org.glowroot.agent.shaded.com.google.common.annotations.VisibleForTesting;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.base.Throwables;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheLoader;
import org.glowroot.agent.shaded.com.google.common.cache.LoadingCache;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Checkers;

public class DataSource {
    private static final Logger logger = LoggerFactory.getLogger(DataSource.class);
    private static final int CACHE_SIZE = Integer.getInteger("glowroot.internal.h2.cacheSize", 8192);
    private static final int QUERY_TIMEOUT_SECONDS = Integer.getInteger("glowroot.internal.h2.queryTimeout", 60);
    private final @Nullable File dbFile;
    private final Thread shutdownHookThread;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private JdbcConnection connection;
    private volatile boolean closed;
    private final ThreadLocal<Boolean> suppressQueryTimeout = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final Map<String, ImmutableList<Schemas.Column>> tables = Maps.newConcurrentMap();
    private final Map<String, ImmutableList<Schemas.Index>> indexes = Maps.newConcurrentMap();
    private final LoadingCache<String, PreparedStatement> preparedStatementCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, PreparedStatement>(){

        public PreparedStatement load(@Untainted String sql) throws SQLException {
            return DataSource.this.connection.prepareStatement(sql);
        }
    });

    public DataSource() throws SQLException {
        this.dbFile = null;
        this.connection = DataSource.createConnection(null);
        this.shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    public DataSource(File dbFile) throws SQLException {
        this.dbFile = dbFile;
        this.connection = DataSource.createConnection(dbFile);
        this.shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defrag() throws SQLException {
        if (this.dbFile == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            this.execute("shutdown defrag");
            this.connection = DataSource.createConnection(this.dbFile);
            this.preparedStatementCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() throws SQLException {
        if (this.dbFile == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            this.execute("shutdown compact");
            this.connection = DataSource.createConnection(this.dbFile);
            this.preparedStatementCache.invalidateAll();
        }
    }

    public long getH2DataFileSize() {
        return this.dbFile == null ? 0L : this.dbFile.length();
    }

    public List<RepoAdmin.H2Table> analyzeH2DiskSpace() throws Exception {
        return this.suppressQueryTimeout(new Callable<List<RepoAdmin.H2Table>>(){

            @Override
            public List<RepoAdmin.H2Table> call() throws Exception {
                return DataSource.this.analyzeH2DiskSpaceUnderSuppressQueryTimeout();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws SQLException {
        if (this.dbFile == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            List<String> schemaVersionRows = this.queryForStringList("select schema_version from schema_version");
            this.connection.close();
            if (!this.dbFile.delete()) {
                throw new SQLException("Could not delete file: " + this.dbFile.getAbsolutePath());
            }
            this.connection = DataSource.createConnection(this.dbFile);
            this.preparedStatementCache.invalidateAll();
            for (Map.Entry<String, ImmutableList<Schemas.Column>> entry : this.tables.entrySet()) {
                this.syncTable(entry.getKey(), (List)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.indexes.entrySet()) {
                this.syncIndexes(entry.getKey(), (ImmutableList<Schemas.Index>)((ImmutableList)entry.getValue()));
            }
            for (String string : schemaVersionRows) {
                this.update("insert into schema_version (schema_version) values (?)", string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Untainted String sql) throws SQLException {
        DataSource.debug(sql, new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            Statement statement = this.connection.createStatement();
            try (StatementCloser closer = new StatementCloser(statement);){
                statement.setQueryTimeout(0);
                statement.execute(sql);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long queryForLong(final @Untainted String sql, Object ... args) throws SQLException {
        DataSource.debug(sql, args);
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return 0L;
            }
            this.checkConnectionUnderLock();
            return this.queryUnderLock(sql, args, new ResultSetExtractor<Long>(){

                @Override
                public Long extractData(ResultSet resultSet) throws SQLException {
                    if (!resultSet.next()) {
                        return 0L;
                    }
                    long val = resultSet.getLong(1);
                    if (resultSet.wasNull()) {
                        logger.warn("no rows returned: {}", (Object)sql);
                    }
                    if (resultSet.next()) {
                        logger.warn("more than one row returned: {}", (Object)sql);
                    }
                    return val;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Long queryForOptionalLong(final @Untainted String sql, Object ... args) throws SQLException {
        DataSource.debug(sql, args);
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return null;
            }
            this.checkConnectionUnderLock();
            return this.queryUnderLock(sql, args, new ResultSetExtractor<Long>(){

                @Override
                public @Nullable Long extractData(ResultSet resultSet) throws SQLException {
                    Long value;
                    if (!resultSet.next()) {
                        return null;
                    }
                    long val = resultSet.getLong(1);
                    Long l = value = resultSet.wasNull() ? null : Long.valueOf(val);
                    if (resultSet.next()) {
                        logger.warn("more than one row returned: {}", (Object)sql);
                    }
                    return value;
                }
            });
        }
    }

    public List<String> queryForStringList(final @Untainted String sql) throws SQLException {
        return this.query(new JdbcRowQuery<String>(){

            @Override
            public @Untainted String getSql() {
                return sql;
            }

            @Override
            public void bind(PreparedStatement preparedStatement) {
            }

            @Override
            public String mapRow(ResultSet resultSet) throws SQLException {
                return (String)Preconditions.checkNotNull((Object)resultSet.getString(1));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T query(JdbcQuery<T> jdbcQuery) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return jdbcQuery.valueIfDataSourceClosed();
            }
            this.checkConnectionUnderLock();
            PreparedStatement preparedStatement = this.prepareStatementUnderLock(jdbcQuery.getSql(), QUERY_TIMEOUT_SECONDS);
            jdbcQuery.bind(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            try (ResultSetCloser closer = new ResultSetCloser(resultSet);){
                T t = jdbcQuery.processResultSet(resultSet);
                return t;
            }
        }
    }

    public <T> T queryAtMostOne(JdbcRowQuery<T> jdbcQuery) throws SQLException {
        List<T> list = this.query(jdbcQuery);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            logger.warn("more than one row returned: {}", (Object)jdbcQuery.getSql());
        }
        return list.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> query(JdbcRowQuery<T> jdbcQuery) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return ImmutableList.of();
            }
            this.checkConnectionUnderLock();
            PreparedStatement preparedStatement = this.prepareStatementUnderLock(jdbcQuery.getSql(), QUERY_TIMEOUT_SECONDS);
            jdbcQuery.bind(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            try (ResultSetCloser closer = new ResultSetCloser(resultSet);){
                ArrayList mappedRows = Lists.newArrayList();
                while (resultSet.next()) {
                    mappedRows.add(jdbcQuery.mapRow(resultSet));
                }
                ImmutableList immutableList = ImmutableList.copyOf((Collection)mappedRows);
                return immutableList;
            }
        }
    }

    public int update(final @Untainted String sql, final Object ... args) throws SQLException {
        return this.update(new JdbcUpdate(){

            @Override
            public @Untainted String getSql() {
                return sql;
            }

            @Override
            public void bind(PreparedStatement preparedStatement) throws SQLException {
                for (int i = 0; i < args.length; ++i) {
                    preparedStatement.setObject(i + 1, args[i]);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(JdbcUpdate jdbcUpdate) throws SQLException {
        if (this.closed) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return 0;
            }
            this.checkConnectionUnderLock();
            PreparedStatement preparedStatement = this.prepareStatementUnderLock(jdbcUpdate.getSql(), 0);
            jdbcUpdate.bind(preparedStatement);
            return preparedStatement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batchUpdate(JdbcUpdate jdbcUpdate) throws Exception {
        if (this.closed) {
            return new int[0];
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return new int[0];
            }
            this.checkConnectionUnderLock();
            PreparedStatement preparedStatement = this.prepareStatementUnderLock(jdbcUpdate.getSql(), 0);
            jdbcUpdate.bind(preparedStatement);
            return preparedStatement.executeBatch();
        }
    }

    public void deleteBefore(@Untainted String tableName, long captureTime) throws SQLException {
        this.deleteBefore(tableName, "capture_time", captureTime);
    }

    public void deleteBefore(@Untainted String tableName, @Untainted String columnName, long captureTime) throws SQLException {
        int deleted;
        while ((deleted = this.update("delete from " + tableName + " where " + columnName + " < ? limit 100", captureTime)) > 0) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBeforeUsingLock(@Untainted String tableName, @Untainted String columnName, long captureTime, Object externalLock) throws SQLException {
        int deleted;
        do {
            Object object = externalLock;
            synchronized (object) {
                deleted = this.update("delete from " + tableName + " where " + columnName + " < ? limit 100", captureTime);
            }
        } while (deleted > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncTable(@Untainted String tableName, List<Schemas.Column> columns) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            Schemas.syncTable(tableName, columns, this.connection);
            this.tables.put(tableName, (ImmutableList<Schemas.Column>)ImmutableList.copyOf(columns));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncIndexes(@Untainted String tableName, ImmutableList<Schemas.Index> indexes) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            Schemas.syncIndexes(tableName, indexes, this.connection);
            this.indexes.put(tableName, indexes);
        }
    }

    long getDbFileSize() {
        return this.dbFile == null ? 0L : this.dbFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return false;
            }
            this.checkConnectionUnderLock();
            return Schemas.tableExists(tableName, this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnExists(String tableName, String columnName) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return false;
            }
            this.checkConnectionUnderLock();
            return Schemas.columnExists(tableName, columnName, this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTable(@Untainted String oldTableName, @Untainted String newTableName) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            if (Schemas.tableExists(oldTableName, this.connection)) {
                this.execute("alter table " + oldTableName + " rename to " + newTableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameColumn(@Untainted String tableName, @Untainted String oldColumnName, @Untainted String newColumnName) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.checkConnectionUnderLock();
            if (Schemas.columnExists(tableName, oldColumnName, this.connection)) {
                this.execute("alter table " + tableName + " alter column " + oldColumnName + " rename to " + newColumnName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V suppressQueryTimeout(Callable<V> callable) throws Exception {
        boolean priorValue = this.suppressQueryTimeout.get();
        this.suppressQueryTimeout.set(true);
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.suppressQueryTimeout.set(priorValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyUsedByTests
    public void close() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.connection.close();
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
    }

    @GuardedBy(value="lock")
    private void checkConnectionUnderLock() throws SQLException {
        if (this.connection.getPowerOffCount() == -1) {
            this.connection = DataSource.createConnection(this.dbFile);
            this.preparedStatementCache.invalidateAll();
        }
    }

    @GuardedBy(value="lock")
    private PreparedStatement prepareStatementUnderLock(@Untainted String sql, int queryTimeoutSeconds) throws SQLException {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.preparedStatementCache.get((Object)sql);
            if (this.suppressQueryTimeout.get().booleanValue()) {
                preparedStatement.setQueryTimeout(0);
            } else {
                preparedStatement.setQueryTimeout(queryTimeoutSeconds);
            }
            return preparedStatement;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, SQLException.class);
            logger.error(e.getMessage(), (Throwable)e);
            throw new SQLException(e);
        }
    }

    @GuardedBy(value="lock")
    private <T> T queryUnderLock(@Untainted String sql, Object[] args, ResultSetExtractor<T> rse) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatementUnderLock(sql, QUERY_TIMEOUT_SECONDS);
        for (int i = 0; i < args.length; ++i) {
            preparedStatement.setObject(i + 1, args[i]);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        return DataSource.extractAndClose(resultSet, rse);
    }

    private List<RepoAdmin.H2Table> analyzeH2DiskSpaceUnderSuppressQueryTimeout() throws Exception {
        ArrayList tables = Lists.newArrayList();
        for (String tableName : this.getAllTableNames()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            long bytes = this.queryForLong("call disk_space_used (?)", tableName);
            TimeUnit.MILLISECONDS.sleep(stopwatch.elapsed(TimeUnit.MILLISECONDS) / 10L);
            stopwatch.reset().start();
            long rows = this.queryForLong("select count(*) from " + tableName, new Object[0]);
            TimeUnit.MILLISECONDS.sleep(stopwatch.elapsed(TimeUnit.MILLISECONDS) / 10L);
            tables.add(ImmutableH2Table.builder().name(tableName).bytes(bytes).rows(rows).build());
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private List<String> getAllTableNames() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return ImmutableList.of();
            }
            this.checkConnectionUnderLock();
            ResultSet resultSet = this.connection.getMetaData().getTables(null, null, null, null);
            return DataSource.extractAndClose(resultSet, new ResultSetExtractor<List<String>>(){

                @Override
                public List<String> extractData(ResultSet resultSet) throws Exception {
                    ArrayList tableNames = Lists.newArrayList();
                    while (resultSet.next()) {
                        String tableType = (String)Preconditions.checkNotNull((Object)resultSet.getString(4));
                        if (!tableType.equals("TABLE")) continue;
                        String tableName = (String)Preconditions.checkNotNull((Object)resultSet.getString(3));
                        tableNames.add((String)Checkers.castUntainted((Object)tableName));
                    }
                    return tableNames;
                }
            });
        }
    }

    private static JdbcConnection createConnection(@Nullable File dbFile) throws SQLException {
        if (dbFile == null) {
            return new JdbcConnection("jdbc:h2:mem:;compress=true;db_close_on_exit=false", new Properties());
        }
        String dbPath = dbFile.getPath();
        dbPath = dbPath.replaceFirst(".h2.db$", "");
        Properties props = new Properties();
        props.setProperty("user", "sa");
        props.setProperty("password", "");
        String url = "jdbc:h2:" + dbPath + ";compress=true;db_close_on_exit=false;cache_size=" + CACHE_SIZE;
        return new JdbcConnection(url, props);
    }

    private static <T> T extractAndClose(ResultSet resultSet, ResultSetExtractor<T> rse) throws SQLException {
        try (ResultSetCloser closer = new ResultSetCloser(resultSet);){
            T t = rse.extractData(resultSet);
            return t;
        }
    }

    private static void debug(String sql, Object ... args) {
        DataSource.debug(logger, sql, args);
    }

    @VisibleForTesting
    static void debug(Logger logger, String sql, Object ... args) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (args.length == 0) {
            logger.debug(sql);
            return;
        }
        ArrayList argStrings = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof String) {
                argStrings.add('\'' + (String)arg + '\'');
                continue;
            }
            if (arg == null) {
                argStrings.add("NULL");
                continue;
            }
            argStrings.add((String)Preconditions.checkNotNull((Object)arg.toString()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} [{}]", (Object)sql, (Object)Joiner.on((String)", ").join((Iterable)argStrings));
        }
    }

    private class ShutdownHookThread
    extends Thread {
        private ShutdownHookThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DataSource.this.closed = true;
                Object object = DataSource.this.lock;
                synchronized (object) {
                    DataSource.this.connection.close();
                }
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static interface ResultSetExtractor<T> {
        public T extractData(ResultSet var1) throws Exception;
    }

    public static interface JdbcUpdate {
        public @Untainted String getSql();

        public void bind(PreparedStatement var1) throws SQLException;
    }

    public static interface JdbcRowQuery<T> {
        public @Untainted String getSql();

        public void bind(PreparedStatement var1) throws SQLException;

        public T mapRow(ResultSet var1) throws Exception;
    }

    public static interface JdbcQuery<T> {
        public @Untainted String getSql();

        public void bind(PreparedStatement var1) throws Exception;

        public T processResultSet(ResultSet var1) throws Exception;

        public T valueIfDataSourceClosed();
    }
}

