/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.command.ddl;

import org.glowroot.agent.embedded.shaded.org.h2.command.ddl.DefineCommand;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Database;
import org.glowroot.agent.embedded.shaded.org.h2.engine.DbObject;
import org.glowroot.agent.embedded.shaded.org.h2.engine.Session;
import org.glowroot.agent.embedded.shaded.org.h2.expression.Expression;
import org.glowroot.agent.embedded.shaded.org.h2.table.Column;
import org.glowroot.agent.embedded.shaded.org.h2.table.Table;

public class AlterTableRenameColumn
extends DefineCommand {
    private Table table;
    private Column column;
    private String newName;

    public AlterTableRenameColumn(Session session) {
        super(session);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setNewColumnName(String string) {
        this.newName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        Expression expression = this.column.getCheckConstraint(this.session, this.newName);
        this.table.renameColumn(this.column, this.newName);
        this.column.removeCheckConstraint();
        this.column.addCheckConstraint(this.session, expression);
        this.table.setModified();
        database.update(this.session, this.table);
        for (DbObject dbObject : this.table.getChildren()) {
            if (dbObject.getCreateSQL() == null) continue;
            database.update(this.session, dbObject);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 16;
    }
}

