/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableAggregate;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableAggregateQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableSummaryQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableThroughputAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableProfile;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ProfileCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

class TransactionCommonService {
    private final AggregateRepository aggregateRepository;
    private final LiveAggregateRepository liveAggregateRepository;
    private final ConfigRepository configRepository;
    private final Clock clock;

    TransactionCommonService(AggregateRepository aggregateRepository, LiveAggregateRepository liveAggregateRepository, ConfigRepository configRepository, Clock clock) {
        this.aggregateRepository = aggregateRepository;
        this.liveAggregateRepository = liveAggregateRepository;
        this.configRepository = configRepository;
        this.clock = clock;
    }

    CompletionStage<OverallSummaryCollector> readOverallSummary(String agentRollupId, LiveAggregateRepository.SummaryQuery query, boolean autoRefresh) throws Exception {
        OverallSummaryCollector collector = new OverallSummaryCollector();
        long revisedFrom = query.from();
        long revisedTo = autoRefresh ? query.to() : this.liveAggregateRepository.mergeInOverallSummary(agentRollupId, query, collector);
        ArrayList futures = new ArrayList();
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableSummaryQuery revisedQuery = ImmutableSummaryQuery.builder().copyFrom(query).from(revisedFrom).to(revisedTo).rollupLevel(rollupLevel).build();
            futures.add(this.aggregateRepository.mergeOverallSummaryInto(agentRollupId, (LiveAggregateRepository.SummaryQuery)revisedQuery, collector, CassandraProfile.web));
            long lastRolledUpTime = collector.getLastCaptureTime();
            revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            if (revisedFrom > revisedTo) break;
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignore -> collector);
    }

    CompletionStage<Result<TransactionNameSummaryCollector.TransactionNameSummary>> readTransactionNameSummaries(String agentRollupId, LiveAggregateRepository.SummaryQuery query, TransactionNameSummaryCollector.SummarySortOrder sortOrder, int limit, boolean autoRefresh, CassandraProfile profile) throws Exception {
        TransactionNameSummaryCollector collector = new TransactionNameSummaryCollector();
        long revisedFrom = query.from();
        long revisedTo = autoRefresh ? query.to() : this.liveAggregateRepository.mergeInTransactionNameSummaries(agentRollupId, query, collector);
        ArrayList futures = new ArrayList();
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableSummaryQuery revisedQuery = ImmutableSummaryQuery.builder().copyFrom(query).from(revisedFrom).to(revisedTo).rollupLevel(rollupLevel).build();
            futures.add(this.aggregateRepository.mergeTransactionNameSummariesInto(agentRollupId, (LiveAggregateRepository.SummaryQuery)revisedQuery, sortOrder, limit, collector, profile));
            long lastRolledUpTime = collector.getLastCaptureTime();
            revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            if (revisedFrom > revisedTo) break;
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignore -> collector.getResult(sortOrder, limit));
    }

    CompletionStage<List<LiveAggregateRepository.OverviewAggregate>> getOverviewAggregates(String agentRollupId, LiveAggregateRepository.AggregateQuery query, boolean autoRefresh) {
        long revisedTo;
        LiveAggregateRepository.LiveResult liveResult;
        if (autoRefresh) {
            liveResult = null;
            revisedTo = query.to();
        } else {
            liveResult = this.liveAggregateRepository.getOverviewAggregates(agentRollupId, query);
            revisedTo = liveResult == null ? query.to() : liveResult.revisedTo();
        }
        ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).to(revisedTo).build();
        return this.aggregateRepository.readOverviewAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, CassandraProfile.web).thenCompose(arg_0 -> this.lambda$getOverviewAggregates$4((LiveAggregateRepository.AggregateQuery)revisedQuery, liveResult, revisedTo, agentRollupId, arg_0));
    }

    CompletionStage<List<LiveAggregateRepository.PercentileAggregate>> getPercentileAggregates(String agentRollupId, LiveAggregateRepository.AggregateQuery query, boolean autoRefresh) {
        long revisedTo;
        LiveAggregateRepository.LiveResult liveResult;
        if (autoRefresh) {
            liveResult = null;
            revisedTo = query.to();
        } else {
            liveResult = this.liveAggregateRepository.getPercentileAggregates(agentRollupId, query);
            revisedTo = liveResult == null ? query.to() : liveResult.revisedTo();
        }
        ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).to(revisedTo).build();
        return this.aggregateRepository.readPercentileAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, CassandraProfile.web).thenCompose(arg_0 -> this.lambda$getPercentileAggregates$7((LiveAggregateRepository.AggregateQuery)revisedQuery, liveResult, revisedTo, agentRollupId, arg_0));
    }

    CompletionStage<List<LiveAggregateRepository.ThroughputAggregate>> getThroughputAggregates(String agentRollupId, LiveAggregateRepository.AggregateQuery query, boolean autoRefresh) throws Exception {
        long revisedTo;
        LiveAggregateRepository.LiveResult liveResult;
        if (autoRefresh) {
            liveResult = null;
            revisedTo = query.to();
        } else {
            liveResult = this.liveAggregateRepository.getThroughputAggregates(agentRollupId, query);
            revisedTo = liveResult == null ? query.to() : liveResult.revisedTo();
        }
        ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).to(revisedTo).build();
        return this.aggregateRepository.readThroughputAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, CassandraProfile.web).thenCompose(arg_0 -> this.lambda$getThroughputAggregates$10((LiveAggregateRepository.AggregateQuery)revisedQuery, liveResult, revisedTo, agentRollupId, arg_0));
    }

    CompletionStage<QueryCollector> getMergedQueries(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        int maxQueryAggregatesPerTransactionAggregate = this.getMaxQueryAggregatesPerTransactionAggregate(agentRollupId).toCompletableFuture().get();
        QueryCollector queryCollector = new QueryCollector(maxQueryAggregatesPerTransactionAggregate);
        long revisedFrom = query.from();
        long revisedTo = this.liveAggregateRepository.mergeInQueries(agentRollupId, query, queryCollector);
        ArrayList futures = new ArrayList();
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).from(revisedFrom).to(revisedTo).rollupLevel(rollupLevel).build();
            futures.add(this.aggregateRepository.mergeQueriesInto(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, queryCollector, CassandraProfile.web));
            long lastRolledUpTime = queryCollector.getLastCaptureTime();
            revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            if (revisedFrom > revisedTo) break;
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignore -> queryCollector);
    }

    CompletionStage<ServiceCallCollector> getMergedServiceCalls(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        int maxServiceCallAggregatesPerTransactionAggregate = this.getMaxServiceCallAggregatesPerTransactionAggregate(agentRollupId).toCompletableFuture().get();
        ServiceCallCollector serviceCallCollector = new ServiceCallCollector(maxServiceCallAggregatesPerTransactionAggregate);
        long revisedFrom = query.from();
        long revisedTo = this.liveAggregateRepository.mergeInServiceCalls(agentRollupId, query, serviceCallCollector);
        ArrayList futures = new ArrayList();
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).from(revisedFrom).to(revisedTo).rollupLevel(rollupLevel).build();
            futures.add(this.aggregateRepository.mergeServiceCallsInto(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, serviceCallCollector, CassandraProfile.web));
            long lastRolledUpTime = serviceCallCollector.getLastCaptureTime();
            revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            if (revisedFrom > revisedTo) break;
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignore -> serviceCallCollector);
    }

    ProfileCollector getMergedProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query, boolean auxiliary, List<String> includes, List<String> excludes, double truncateBranchPercentage) throws Exception {
        ProfileCollector profileCollector = this.getMergedProfile(agentRollupId, query, auxiliary, CassandraProfile.web);
        MutableProfile profile = profileCollector.getProfile();
        if (!includes.isEmpty() || !excludes.isEmpty()) {
            profile.filter(includes, excludes);
        }
        profile.truncateBranches(truncateBranchPercentage);
        return profileCollector;
    }

    CompletionStage<String> readFullQueryText(String agentRollupId, String fullQueryTextSha1, CassandraProfile profile) {
        return this.aggregateRepository.readFullQueryText(agentRollupId, fullQueryTextSha1, profile).thenApply(fullQueryText -> {
            if (fullQueryText != null) {
                return fullQueryText;
            }
            return this.liveAggregateRepository.getFullQueryText(agentRollupId, fullQueryTextSha1);
        });
    }

    boolean hasMainThreadProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).rollupLevel(rollupLevel).build();
            if (!this.aggregateRepository.hasMainThreadProfile(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, CassandraProfile.web).toCompletableFuture().get().booleanValue()) continue;
            return true;
        }
        return false;
    }

    boolean hasAuxThreadProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).rollupLevel(rollupLevel).build();
            if (!this.aggregateRepository.hasAuxThreadProfile(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, CassandraProfile.web).toCompletableFuture().get().booleanValue()) continue;
            return true;
        }
        return false;
    }

    static List<LiveAggregateRepository.OverviewAggregate> rollUpOverviewAggregates(List<LiveAggregateRepository.OverviewAggregate> orderedNonRolledUpOverviewAggregates, Function<Long, Long> rollupCaptureTimeFn) {
        ArrayList rolledUpOverviewAggregates = Lists.newArrayList();
        MutableAggregate currMergedAggregate = new MutableAggregate(0, 0);
        long currRollupCaptureTime = Long.MIN_VALUE;
        long maxCaptureTime = Long.MIN_VALUE;
        for (LiveAggregateRepository.OverviewAggregate nonRolledUpOverviewAggregate : orderedNonRolledUpOverviewAggregates) {
            maxCaptureTime = nonRolledUpOverviewAggregate.captureTime();
            long rollupCaptureTime = (Long)rollupCaptureTimeFn.apply((Object)maxCaptureTime);
            if (rollupCaptureTime != currRollupCaptureTime && !currMergedAggregate.isEmpty()) {
                rolledUpOverviewAggregates.add(currMergedAggregate.toOverviewAggregate(currRollupCaptureTime));
                currMergedAggregate = new MutableAggregate(0, 0);
            }
            currRollupCaptureTime = rollupCaptureTime;
            currMergedAggregate.addTotalDurationNanos(nonRolledUpOverviewAggregate.totalDurationNanos());
            currMergedAggregate.addTransactionCount(nonRolledUpOverviewAggregate.transactionCount());
            currMergedAggregate.mergeMainThreadRootTimers(nonRolledUpOverviewAggregate.mainThreadRootTimers());
            currMergedAggregate.mergeMainThreadStats(nonRolledUpOverviewAggregate.mainThreadStats());
            AggregateOuterClass.Aggregate.Timer auxThreadRootTimer = nonRolledUpOverviewAggregate.auxThreadRootTimer();
            if (auxThreadRootTimer != null) {
                currMergedAggregate.mergeAuxThreadRootTimer(auxThreadRootTimer);
                currMergedAggregate.mergeAuxThreadStats((AggregateOuterClass.Aggregate.ThreadStats)Preconditions.checkNotNull((Object)nonRolledUpOverviewAggregate.auxThreadStats()));
            }
            currMergedAggregate.mergeAsyncTimers(nonRolledUpOverviewAggregate.asyncTimers());
        }
        if (!currMergedAggregate.isEmpty()) {
            rolledUpOverviewAggregates.add(currMergedAggregate.toOverviewAggregate(maxCaptureTime));
        }
        return rolledUpOverviewAggregates;
    }

    static List<LiveAggregateRepository.PercentileAggregate> rollUpPercentileAggregates(List<LiveAggregateRepository.PercentileAggregate> orderedNonRolledUpPercentileAggregates, Function<Long, Long> rollupCaptureTimeFn) {
        ArrayList rolledUpPercentileAggregates = Lists.newArrayList();
        MutableAggregate currMergedAggregate = new MutableAggregate(0, 0);
        long currRollupCaptureTime = Long.MIN_VALUE;
        long maxCaptureTime = Long.MIN_VALUE;
        for (LiveAggregateRepository.PercentileAggregate nonRolledUpPercentileAggregate : orderedNonRolledUpPercentileAggregates) {
            maxCaptureTime = nonRolledUpPercentileAggregate.captureTime();
            long rollupCaptureTime = (Long)rollupCaptureTimeFn.apply((Object)maxCaptureTime);
            if (rollupCaptureTime != currRollupCaptureTime && !currMergedAggregate.isEmpty()) {
                rolledUpPercentileAggregates.add(currMergedAggregate.toPercentileAggregate(currRollupCaptureTime));
                currMergedAggregate = new MutableAggregate(0, 0);
            }
            currRollupCaptureTime = rollupCaptureTime;
            currMergedAggregate.addTotalDurationNanos(nonRolledUpPercentileAggregate.totalDurationNanos());
            currMergedAggregate.addTransactionCount(nonRolledUpPercentileAggregate.transactionCount());
            currMergedAggregate.mergeDurationNanosHistogram(nonRolledUpPercentileAggregate.durationNanosHistogram());
        }
        if (!currMergedAggregate.isEmpty()) {
            rolledUpPercentileAggregates.add(currMergedAggregate.toPercentileAggregate(maxCaptureTime));
        }
        return rolledUpPercentileAggregates;
    }

    static List<LiveAggregateRepository.ThroughputAggregate> rollUpThroughputAggregates(List<LiveAggregateRepository.ThroughputAggregate> orderedNonRolledUpThroughputAggregates, Function<Long, Long> rollupCaptureTimeFn) {
        ArrayList rolledUpThroughputAggregates = Lists.newArrayList();
        long currTransactionCount = 0L;
        boolean hasMissingErrorCount = false;
        long currErrorCount = 0L;
        long currRollupCaptureTime = Long.MIN_VALUE;
        long maxCaptureTime = Long.MIN_VALUE;
        for (LiveAggregateRepository.ThroughputAggregate nonRolledUpThroughputAggregate : orderedNonRolledUpThroughputAggregates) {
            maxCaptureTime = nonRolledUpThroughputAggregate.captureTime();
            long rollupCaptureTime = (Long)rollupCaptureTimeFn.apply((Object)maxCaptureTime);
            if (rollupCaptureTime != currRollupCaptureTime && currTransactionCount > 0L) {
                rolledUpThroughputAggregates.add(ImmutableThroughputAggregate.builder().captureTime(currRollupCaptureTime).transactionCount(currTransactionCount).errorCount(hasMissingErrorCount ? null : Long.valueOf(currErrorCount)).build());
                currTransactionCount = 0L;
                hasMissingErrorCount = false;
                currErrorCount = 0L;
            }
            currRollupCaptureTime = rollupCaptureTime;
            currTransactionCount += nonRolledUpThroughputAggregate.transactionCount();
            Long errorCount = nonRolledUpThroughputAggregate.errorCount();
            if (errorCount == null) {
                hasMissingErrorCount = true;
                continue;
            }
            currErrorCount += errorCount.longValue();
        }
        if (currTransactionCount > 0L) {
            rolledUpThroughputAggregates.add(ImmutableThroughputAggregate.builder().captureTime(maxCaptureTime).transactionCount(currTransactionCount).errorCount(hasMissingErrorCount ? null : Long.valueOf(currErrorCount)).build());
        }
        return rolledUpThroughputAggregates;
    }

    private ProfileCollector getMergedProfile(String agentRollupId, LiveAggregateRepository.AggregateQuery query, boolean auxiliary, CassandraProfile profile) throws Exception {
        ProfileCollector profileCollector = new ProfileCollector();
        long revisedFrom = query.from();
        long revisedTo = auxiliary ? this.liveAggregateRepository.mergeInAuxThreadProfiles(agentRollupId, query, profileCollector) : this.liveAggregateRepository.mergeInMainThreadProfiles(agentRollupId, query, profileCollector);
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableAggregateQuery revisedQuery = ImmutableAggregateQuery.builder().copyFrom(query).from(revisedFrom).to(revisedTo).rollupLevel(rollupLevel).build();
            if (auxiliary) {
                this.aggregateRepository.mergeAuxThreadProfilesInto(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, profileCollector, profile).toCompletableFuture().join();
            } else {
                this.aggregateRepository.mergeMainThreadProfilesInto(agentRollupId, (LiveAggregateRepository.AggregateQuery)revisedQuery, profileCollector, profile).toCompletableFuture().join();
            }
            long lastRolledUpTime = profileCollector.getLastCaptureTime();
            revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            if (revisedFrom > revisedTo) break;
        }
        return profileCollector;
    }

    private CompletionStage<Integer> getMaxQueryAggregatesPerTransactionAggregate(String agentRollupId) {
        return this.configRepository.getAdvancedConfig(agentRollupId).thenApply(advancedConfig -> {
            if (advancedConfig == null) {
                return 500;
            }
            if (advancedConfig.hasMaxQueryAggregates()) {
                return advancedConfig.getMaxQueryAggregates().getValue();
            }
            return 500;
        });
    }

    private CompletionStage<Integer> getMaxServiceCallAggregatesPerTransactionAggregate(String agentRollupId) {
        return this.configRepository.getAdvancedConfig(agentRollupId).thenApply(advancedConfig -> {
            if (advancedConfig == null) {
                return 500;
            }
            if (advancedConfig.hasMaxServiceCallAggregates()) {
                return advancedConfig.getMaxServiceCallAggregates().getValue();
            }
            return 500;
        });
    }

    private /* synthetic */ CompletionStage lambda$getThroughputAggregates$10(LiveAggregateRepository.AggregateQuery revisedQuery, LiveAggregateRepository.LiveResult liveResult, long revisedTo, String agentRollupId, List aggregates) {
        if (revisedQuery.rollupLevel() == 0) {
            if (liveResult != null) {
                aggregates = Lists.newArrayList((Iterable)aggregates);
                aggregates.addAll(liveResult.get());
            }
            return CompletableFuture.completedFuture(aggregates);
        }
        long nonRolledUpFrom = revisedQuery.from();
        if (!aggregates.isEmpty()) {
            nonRolledUpFrom = ((LiveAggregateRepository.ThroughputAggregate)Iterables.getLast((Iterable)aggregates)).captureTime() + 1L;
        }
        long finalNonRolledUpFrom = nonRolledUpFrom;
        List finalAggregates = aggregates;
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(ignored -> {
            if (finalNonRolledUpFrom <= revisedTo) {
                return this.aggregateRepository.readThroughputAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)ImmutableAggregateQuery.builder().copyFrom(revisedQuery).from(finalNonRolledUpFrom).rollupLevel(0).build(), CassandraProfile.web);
            }
            return CompletableFuture.completedFuture(Lists.newArrayList());
        })).thenApply(orderedNonRolledUpAggregates -> {
            LiveAggregateRepository.ThroughputAggregate nextToLastAggregate;
            long currentTime;
            if (liveResult != null) {
                orderedNonRolledUpAggregates = Lists.newArrayList((Iterable)orderedNonRolledUpAggregates);
                orderedNonRolledUpAggregates.addAll(liveResult.get());
            }
            ArrayList aggregatesInner = Lists.newArrayList((Iterable)finalAggregates);
            long fixedIntervalMillis = this.configRepository.getRollupConfigs().get(revisedQuery.rollupLevel()).intervalMillis();
            aggregatesInner.addAll(TransactionCommonService.rollUpThroughputAggregates(orderedNonRolledUpAggregates, new RollupCaptureTimeFn(fixedIntervalMillis)));
            if (aggregatesInner.size() >= 2 && (currentTime = this.clock.currentTimeMillis()) - (nextToLastAggregate = (LiveAggregateRepository.ThroughputAggregate)aggregatesInner.get(aggregatesInner.size() - 2)).captureTime() < 60000L) {
                aggregatesInner.remove(aggregatesInner.size() - 1);
            }
            return aggregatesInner;
        });
    }

    private /* synthetic */ CompletionStage lambda$getPercentileAggregates$7(LiveAggregateRepository.AggregateQuery revisedQuery, LiveAggregateRepository.LiveResult liveResult, long revisedTo, String agentRollupId, List aggregates) {
        if (revisedQuery.rollupLevel() == 0) {
            if (liveResult != null) {
                aggregates = Lists.newArrayList((Iterable)aggregates);
                aggregates.addAll(liveResult.get());
            }
            return CompletableFuture.completedFuture(aggregates);
        }
        long nonRolledUpFrom = revisedQuery.from();
        if (!aggregates.isEmpty()) {
            nonRolledUpFrom = ((LiveAggregateRepository.PercentileAggregate)Iterables.getLast((Iterable)aggregates)).captureTime() + 1L;
        }
        long finalNonRolledUpFrom = nonRolledUpFrom;
        List finalAggregates = aggregates;
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(ignored -> {
            if (finalNonRolledUpFrom <= revisedTo) {
                return this.aggregateRepository.readPercentileAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)ImmutableAggregateQuery.builder().copyFrom(revisedQuery).from(finalNonRolledUpFrom).rollupLevel(0).build(), CassandraProfile.web);
            }
            return CompletableFuture.completedFuture(Lists.newArrayList());
        })).thenApply(orderedNonRolledUpAggregates -> {
            LiveAggregateRepository.PercentileAggregate nextToLastAggregate;
            long currentTime;
            if (liveResult != null) {
                orderedNonRolledUpAggregates.addAll(liveResult.get());
            }
            ArrayList aggregatesInner = Lists.newArrayList((Iterable)finalAggregates);
            long fixedIntervalMillis = this.configRepository.getRollupConfigs().get(revisedQuery.rollupLevel()).intervalMillis();
            aggregatesInner.addAll(TransactionCommonService.rollUpPercentileAggregates(orderedNonRolledUpAggregates, new RollupCaptureTimeFn(fixedIntervalMillis)));
            if (aggregatesInner.size() >= 2 && (currentTime = this.clock.currentTimeMillis()) - (nextToLastAggregate = (LiveAggregateRepository.PercentileAggregate)aggregatesInner.get(aggregatesInner.size() - 2)).captureTime() < 60000L) {
                aggregatesInner.remove(aggregatesInner.size() - 1);
            }
            return aggregatesInner;
        });
    }

    private /* synthetic */ CompletionStage lambda$getOverviewAggregates$4(LiveAggregateRepository.AggregateQuery revisedQuery, LiveAggregateRepository.LiveResult liveResult, long revisedTo, String agentRollupId, List aggregates) {
        if (revisedQuery.rollupLevel() == 0) {
            if (liveResult != null) {
                aggregates = Lists.newArrayList((Iterable)aggregates);
                aggregates.addAll(liveResult.get());
            }
            return CompletableFuture.completedFuture(aggregates);
        }
        long nonRolledUpFrom = revisedQuery.from();
        if (!aggregates.isEmpty()) {
            nonRolledUpFrom = ((LiveAggregateRepository.OverviewAggregate)Iterables.getLast((Iterable)aggregates)).captureTime() + 1L;
        }
        long finalNonRolledUpFrom = nonRolledUpFrom;
        List finalAggregates = aggregates;
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(ignored -> {
            if (finalNonRolledUpFrom <= revisedTo) {
                return this.aggregateRepository.readOverviewAggregates(agentRollupId, (LiveAggregateRepository.AggregateQuery)ImmutableAggregateQuery.builder().copyFrom(revisedQuery).from(finalNonRolledUpFrom).rollupLevel(0).build(), CassandraProfile.web);
            }
            return CompletableFuture.completedFuture(Lists.newArrayList());
        })).thenApply(orderedNonRolledUpAggregates -> {
            LiveAggregateRepository.OverviewAggregate nextToLastAggregate;
            long currentTime;
            if (liveResult != null) {
                orderedNonRolledUpAggregates = Lists.newArrayList((Iterable)orderedNonRolledUpAggregates);
                orderedNonRolledUpAggregates.addAll(liveResult.get());
            }
            ArrayList aggregatesInner = Lists.newArrayList((Iterable)finalAggregates);
            long fixedIntervalMillis = this.configRepository.getRollupConfigs().get(revisedQuery.rollupLevel()).intervalMillis();
            aggregatesInner.addAll(TransactionCommonService.rollUpOverviewAggregates(orderedNonRolledUpAggregates, new RollupCaptureTimeFn(fixedIntervalMillis)));
            if (aggregatesInner.size() >= 2 && (currentTime = this.clock.currentTimeMillis()) - (nextToLastAggregate = (LiveAggregateRepository.OverviewAggregate)aggregatesInner.get(aggregatesInner.size() - 2)).captureTime() < 60000L) {
                aggregatesInner.remove(aggregatesInner.size() - 1);
            }
            return aggregatesInner;
        });
    }

    private static class RollupCaptureTimeFn
    implements Function<Long, Long> {
        private final long fixedIntervalMillis;

        private RollupCaptureTimeFn(long fixedIntervalMillis) {
            this.fixedIntervalMillis = fixedIntervalMillis;
        }

        public Long apply(Long captureTime) {
            return CaptureTimes.getRollup((long)captureTime, (long)this.fixedIntervalMillis);
        }
    }
}

