/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.MoreConfigDefaults;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ErrorIntervalCollector;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableSyntheticResult;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResult;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResultRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChartMarking;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeries;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableChartMarking;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableChartMarkingInterval;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSyntheticMonitor;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.MultiErrorIntervalCollector;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.MultiErrorIntervalMerger;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.HashMultiset;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Value;

@JsonService
class SyntheticResultJsonService {
    private static final double NANOSECONDS_PER_MILLISECOND = 1000000.0;
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final SyntheticResultRepository syntheticResultRepository;
    private final RollupLevelService rollupLevelService;
    private final ConfigRepository configRepository;
    private final Clock clock;

    SyntheticResultJsonService(SyntheticResultRepository syntheticResultRepository, RollupLevelService rollupLevelService, ConfigRepository configRepository, Clock clock) {
        this.syntheticResultRepository = syntheticResultRepository;
        this.rollupLevelService = rollupLevelService;
        this.configRepository = configRepository;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/synthetic-monitor/results", permission="agent:syntheticMonitor")
    String getSyntheticResults(@BindAgentRollupId String agentRollupId, @BindRequest SyntheticResultRequest request) throws Exception {
        ImmutableList<String> syntheticMonitorIds;
        int rollupLevel = this.rollupLevelService.getRollupLevelForView(request.from(), request.to(), RollupLevelService.DataKind.GENERAL);
        long dataPointIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel).intervalMillis();
        double gapMillis = (double)dataPointIntervalMillis * 1.5;
        long revisedFrom = request.from() - dataPointIntervalMillis;
        long revisedTo = request.to() + dataPointIntervalMillis;
        ImmutableList<SyntheticMonitor> allSyntheticMonitors = this.getAllSyntheticMonitors(agentRollupId, request.from(), request.to());
        if (request.all()) {
            syntheticMonitorIds = Lists.newArrayList();
            for (Object syntheticMonitor : allSyntheticMonitors) {
                syntheticMonitorIds.add(syntheticMonitor.id());
            }
        } else {
            syntheticMonitorIds = request.syntheticMonitorId();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (String syntheticMonitorId : syntheticMonitorIds) {
            map.put(syntheticMonitorId, this.getSyntheticResults(agentRollupId, revisedFrom, revisedTo, syntheticMonitorId, rollupLevel));
        }
        if (rollupLevel != 0) {
            this.syncManualRollupCaptureTimes(map, rollupLevel);
        }
        ArrayList dataSeriesList = Lists.newArrayList();
        ArrayList executionCountsList = Lists.newArrayList();
        ArrayList multiErrorIntervalsList = Lists.newArrayList();
        for (Map.Entry entry : map.entrySet()) {
            Object syntheticResult2;
            String syntheticMonitorId = (String)entry.getKey();
            List syntheticResults = (List)entry.getValue();
            dataSeriesList.add(SyntheticResultJsonService.convertToDataSeriesWithGaps(syntheticMonitorId, syntheticResults, gapMillis));
            HashMap executionCounts = Maps.newHashMap();
            executionCountsList.add(executionCounts);
            for (Object syntheticResult2 : syntheticResults) {
                executionCounts.put(syntheticResult2.captureTime(), syntheticResult2.executionCount());
            }
            ErrorIntervalCollector errorIntervalCollector = new ErrorIntervalCollector();
            syntheticResult2 = syntheticResults.iterator();
            while (syntheticResult2.hasNext()) {
                SyntheticResult syntheticResult3 = (SyntheticResult)syntheticResult2.next();
                List<SyntheticResult.ErrorInterval> errorIntervals = syntheticResult3.errorIntervals();
                if (errorIntervals.isEmpty()) {
                    errorIntervalCollector.addGap();
                    continue;
                }
                errorIntervalCollector.addErrorIntervals(errorIntervals);
            }
            MultiErrorIntervalCollector multiErrorIntervalCollector = new MultiErrorIntervalCollector();
            multiErrorIntervalCollector.addErrorIntervals(errorIntervalCollector.getMergedErrorIntervals());
            multiErrorIntervalsList.add(multiErrorIntervalCollector.getMergedMultiErrorIntervals());
        }
        List<ChartMarking> markings = SyntheticResultJsonService.toChartMarkings(multiErrorIntervalsList, syntheticMonitorIds);
        boolean displayNoSyntheticMonitorsConfigured = allSyntheticMonitors.isEmpty() ? this.configRepository.getSyntheticMonitorConfigs(agentRollupId).toCompletableFuture().join().isEmpty() : false;
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("dataSeries", (Object)dataSeriesList);
            jg.writeNumberField("dataPointIntervalMillis", dataPointIntervalMillis);
            jg.writeObjectField("executionCounts", (Object)executionCountsList);
            jg.writeObjectField("markings", markings);
            jg.writeObjectField("allSyntheticMonitors", allSyntheticMonitors);
            jg.writeBooleanField("displayNoSyntheticMonitorsConfigured", displayNoSyntheticMonitorsConfigured);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private ImmutableList<SyntheticMonitor> getAllSyntheticMonitors(String agentRollupId, long from, long to) throws Exception {
        Map<String, String> syntheticMonitorIds = this.syntheticResultRepository.getSyntheticMonitorIds(agentRollupId, from, to);
        HashMultiset multiset = HashMultiset.create();
        multiset.addAll(syntheticMonitorIds.values());
        ArrayList syntheticMonitors = Lists.newArrayList();
        for (Map.Entry<String, String> entry : syntheticMonitorIds.entrySet()) {
            String id = entry.getKey();
            String display = entry.getValue();
            if (multiset.count((Object)entry.getValue()) > 1) {
                display = display + " (" + id + ")";
            }
            syntheticMonitors.add(ImmutableSyntheticMonitor.of(id, display));
        }
        if (to > this.clock.currentTimeMillis()) {
            List<AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig> configs = this.configRepository.getSyntheticMonitorConfigs(agentRollupId).toCompletableFuture().join();
            for (AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig config : configs) {
                if (syntheticMonitorIds.containsKey(config.getId())) continue;
                syntheticMonitors.add(ImmutableSyntheticMonitor.of(config.getId(), MoreConfigDefaults.getDisplayOrDefault(config)));
            }
        }
        return new SyntheticMonitorOrdering().immutableSortedCopy(syntheticMonitors);
    }

    private List<SyntheticResult> getSyntheticResults(String agentRollupId, long from, long to, String syntheticMonitorId, int rollupLevel) throws Exception {
        ArrayList syntheticResults = this.syntheticResultRepository.readSyntheticResults(agentRollupId, syntheticMonitorId, from, to, rollupLevel).toCompletableFuture().join();
        if (rollupLevel == 0) {
            return syntheticResults;
        }
        long nonRolledUpFrom = from;
        if (!syntheticResults.isEmpty()) {
            nonRolledUpFrom = ((SyntheticResult)Iterables.getLast(syntheticResults)).captureTime() + 1L;
        }
        ArrayList orderedNonRolledUpSyntheticResults = Lists.newArrayList();
        orderedNonRolledUpSyntheticResults.addAll((Collection)this.syntheticResultRepository.readSyntheticResults(agentRollupId, syntheticMonitorId, nonRolledUpFrom, to, 0).toCompletableFuture().join());
        syntheticResults = Lists.newArrayList(syntheticResults);
        long fixedIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel).intervalMillis();
        syntheticResults.addAll(SyntheticResultJsonService.rollUpSyntheticResults(orderedNonRolledUpSyntheticResults, new RollupCaptureTimeFn(fixedIntervalMillis)));
        return syntheticResults;
    }

    private <K> void syncManualRollupCaptureTimes(Map<K, List<SyntheticResult>> map, int rollupLevel) {
        long fixedIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel).intervalMillis();
        HashMap manualRollupCaptureTimes = Maps.newHashMap();
        long maxCaptureTime = Long.MIN_VALUE;
        for (Map.Entry<K, List<SyntheticResult>> entry : map.entrySet()) {
            List<SyntheticResult> syntheticResults = entry.getValue();
            if (syntheticResults.isEmpty()) continue;
            SyntheticResult lastSyntheticResult = (SyntheticResult)Iterables.getLast(syntheticResults);
            long lastCaptureTime = lastSyntheticResult.captureTime();
            maxCaptureTime = Math.max(maxCaptureTime, lastCaptureTime);
            if (lastCaptureTime % fixedIntervalMillis == 0L) continue;
            manualRollupCaptureTimes.put(entry.getKey(), lastCaptureTime);
        }
        if (maxCaptureTime == Long.MIN_VALUE) {
            return;
        }
        long maxRollupCaptureTime = CaptureTimes.getRollup((long)maxCaptureTime, (long)fixedIntervalMillis);
        long maxDiffToSync = Math.min(fixedIntervalMillis / 5L, 60000L);
        for (Map.Entry entry : manualRollupCaptureTimes.entrySet()) {
            Long captureTime = (Long)entry.getValue();
            if (CaptureTimes.getRollup((long)captureTime, (long)fixedIntervalMillis) != maxRollupCaptureTime || maxCaptureTime - captureTime > maxDiffToSync) continue;
            Object key = entry.getKey();
            List syntheticResults = (List)Preconditions.checkNotNull(map.get(key));
            syntheticResults = Lists.newArrayList((Iterable)syntheticResults);
            SyntheticResult lastSyntheticResult = (SyntheticResult)Iterables.getLast((Iterable)syntheticResults);
            syntheticResults.set(syntheticResults.size() - 1, ImmutableSyntheticResult.builder().copyFrom(lastSyntheticResult).captureTime(maxCaptureTime).build());
            map.put(key, syntheticResults);
        }
    }

    private static List<SyntheticResult> rollUpSyntheticResults(List<SyntheticResult> orderedNonRolledUpSyntheticResults, Function<Long, Long> rollupCaptureTimeFn) {
        ArrayList rolledUpSyntheticResults = Lists.newArrayList();
        double totalDurationNanos = 0.0;
        long executionCount = 0L;
        ErrorIntervalCollector errorIntervalCollector = new ErrorIntervalCollector();
        long currRollupCaptureTime = Long.MIN_VALUE;
        for (SyntheticResult nonRolledUpSyntheticResult : orderedNonRolledUpSyntheticResults) {
            long captureTime = nonRolledUpSyntheticResult.captureTime();
            long rollupCaptureTime = (Long)rollupCaptureTimeFn.apply((Object)captureTime);
            if (rollupCaptureTime != currRollupCaptureTime && executionCount > 0L) {
                rolledUpSyntheticResults.add(ImmutableSyntheticResult.builder().captureTime(currRollupCaptureTime).totalDurationNanos(totalDurationNanos).executionCount(executionCount).errorIntervals(errorIntervalCollector.getMergedErrorIntervals()).build());
                totalDurationNanos = 0.0;
                executionCount = 0L;
                errorIntervalCollector = new ErrorIntervalCollector();
            }
            currRollupCaptureTime = rollupCaptureTime;
            totalDurationNanos += nonRolledUpSyntheticResult.totalDurationNanos();
            executionCount += nonRolledUpSyntheticResult.executionCount();
            List<SyntheticResult.ErrorInterval> errorIntervals = nonRolledUpSyntheticResult.errorIntervals();
            if (errorIntervals.isEmpty()) {
                errorIntervalCollector.addGap();
                continue;
            }
            errorIntervalCollector.addErrorIntervals(errorIntervals);
        }
        if (executionCount > 0L) {
            long lastCaptureTime = ((SyntheticResult)Iterables.getLast(orderedNonRolledUpSyntheticResults)).captureTime();
            rolledUpSyntheticResults.add(ImmutableSyntheticResult.builder().captureTime(lastCaptureTime).totalDurationNanos(totalDurationNanos).executionCount(executionCount).errorIntervals(errorIntervalCollector.getMergedErrorIntervals()).build());
        }
        return rolledUpSyntheticResults;
    }

    private static DataSeries convertToDataSeriesWithGaps(String dataSeriesName, List<SyntheticResult> syntheticResults, double gapMillis) {
        DataSeries dataSeries = new DataSeries(dataSeriesName);
        SyntheticResult lastSyntheticResult = null;
        for (SyntheticResult syntheticResult : syntheticResults) {
            if (syntheticResult.executionCount() == 0L) continue;
            if (lastSyntheticResult != null && (double)(syntheticResult.captureTime() - lastSyntheticResult.captureTime()) > gapMillis) {
                dataSeries.addNull();
            }
            dataSeries.add(syntheticResult.captureTime(), syntheticResult.totalDurationNanos() / (double)syntheticResult.executionCount() / 1000000.0);
            lastSyntheticResult = syntheticResult;
        }
        return dataSeries;
    }

    private static List<ChartMarking> toChartMarkings(List<List<MultiErrorIntervalCollector.MultiErrorInterval>> multiErrorIntervalsList, List<String> syntheticMonitorIds) {
        MultiErrorIntervalMerger multiErrorIntervalMerger = new MultiErrorIntervalMerger();
        for (int i = 0; i < multiErrorIntervalsList.size(); ++i) {
            List<MultiErrorIntervalCollector.MultiErrorInterval> multiErrorIntervals = multiErrorIntervalsList.get(i);
            String syntheticMonitorId = syntheticMonitorIds.get(i);
            multiErrorIntervalMerger.addMultiErrorIntervals(syntheticMonitorId, multiErrorIntervals);
        }
        ArrayList chartMarkings = Lists.newArrayList();
        for (MultiErrorIntervalMerger.GroupedMultiErrorInterval groupedMultiErrorInterval : multiErrorIntervalMerger.getGroupedMultiErrorIntervals()) {
            ImmutableChartMarking.Builder chartMarking = ImmutableChartMarking.builder().from(groupedMultiErrorInterval.from()).to(groupedMultiErrorInterval.to());
            for (Map.Entry<String, List<SyntheticResult.ErrorInterval>> entry : groupedMultiErrorInterval.errorIntervals().entrySet()) {
                chartMarking.putIntervals(entry.getKey(), SyntheticResultJsonService.toChartMarkingIntervals(entry.getValue()));
            }
            chartMarkings.add(chartMarking.build());
        }
        return chartMarkings;
    }

    private static List<ChartMarking.ChartMarkingInterval> toChartMarkingIntervals(List<SyntheticResult.ErrorInterval> errorIntervals) {
        ArrayList chartMarkingIntervals = Lists.newArrayListWithCapacity((int)errorIntervals.size());
        for (SyntheticResult.ErrorInterval errorInterval : errorIntervals) {
            chartMarkingIntervals.add(ImmutableChartMarkingInterval.builder().from(errorInterval.from()).to(errorInterval.to()).count(errorInterval.count()).message(errorInterval.message()).build());
        }
        return chartMarkingIntervals;
    }

    @Value.Immutable
    @Styles.AllParameters
    static interface SyntheticMonitor {
        public String id();

        public String display();
    }

    private static class RollupCaptureTimeFn
    implements Function<Long, Long> {
        private final long fixedIntervalMillis;

        private RollupCaptureTimeFn(long fixedIntervalMillis) {
            this.fixedIntervalMillis = fixedIntervalMillis;
        }

        public Long apply(Long captureTime) {
            return CaptureTimes.getRollup((long)captureTime, (long)this.fixedIntervalMillis);
        }
    }

    private static class SyntheticMonitorOrdering
    extends Ordering<SyntheticMonitor> {
        private SyntheticMonitorOrdering() {
        }

        public int compare(SyntheticMonitor left, SyntheticMonitor right) {
            return left.display().compareToIgnoreCase(right.display());
        }
    }

    @Value.Immutable
    static abstract class SyntheticResultRequest {
        SyntheticResultRequest() {
        }

        abstract long from();

        abstract long to();

        @Value.Default
        boolean all() {
            return false;
        }

        abstract ImmutableList<String> syntheticMonitorId();
    }
}

