/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResult;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableMultiErrorInterval;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.immutables.value.Value;

class MultiErrorIntervalCollector {
    private final List<MultiErrorInterval> mergedErrorIntervals = Lists.newArrayList();
    private long currErrorFrom;
    private long currErrorTo;
    private @Nullable List<SyntheticResult.ErrorInterval> currErrorIntervals;

    MultiErrorIntervalCollector() {
    }

    public void addErrorIntervals(List<SyntheticResult.ErrorInterval> errorIntervals) {
        for (SyntheticResult.ErrorInterval errorInterval : errorIntervals) {
            this.addErrorInterval(errorInterval);
        }
    }

    private void addErrorInterval(SyntheticResult.ErrorInterval errorInterval) {
        if (this.shouldMergeIntoCurrentInterval(errorInterval)) {
            this.currErrorTo = errorInterval.to();
            ((List)Preconditions.checkNotNull(this.currErrorIntervals)).add(errorInterval);
        } else {
            if (this.currErrorIntervals != null) {
                this.mergedErrorIntervals.add(this.getCurrMultiErrorInterval());
            }
            this.currErrorTo = errorInterval.to();
            this.currErrorFrom = errorInterval.from();
            this.currErrorIntervals = Lists.newArrayList();
            this.currErrorIntervals.add(errorInterval);
        }
        if (errorInterval.doNotMergeToTheRight()) {
            this.mergedErrorIntervals.add(this.getCurrMultiErrorInterval());
            this.currErrorIntervals = null;
        }
    }

    public List<MultiErrorInterval> getMergedMultiErrorIntervals() {
        ArrayList mergedErrorIntervals = Lists.newArrayList(this.mergedErrorIntervals);
        if (this.currErrorIntervals != null) {
            mergedErrorIntervals.add(this.getCurrMultiErrorInterval());
        }
        return mergedErrorIntervals;
    }

    private boolean shouldMergeIntoCurrentInterval(SyntheticResult.ErrorInterval errorInterval) {
        return this.currErrorIntervals != null && !errorInterval.doNotMergeToTheLeft();
    }

    private ImmutableMultiErrorInterval getCurrMultiErrorInterval() {
        return ImmutableMultiErrorInterval.builder().from(this.currErrorFrom).to(this.currErrorTo).addAllErrorIntervals((Iterable)Preconditions.checkNotNull(this.currErrorIntervals)).build();
    }

    @Value.Immutable
    public static interface MultiErrorInterval {
        public long from();

        public long to();

        public List<SyntheticResult.ErrorInterval> errorIntervals();
    }
}

