/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AgentDisplayRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.EnvironmentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TraceAttributeNameRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.TransactionTypeRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableAgentRollupLayout;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableConfigPermissions;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableEditConfigPermissions;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableErrorPermissions;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableJvmPermissions;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableLayout;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePermissions;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableTransactionPermissions;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.collect.UnmodifiableIterator;
import org.glowroot.agent.shaded.org.glowroot.common.ConfigDefaults;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

class LayoutService {
    private static final String AGENT_ID = "";
    private static final Logger logger = LoggerFactory.getLogger(LayoutService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final boolean central;
    private final boolean offlineViewer;
    private final String version;
    private final AgentDisplayRepository agentDisplayRepository;
    private final ConfigRepository configRepository;
    private final TransactionTypeRepository transactionTypeRepository;
    private final TraceAttributeNameRepository traceAttributeNameRepository;
    private final EnvironmentRepository environmentRepository;
    private final LiveAggregateRepository liveAggregateRepository;
    private final LiveTraceRepository liveTraceRepository;

    LayoutService(boolean central, boolean offlineViewer, String version, AgentDisplayRepository agentDisplayRepository, ConfigRepository configRepository, TransactionTypeRepository transactionTypeRepository, TraceAttributeNameRepository traceAttributeNameRepository, EnvironmentRepository environmentRepository, LiveAggregateRepository liveAggregateRepository, LiveTraceRepository liveTraceRepository) {
        this.central = central;
        this.offlineViewer = offlineViewer;
        this.version = version;
        this.agentDisplayRepository = agentDisplayRepository;
        this.configRepository = configRepository;
        this.transactionTypeRepository = transactionTypeRepository;
        this.traceAttributeNameRepository = traceAttributeNameRepository;
        this.environmentRepository = environmentRepository;
        this.liveAggregateRepository = liveAggregateRepository;
        this.liveTraceRepository = liveTraceRepository;
    }

    String getLayoutJson(HttpSessionManager.Authentication authentication) throws Exception {
        Layout layout = this.buildLayout(authentication);
        return mapper.writeValueAsString((Object)layout);
    }

    String getLayoutVersion(HttpSessionManager.Authentication authentication) throws Exception {
        Layout layout = this.buildLayout(authentication);
        return layout.version();
    }

    String getAgentRollupLayoutJson(String agentRollupId, HttpSessionManager.Authentication authentication) throws Exception {
        AgentRollupLayout agentRollupLayout = this.buildAgentRollupLayout(authentication, agentRollupId);
        return mapper.writeValueAsString((Object)agentRollupLayout);
    }

    @Nullable String getAgentRollupLayoutVersion(HttpSessionManager.Authentication authentication, String agentRollupId) throws Exception {
        AgentRollupLayout agentRollupLayout = this.buildAgentRollupLayout(authentication, agentRollupId);
        if (agentRollupLayout == null) {
            return null;
        }
        return agentRollupLayout.version();
    }

    @Nullable AgentRollupLayout buildAgentRollupLayout(HttpSessionManager.Authentication authentication, String agentRollupId) throws Exception {
        boolean configReadOnly;
        CollectorServiceOuterClass.InitMessage.Environment environment;
        AgentConfigOuterClass.AgentConfig.UiDefaultsConfig uiConfig;
        try {
            uiConfig = this.configRepository.getUiDefaultsConfig(agentRollupId);
        }
        catch (ConfigRepository.AgentConfigNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            uiConfig = AgentConfigOuterClass.AgentConfig.UiDefaultsConfig.newBuilder().setDefaultTransactionType("Web").addAllDefaultPercentile((Iterable)ConfigDefaults.UI_DEFAULTS_PERCENTILES).addAllDefaultGaugeName((Iterable)ConfigDefaults.UI_DEFAULTS_GAUGE_NAMES).build();
        }
        String glowrootVersion = agentRollupId.endsWith("::") ? AGENT_ID : ((environment = this.environmentRepository.read(agentRollupId, CassandraProfile.web).toCompletableFuture().get()) == null ? "unknown" : environment.getJavaInfo().getGlowrootAgentVersion());
        try {
            try {
                configReadOnly = this.configRepository.isConfigReadOnly(agentRollupId).toCompletableFuture().join();
            }
            catch (CompletionException ce) {
                if (ce.getCause() instanceof ConfigRepository.AgentConfigNotFoundException) {
                    throw (ConfigRepository.AgentConfigNotFoundException)ce.getCause();
                }
                throw ce;
            }
        }
        catch (ConfigRepository.AgentConfigNotFoundException e) {
            configReadOnly = false;
        }
        TreeSet transactionTypes = Sets.newTreeSet();
        transactionTypes.addAll((Collection)this.transactionTypeRepository.read(agentRollupId).toCompletableFuture().join());
        transactionTypes.addAll(this.liveAggregateRepository.getTransactionTypes(agentRollupId));
        transactionTypes.addAll(this.liveTraceRepository.getTransactionTypes(agentRollupId));
        transactionTypes.add(uiConfig.getDefaultTransactionType());
        List<String> displayParts = this.agentDisplayRepository.readDisplayParts(agentRollupId).get();
        String topLevelId = LayoutService.getTopLevelId(agentRollupId);
        String childDisplay = topLevelId.equals(agentRollupId) ? "Rollup" : Joiner.on((String)" :: ").join(displayParts.subList(1, displayParts.size()));
        return ImmutableAgentRollupLayout.builder().id(agentRollupId).topLevelId(topLevelId).topLevelDisplay(displayParts.get(0)).childDisplay(childDisplay).lastDisplayPart(displayParts.get(displayParts.size() - 1)).glowrootVersion(glowrootVersion).permissions(LayoutService.getPermissions(authentication, agentRollupId, configReadOnly)).addAllTransactionTypes(transactionTypes).putAllTraceAttributeNames(this.traceAttributeNameRepository.read(agentRollupId)).defaultTransactionType(uiConfig.getDefaultTransactionType()).defaultPercentiles(uiConfig.getDefaultPercentileList()).defaultGaugeNames((Iterable<String>)uiConfig.getDefaultGaugeNameList()).build();
    }

    private Layout buildLayout(HttpSessionManager.Authentication authentication) throws Exception {
        if (this.central) {
            return this.buildLayoutCentral(authentication);
        }
        return this.buildLayoutEmbedded(authentication);
    }

    private Layout buildLayoutEmbedded(HttpSessionManager.Authentication authentication) throws Exception {
        boolean hasSomeAccess;
        Permissions permissions = LayoutService.getPermissions(authentication, AGENT_ID, false);
        boolean bl = hasSomeAccess = permissions.hasSomeAccess() || authentication.isAdminPermitted("admin:view");
        if (!hasSomeAccess) {
            return this.createNoAccessLayout(authentication);
        }
        boolean showNavbarTransaction = permissions.transaction().hasSomeAccess();
        boolean showNavbarError = permissions.error().hasSomeAccess();
        boolean showNavbarJvm = permissions.jvm().hasSomeAccess();
        boolean showNavbarIncident = permissions.incident() && !this.configRepository.getAlertConfigs(AGENT_ID).toCompletableFuture().join().isEmpty();
        boolean showNavbarReport = permissions.transaction().overview() && permissions.error().overview() && permissions.jvm().gauges();
        boolean showNavbarConfig = permissions.config().view();
        AgentConfigOuterClass.AgentConfig.UiDefaultsConfig uiConfig = this.configRepository.getUiDefaultsConfig(AGENT_ID);
        TreeSet transactionTypes = Sets.newTreeSet();
        transactionTypes.addAll((Collection)this.transactionTypeRepository.read(AGENT_ID).toCompletableFuture().join());
        transactionTypes.addAll(this.liveAggregateRepository.getTransactionTypes(AGENT_ID));
        transactionTypes.add(uiConfig.getDefaultTransactionType());
        String agentDisplay = this.getEmbeddedAgentDisplayName();
        ImmutableAgentRollupLayout embeddedAgentRollup = ImmutableAgentRollupLayout.builder().id(AGENT_ID).topLevelId(AGENT_ID).topLevelDisplay(agentDisplay).childDisplay(agentDisplay).lastDisplayPart(agentDisplay).glowrootVersion(this.version).permissions(permissions).addAllTransactionTypes(transactionTypes).putAllTraceAttributeNames(this.traceAttributeNameRepository.read(AGENT_ID)).defaultTransactionType(uiConfig.getDefaultTransactionType()).defaultPercentiles(uiConfig.getDefaultPercentileList()).defaultGaugeNames((Iterable<String>)uiConfig.getDefaultGaugeNameList()).build();
        return this.createLayout(authentication, showNavbarTransaction, showNavbarError, showNavbarJvm, false, showNavbarIncident, showNavbarReport, showNavbarConfig, embeddedAgentRollup);
    }

    private Layout buildLayoutCentral(HttpSessionManager.Authentication authentication) throws Exception {
        boolean showNavbarTransaction = authentication.hasAnyPermissionImpliedBy("agent:transaction");
        boolean showNavbarError = authentication.hasAnyPermissionImpliedBy("agent:error");
        boolean showNavbarJvm = authentication.hasAnyPermissionImpliedBy("agent:jvm");
        boolean showNavbarSyntheticMonitor = authentication.hasAnyPermissionImpliedBy("agent:syntheticMonitor");
        boolean showNavbarIncident = authentication.hasAnyPermissionImpliedBy("agent:incident");
        boolean showNavbarReport = authentication.isPermittedForSomeAgentRollup("agent:transaction:overview") && authentication.isPermittedForSomeAgentRollup("agent:error:overview") && authentication.isPermittedForSomeAgentRollup("agent:jvm:gauges");
        boolean showNavbarConfig = authentication.hasAnyPermissionImpliedBy("agent:config");
        if (!(showNavbarTransaction || showNavbarError || showNavbarJvm || showNavbarIncident || showNavbarReport || authentication.isAdminPermitted("admin:view"))) {
            return this.createNoAccessLayout(authentication);
        }
        return this.createLayout(authentication, showNavbarTransaction, showNavbarError, showNavbarJvm, showNavbarSyntheticMonitor, showNavbarIncident, showNavbarReport, showNavbarConfig, null);
    }

    private ImmutableLayout createNoAccessLayout(HttpSessionManager.Authentication authentication) {
        return ImmutableLayout.builder().central(this.central).offlineViewer(this.offlineViewer).glowrootVersion(this.version).loginEnabled(true).gaugeCollectionIntervalMillis(0L).showNavbarTransaction(false).showNavbarError(false).showNavbarJvm(false).showNavbarSyntheticMonitor(false).showNavbarIncident(false).showNavbarReport(false).showNavbarConfig(false).adminView(false).adminEdit(false).loggedIn(!authentication.anonymous()).ldap(authentication.ldap()).redirectToLogin(true).defaultTimeZoneId(TimeZone.getDefault().getID()).build();
    }

    private ImmutableLayout createLayout(HttpSessionManager.Authentication authentication, boolean showNavbarTransaction, boolean showNavbarError, boolean showNavbarJvm, boolean showNavbarSyntheticMonitor, boolean showNavbarIncident, boolean showNavbarReport, boolean showNavbarConfig, @Nullable AgentRollupLayout embeddedAgentRollup) throws Exception {
        ArrayList rollupExpirationMillis = Lists.newArrayList();
        UnmodifiableIterator unmodifiableIterator = this.configRepository.getStorageConfig().rollupExpirationHours().iterator();
        while (unmodifiableIterator.hasNext()) {
            long hours = ((Integer)unmodifiableIterator.next()).intValue();
            rollupExpirationMillis.add(TimeUnit.HOURS.toMillis(hours));
        }
        ArrayList queryAndServiceCallRollupExpirationMillis = Lists.newArrayList();
        UnmodifiableIterator hours = this.configRepository.getStorageConfig().queryAndServiceCallRollupExpirationHours().iterator();
        while (hours.hasNext()) {
            long hours2 = ((Integer)hours.next()).intValue();
            queryAndServiceCallRollupExpirationMillis.add(TimeUnit.HOURS.toMillis(hours2));
        }
        ArrayList profileRollupExpirationHours = Lists.newArrayList();
        UnmodifiableIterator unmodifiableIterator2 = this.configRepository.getStorageConfig().profileRollupExpirationHours().iterator();
        while (unmodifiableIterator2.hasNext()) {
            long hours3 = ((Integer)unmodifiableIterator2.next()).intValue();
            profileRollupExpirationHours.add(TimeUnit.HOURS.toMillis(hours3));
        }
        return ImmutableLayout.builder().central(this.central).offlineViewer(this.offlineViewer).glowrootVersion(this.version).loginEnabled(!this.offlineViewer && (this.configRepository.namedUsersExist().toCompletableFuture().join() != false || !this.configRepository.getLdapConfig().toCompletableFuture().join().host().isEmpty())).addAllRollupConfigs(this.configRepository.getRollupConfigs()).addAllRollupExpirationMillis(rollupExpirationMillis).addAllQueryAndServiceCallRollupExpirationMillis(queryAndServiceCallRollupExpirationMillis).addAllProfileRollupExpirationMillis(profileRollupExpirationHours).gaugeCollectionIntervalMillis(this.configRepository.getGaugeCollectionIntervalMillis()).showNavbarTransaction(showNavbarTransaction).showNavbarError(showNavbarError).showNavbarJvm(showNavbarJvm).showNavbarSyntheticMonitor(showNavbarSyntheticMonitor).showNavbarIncident(showNavbarIncident).showNavbarReport(showNavbarReport).showNavbarConfig(showNavbarConfig).adminView(authentication.isAdminPermitted("admin:view")).adminEdit(authentication.isAdminPermitted("admin:edit")).loggedIn(!authentication.anonymous()).ldap(authentication.ldap()).redirectToLogin(false).defaultTimeZoneId(TimeZone.getDefault().getID()).addAllTimeZoneIds(LayoutService.getAllTimeZoneIds()).embeddedAgentRollup(embeddedAgentRollup).build();
    }

    private String getEmbeddedAgentDisplayName() {
        return this.configRepository.getEmbeddedAdminGeneralConfig().agentDisplayNameOrDefault();
    }

    static Permissions getPermissions(HttpSessionManager.Authentication authentication, String agentRollupId, boolean configReadOnly) throws Exception {
        return ImmutablePermissions.builder().transaction(ImmutableTransactionPermissions.builder().overview(authentication.isPermittedForAgentRollup(agentRollupId, "agent:transaction:overview")).traces(authentication.isPermittedForAgentRollup(agentRollupId, "agent:transaction:traces")).queries(authentication.isPermittedForAgentRollup(agentRollupId, "agent:transaction:queries")).serviceCalls(authentication.isPermittedForAgentRollup(agentRollupId, "agent:transaction:serviceCalls")).threadProfile(authentication.isPermittedForAgentRollup(agentRollupId, "agent:transaction:threadProfile")).build()).error(ImmutableErrorPermissions.builder().overview(authentication.isPermittedForAgentRollup(agentRollupId, "agent:error:overview")).traces(authentication.isPermittedForAgentRollup(agentRollupId, "agent:error:traces")).build()).jvm(ImmutableJvmPermissions.builder().gauges(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:gauges")).threadDump(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:threadDump")).heapDump(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:heapDump")).heapHistogram(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:heapHistogram")).forceGC(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:forceGC")).mbeanTree(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:mbeanTree")).systemProperties(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:systemProperties")).environment(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:environment")).capabilities(authentication.isPermittedForAgentRollup(agentRollupId, "agent:jvm:capabilities")).build()).syntheticMonitor(authentication.isPermittedForAgentRollup(agentRollupId, "agent:syntheticMonitor")).incident(authentication.isPermittedForAgentRollup(agentRollupId, "agent:incident")).config(ImmutableConfigPermissions.builder().view(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:view")).edit(ImmutableEditConfigPermissions.builder().general(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:general") && !configReadOnly).transaction(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:transaction") && !configReadOnly).gauges(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:gauges") && !configReadOnly).jvm(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:jvm") && !configReadOnly).syntheticMonitors(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:syntheticMonitors") && !configReadOnly).alerts(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:alerts") && !configReadOnly).uiDefaults(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:uiDefaults") && !configReadOnly).plugins(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:plugins") && !configReadOnly).instrumentation(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:instrumentation") && !configReadOnly).advanced(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit:advanced") && !configReadOnly).all(authentication.isPermittedForAgentRollup(agentRollupId, "agent:config:edit") && !configReadOnly).build()).build()).build();
    }

    private static List<String> getAllTimeZoneIds() {
        ArrayList allTimeZoneIds = Lists.newArrayList();
        for (String timeZoneId : TimeZone.getAvailableIDs()) {
            if (timeZoneId.startsWith("Etc/")) continue;
            allTimeZoneIds.add(timeZoneId);
        }
        return allTimeZoneIds;
    }

    private static String getTopLevelId(String agentRollupId) {
        int index = agentRollupId.indexOf("::");
        if (index == -1) {
            return agentRollupId;
        }
        return agentRollupId.substring(0, index + 2);
    }

    @Value.Immutable
    static interface EditConfigPermissions {
        public boolean general();

        public boolean transaction();

        public boolean gauges();

        public boolean jvm();

        public boolean syntheticMonitors();

        public boolean alerts();

        public boolean uiDefaults();

        public boolean plugins();

        public boolean instrumentation();

        public boolean advanced();

        public boolean all();
    }

    @Value.Immutable
    static interface ConfigPermissions {
        public boolean view();

        public EditConfigPermissions edit();
    }

    @Value.Immutable
    static abstract class JvmPermissions {
        JvmPermissions() {
        }

        abstract boolean gauges();

        abstract boolean threadDump();

        abstract boolean heapDump();

        abstract boolean heapHistogram();

        abstract boolean forceGC();

        abstract boolean mbeanTree();

        abstract boolean systemProperties();

        abstract boolean environment();

        abstract boolean capabilities();

        private boolean hasSomeAccess() {
            return this.gauges() || this.threadDump() || this.heapDump() || this.heapHistogram() || this.forceGC() || this.mbeanTree() || this.systemProperties() || this.environment();
        }
    }

    @Value.Immutable
    static abstract class ErrorPermissions {
        ErrorPermissions() {
        }

        abstract boolean overview();

        abstract boolean traces();

        private boolean hasSomeAccess() {
            return this.overview() || this.traces();
        }
    }

    @Value.Immutable
    static abstract class TransactionPermissions {
        TransactionPermissions() {
        }

        abstract boolean overview();

        abstract boolean traces();

        abstract boolean queries();

        abstract boolean serviceCalls();

        abstract boolean threadProfile();

        private boolean hasSomeAccess() {
            return this.overview() || this.traces() || this.queries() || this.serviceCalls() || this.threadProfile();
        }
    }

    @Value.Immutable
    static abstract class Permissions {
        Permissions() {
        }

        abstract TransactionPermissions transaction();

        abstract ErrorPermissions error();

        abstract JvmPermissions jvm();

        abstract boolean syntheticMonitor();

        abstract boolean incident();

        abstract ConfigPermissions config();

        boolean hasSomeAccess() {
            return this.transaction().hasSomeAccess() || this.error().hasSomeAccess() || this.jvm().hasSomeAccess() || this.config().view();
        }
    }

    @Value.Immutable
    static abstract class AgentRollupLayout {
        AgentRollupLayout() {
        }

        abstract String id();

        abstract String topLevelId();

        abstract String topLevelDisplay();

        abstract String childDisplay();

        abstract String lastDisplayPart();

        abstract String glowrootVersion();

        abstract Permissions permissions();

        abstract List<String> transactionTypes();

        abstract Map<String, List<String>> traceAttributeNames();

        abstract String defaultTransactionType();

        abstract List<Double> defaultPercentiles();

        abstract List<String> defaultGaugeNames();

        @Value.Derived
        public String version() {
            return Versions.getJsonVersion((Object)this);
        }
    }

    @Value.Immutable
    static abstract class Layout {
        Layout() {
        }

        abstract boolean central();

        abstract boolean offlineViewer();

        abstract String glowrootVersion();

        abstract boolean loginEnabled();

        abstract ImmutableList<ConfigRepository.RollupConfig> rollupConfigs();

        abstract ImmutableList<Long> rollupExpirationMillis();

        abstract ImmutableList<Long> queryAndServiceCallRollupExpirationMillis();

        abstract ImmutableList<Long> profileRollupExpirationMillis();

        abstract long gaugeCollectionIntervalMillis();

        abstract boolean showNavbarTransaction();

        abstract boolean showNavbarError();

        abstract boolean showNavbarJvm();

        abstract boolean showNavbarSyntheticMonitor();

        abstract boolean showNavbarIncident();

        abstract boolean showNavbarReport();

        abstract boolean showNavbarConfig();

        abstract boolean adminView();

        abstract boolean adminEdit();

        abstract boolean loggedIn();

        abstract boolean ldap();

        abstract boolean redirectToLogin();

        abstract String defaultTimeZoneId();

        abstract List<String> timeZoneIds();

        abstract @Nullable AgentRollupLayout embeddedAgentRollup();

        @Value.Derived
        public String version() {
            return Versions.getJsonVersion((Object)this);
        }
    }

    @Value.Immutable
    static interface FilteredChildAgentRollup {
        public String id();

        public String display();

        public String lastDisplayPart();

        public boolean disabled();

        public List<FilteredChildAgentRollup> children();
    }

    @Value.Immutable
    static interface FilteredTopLevelAgentRollup {
        public String id();

        public String display();

        public boolean disabled();
    }
}

