/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.UserConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UserConfigJsonService.UserConfigDto", generator="Immutables")
@Immutable
final class ImmutableUserConfigDto
extends UserConfigJsonService.UserConfigDto {
    private final String username;
    private final boolean ldap;
    private final String newPassword;
    private final ImmutableList<String> roles;
    private final Optional<String> version;

    private ImmutableUserConfigDto(Builder builder) {
        this.username = builder.username;
        this.ldap = builder.ldap;
        this.roles = builder.roles.build();
        this.version = builder.version;
        this.newPassword = builder.newPassword != null ? builder.newPassword : Objects.requireNonNull(super.newPassword(), "newPassword");
    }

    private ImmutableUserConfigDto(String username, boolean ldap, String newPassword, ImmutableList<String> roles, Optional<String> version) {
        this.username = username;
        this.ldap = ldap;
        this.newPassword = newPassword;
        this.roles = roles;
        this.version = version;
    }

    @Override
    @JsonProperty(value="username")
    String username() {
        return this.username;
    }

    @Override
    @JsonProperty(value="ldap")
    boolean ldap() {
        return this.ldap;
    }

    @Override
    @JsonProperty(value="newPassword")
    String newPassword() {
        return this.newPassword;
    }

    @Override
    @JsonProperty(value="roles")
    ImmutableList<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="version")
    Optional<String> version() {
        return this.version;
    }

    public final ImmutableUserConfigDto withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableUserConfigDto(newValue, this.ldap, this.newPassword, this.roles, this.version);
    }

    public final ImmutableUserConfigDto withLdap(boolean value) {
        if (this.ldap == value) {
            return this;
        }
        return new ImmutableUserConfigDto(this.username, value, this.newPassword, this.roles, this.version);
    }

    public final ImmutableUserConfigDto withNewPassword(String value) {
        String newValue = Objects.requireNonNull(value, "newPassword");
        if (this.newPassword.equals(newValue)) {
            return this;
        }
        return new ImmutableUserConfigDto(this.username, this.ldap, newValue, this.roles, this.version);
    }

    public final ImmutableUserConfigDto withRoles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableUserConfigDto(this.username, this.ldap, this.newPassword, (ImmutableList<String>)newValue, this.version);
    }

    public final ImmutableUserConfigDto withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableUserConfigDto(this.username, this.ldap, this.newPassword, (ImmutableList<String>)newValue, this.version);
    }

    public final ImmutableUserConfigDto withVersion(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.version.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableUserConfigDto(this.username, this.ldap, this.newPassword, this.roles, (Optional<String>)newValue);
    }

    public final ImmutableUserConfigDto withVersion(Optional<String> optional) {
        Optional<String> value = optional;
        if (this.version.equals(value)) {
            return this;
        }
        return new ImmutableUserConfigDto(this.username, this.ldap, this.newPassword, this.roles, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserConfigDto && this.equalTo(0, (ImmutableUserConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserConfigDto another) {
        return this.username.equals(another.username) && this.ldap == another.ldap && this.newPassword.equals(another.newPassword) && this.roles.equals(another.roles) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.ldap);
        h += (h << 5) + this.newPassword.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UserConfigDto").omitNullValues().add("username", (Object)this.username).add("ldap", this.ldap).add("newPassword", (Object)this.newPassword).add("roles", this.roles).add("version", this.version.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUserConfigDto fromJson(Json json) {
        Builder builder = ImmutableUserConfigDto.builder();
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.ldapIsSet) {
            builder.ldap(json.ldap);
        }
        if (json.newPassword != null) {
            builder.newPassword(json.newPassword);
        }
        if (json.roles != null) {
            builder.addAllRoles((Iterable<String>)json.roles);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableUserConfigDto copyOf(UserConfigJsonService.UserConfigDto instance) {
        if (instance instanceof ImmutableUserConfigDto) {
            return (ImmutableUserConfigDto)instance;
        }
        return ImmutableUserConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UserConfigJsonService.UserConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_LDAP = 2L;
        private long initBits = 3L;
        @Nullable
        private String username;
        private boolean ldap;
        @Nullable
        private String newPassword;
        private ImmutableList.Builder<String> roles = ImmutableList.builder();
        private Optional<String> version = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(UserConfigJsonService.UserConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.username(instance.username());
            this.ldap(instance.ldap());
            this.newPassword(instance.newPassword());
            this.addAllRoles((Iterable<String>)instance.roles());
            Optional<String> versionOptional = instance.version();
            if (versionOptional.isPresent()) {
                this.version(versionOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ldap(boolean ldap) {
            this.ldap = ldap;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newPassword(String newPassword) {
            this.newPassword = Objects.requireNonNull(newPassword, "newPassword");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Iterable<String> elements) {
            this.roles = ImmutableList.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<String> elements) {
            this.roles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Optional.of((Object)version);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public ImmutableUserConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserConfigDto(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ldap");
            }
            return "Cannot build UserConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UserConfigJsonService.UserConfigDto", generator="Immutables")
    static final class Json
    extends UserConfigJsonService.UserConfigDto {
        @Nullable
        String username;
        boolean ldap;
        boolean ldapIsSet;
        @Nullable
        String newPassword;
        @Nullable
        ImmutableList<String> roles = ImmutableList.of();
        @Nullable
        Optional<String> version = Optional.absent();

        Json() {
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="ldap")
        public void setLdap(boolean ldap) {
            this.ldap = ldap;
            this.ldapIsSet = true;
        }

        @JsonProperty(value="newPassword")
        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        @JsonProperty(value="roles")
        public void setRoles(ImmutableList<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="version")
        public void setVersion(Optional<String> version) {
            this.version = version;
        }

        @Override
        String username() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean ldap() {
            throw new UnsupportedOperationException();
        }

        @Override
        String newPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        Optional<String> version() {
            throw new UnsupportedOperationException();
        }
    }
}

