/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSlowThresholdOverrideDto;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigJsonService.TransactionConfigDto", generator="Immutables")
@Immutable
final class ImmutableTransactionConfigDto
extends ConfigJsonService.TransactionConfigDto {
    private final int slowThresholdMillis;
    private final int profilingIntervalMillis;
    private final boolean captureThreadStats;
    private final ImmutableList<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides;
    private final String version;

    private ImmutableTransactionConfigDto(int slowThresholdMillis, int profilingIntervalMillis, boolean captureThreadStats, ImmutableList<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides, String version) {
        this.slowThresholdMillis = slowThresholdMillis;
        this.profilingIntervalMillis = profilingIntervalMillis;
        this.captureThreadStats = captureThreadStats;
        this.slowThresholdOverrides = slowThresholdOverrides;
        this.version = version;
    }

    @Override
    @JsonProperty(value="slowThresholdMillis")
    int slowThresholdMillis() {
        return this.slowThresholdMillis;
    }

    @Override
    @JsonProperty(value="profilingIntervalMillis")
    int profilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    @Override
    @JsonProperty(value="captureThreadStats")
    boolean captureThreadStats() {
        return this.captureThreadStats;
    }

    @JsonProperty(value="slowThresholdOverrides")
    ImmutableList<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides() {
        return this.slowThresholdOverrides;
    }

    @Override
    @JsonProperty(value="version")
    String version() {
        return this.version;
    }

    public final ImmutableTransactionConfigDto withSlowThresholdMillis(int value) {
        if (this.slowThresholdMillis == value) {
            return this;
        }
        return new ImmutableTransactionConfigDto(value, this.profilingIntervalMillis, this.captureThreadStats, this.slowThresholdOverrides, this.version);
    }

    public final ImmutableTransactionConfigDto withProfilingIntervalMillis(int value) {
        if (this.profilingIntervalMillis == value) {
            return this;
        }
        return new ImmutableTransactionConfigDto(this.slowThresholdMillis, value, this.captureThreadStats, this.slowThresholdOverrides, this.version);
    }

    public final ImmutableTransactionConfigDto withCaptureThreadStats(boolean value) {
        if (this.captureThreadStats == value) {
            return this;
        }
        return new ImmutableTransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, value, this.slowThresholdOverrides, this.version);
    }

    public final ImmutableTransactionConfigDto withSlowThresholdOverrides(ImmutableSlowThresholdOverrideDto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, (ImmutableList<ImmutableSlowThresholdOverrideDto>)newValue, this.version);
    }

    public final ImmutableTransactionConfigDto withSlowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverrideDto> elements) {
        if (this.slowThresholdOverrides == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, (ImmutableList<ImmutableSlowThresholdOverrideDto>)newValue, this.version);
    }

    public final ImmutableTransactionConfigDto withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableTransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, this.slowThresholdOverrides, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionConfigDto && this.equalTo(0, (ImmutableTransactionConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransactionConfigDto another) {
        return this.slowThresholdMillis == another.slowThresholdMillis && this.profilingIntervalMillis == another.profilingIntervalMillis && this.captureThreadStats == another.captureThreadStats && this.slowThresholdOverrides.equals(another.slowThresholdOverrides) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.slowThresholdMillis;
        h += (h << 5) + this.profilingIntervalMillis;
        h += (h << 5) + Booleans.hashCode((boolean)this.captureThreadStats);
        h += (h << 5) + this.slowThresholdOverrides.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionConfigDto").omitNullValues().add("slowThresholdMillis", this.slowThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("captureThreadStats", this.captureThreadStats).add("slowThresholdOverrides", this.slowThresholdOverrides).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionConfigDto fromJson(Json json) {
        Builder builder = ImmutableTransactionConfigDto.builder();
        if (json.slowThresholdMillisIsSet) {
            builder.slowThresholdMillis(json.slowThresholdMillis);
        }
        if (json.profilingIntervalMillisIsSet) {
            builder.profilingIntervalMillis(json.profilingIntervalMillis);
        }
        if (json.captureThreadStatsIsSet) {
            builder.captureThreadStats(json.captureThreadStats);
        }
        if (json.slowThresholdOverrides != null) {
            builder.addAllSlowThresholdOverrides(json.slowThresholdOverrides);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableTransactionConfigDto copyOf(ConfigJsonService.TransactionConfigDto instance) {
        if (instance instanceof ImmutableTransactionConfigDto) {
            return (ImmutableTransactionConfigDto)instance;
        }
        return ImmutableTransactionConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigJsonService.TransactionConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SLOW_THRESHOLD_MILLIS = 1L;
        private static final long INIT_BIT_PROFILING_INTERVAL_MILLIS = 2L;
        private static final long INIT_BIT_CAPTURE_THREAD_STATS = 4L;
        private static final long INIT_BIT_VERSION = 8L;
        private long initBits = 15L;
        private int slowThresholdMillis;
        private int profilingIntervalMillis;
        private boolean captureThreadStats;
        private ImmutableList.Builder<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigJsonService.TransactionConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.slowThresholdMillis(instance.slowThresholdMillis());
            this.profilingIntervalMillis(instance.profilingIntervalMillis());
            this.captureThreadStats(instance.captureThreadStats());
            this.addAllSlowThresholdOverrides(instance.slowThresholdOverrides());
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder slowThresholdMillis(int slowThresholdMillis) {
            this.slowThresholdMillis = slowThresholdMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder captureThreadStats(boolean captureThreadStats) {
            this.captureThreadStats = captureThreadStats;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSlowThresholdOverrides(ImmutableSlowThresholdOverrideDto element) {
            this.slowThresholdOverrides.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSlowThresholdOverrides(ImmutableSlowThresholdOverrideDto ... elements) {
            this.slowThresholdOverrides.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder slowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverrideDto> elements) {
            this.slowThresholdOverrides = ImmutableList.builder();
            return this.addAllSlowThresholdOverrides(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSlowThresholdOverrides(Iterable<? extends ImmutableSlowThresholdOverrideDto> elements) {
            this.slowThresholdOverrides.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTransactionConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionConfigDto(this.slowThresholdMillis, this.profilingIntervalMillis, this.captureThreadStats, this.slowThresholdOverrides.build(), this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("slowThresholdMillis");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("profilingIntervalMillis");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("captureThreadStats");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build TransactionConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigJsonService.TransactionConfigDto", generator="Immutables")
    static final class Json
    extends ConfigJsonService.TransactionConfigDto {
        int slowThresholdMillis;
        boolean slowThresholdMillisIsSet;
        int profilingIntervalMillis;
        boolean profilingIntervalMillisIsSet;
        boolean captureThreadStats;
        boolean captureThreadStatsIsSet;
        @Nullable
        List<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides = ImmutableList.of();
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="slowThresholdMillis")
        public void setSlowThresholdMillis(int slowThresholdMillis) {
            this.slowThresholdMillis = slowThresholdMillis;
            this.slowThresholdMillisIsSet = true;
        }

        @JsonProperty(value="profilingIntervalMillis")
        public void setProfilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.profilingIntervalMillisIsSet = true;
        }

        @JsonProperty(value="captureThreadStats")
        public void setCaptureThreadStats(boolean captureThreadStats) {
            this.captureThreadStats = captureThreadStats;
            this.captureThreadStatsIsSet = true;
        }

        @JsonProperty(value="slowThresholdOverrides")
        public void setSlowThresholdOverrides(List<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides) {
            this.slowThresholdOverrides = slowThresholdOverrides;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        int slowThresholdMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        int profilingIntervalMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean captureThreadStats() {
            throw new UnsupportedOperationException();
        }

        @Override
        List<ImmutableSlowThresholdOverrideDto> slowThresholdOverrides() {
            throw new UnsupportedOperationException();
        }

        @Override
        String version() {
            throw new UnsupportedOperationException();
        }
    }
}

