/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConditionalHttpContentCompressor;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpServerHandler;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.com.google.common.base.Supplier;
import org.glowroot.agent.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glowroot.agent.shaded.io.netty.bootstrap.ServerBootstrap;
import org.glowroot.agent.shaded.io.netty.channel.Channel;
import org.glowroot.agent.shaded.io.netty.channel.ChannelHandler;
import org.glowroot.agent.shaded.io.netty.channel.ChannelInitializer;
import org.glowroot.agent.shaded.io.netty.channel.ChannelPipeline;
import org.glowroot.agent.shaded.io.netty.channel.EventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.socket.SocketChannel;
import org.glowroot.agent.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpServerCodec;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContext;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.glowroot.agent.shaded.io.netty.handler.stream.ChunkedWriteHandler;
import org.glowroot.agent.shaded.io.netty.util.concurrent.Future;
import org.glowroot.agent.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import org.glowroot.agent.shaded.io.netty.util.internal.logging.Slf4JLoggerFactory;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class HttpServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpServer.class);
    private static final Logger startupLogger = LoggerFactory.getLogger((String)"org.glowroot");
    private final ServerBootstrap bootstrap;
    private final HttpServerHandler handler;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final String bindAddress;
    private final List<File> confDirs;
    private final boolean offlineViewer;
    private volatile @Nullable SslContext sslContext;
    private volatile @MonotonicNonNull Channel serverChannel;
    private volatile @MonotonicNonNull Integer port;

    HttpServer(String bindAddress, boolean https, Supplier<String> contextPathSupplier, int numWorkerThreads, CommonHandler commonHandler, List<File> confDirs, boolean central, boolean offlineViewer) throws Exception {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        ThreadFactory bossThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Glowroot-Http-Boss").build();
        ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Glowroot-Http-Worker-%d").build();
        this.bossGroup = new NioEventLoopGroup(1, bossThreadFactory);
        this.workerGroup = new NioEventLoopGroup(numWorkerThreads, workerThreadFactory);
        final HttpServerHandler handler = new HttpServerHandler(contextPathSupplier, commonHandler);
        if (https) {
            File privateKeyFile;
            File certificateFile;
            HttpServer.renameHttpsConfFileIfNeeded(confDirs, "certificate.pem", "ui-cert.pem", "certificate");
            HttpServer.renameHttpsConfFileIfNeeded(confDirs, "private.pem", "ui-key.pem", "private key");
            if (central) {
                certificateFile = HttpServer.getRequiredHttpsConfFile(confDirs.get(0), "ui-cert.pem", "cert.pem", "certificate");
                privateKeyFile = HttpServer.getRequiredHttpsConfFile(confDirs.get(0), "ui-key.pem", "key.pem", "private key");
            } else {
                certificateFile = HttpServer.getRequiredHttpsConfFile(confDirs, "ui-cert.pem");
                privateKeyFile = HttpServer.getRequiredHttpsConfFile(confDirs, "ui-key.pem");
            }
            this.sslContext = SslContextBuilder.forServer((File)certificateFile, (File)privateKeyFile).build();
        }
        this.confDirs = confDirs;
        this.offlineViewer = offlineViewer;
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                SslContext sslContextLocal = HttpServer.this.sslContext;
                if (sslContextLocal != null) {
                    p.addLast(new ChannelHandler[]{sslContextLocal.newHandler(ch.alloc())});
                }
                p.addLast(new ChannelHandler[]{new HttpServerCodec(65536, 65536, 8192)});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                p.addLast(new ChannelHandler[]{new ConditionalHttpContentCompressor()});
                p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                p.addLast(new ChannelHandler[]{handler});
            }
        });
        this.handler = handler;
        this.bindAddress = bindAddress;
    }

    void bindEventually(int port) {
        try {
            this.serverChannel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.bindAddress, port)).sync().channel();
            this.onBindSuccess();
        }
        catch (Exception e) {
            startupLogger.error("Error binding to {}:{}, the UI is not available (will keep trying to bind...): {}", new Object[]{this.bindAddress, port, e.getMessage()});
            logger.debug(e.getMessage(), (Throwable)e);
            Thread thread = new Thread(new BindEventually(port));
            thread.setName("Glowroot-Init-Bind");
            thread.setDaemon(true);
            thread.start();
        }
    }

    @RequiresNonNull(value={"serverChannel"})
    private void onBindSuccess() {
        String optionalHttps;
        this.port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        String listener = this.offlineViewer ? "Offline viewer" : "UI";
        String string = optionalHttps = this.sslContext == null ? "" : " (HTTPS)";
        if (this.bindAddress.equals("127.0.0.1")) {
            startupLogger.info("{} listening on {}:{}{} (to access the UI from remote machines, change the bind address to 0.0.0.0, either in the Glowroot UI under Configuration > Web or directly in the admin.json file, and then restart JVM to take effect)", new Object[]{listener, this.bindAddress, this.port, optionalHttps});
        } else {
            startupLogger.info("{} listening on {}:{}{}", new Object[]{listener, this.bindAddress, this.port, optionalHttps});
        }
    }

    String getBindAddress() {
        return this.bindAddress;
    }

    @Nullable Integer getPort() {
        return this.port;
    }

    boolean getHttps() {
        return this.sslContext != null;
    }

    void changePort(int newPort) throws Exception {
        Preconditions.checkNotNull((Object)this.serverChannel);
        Channel previousServerChannel = this.serverChannel;
        InetSocketAddress localAddress = new InetSocketAddress(this.bindAddress, newPort);
        try {
            this.serverChannel = this.bootstrap.bind((SocketAddress)localAddress).sync().channel();
        }
        catch (Exception e) {
            throw new PortChangeFailedException(e);
        }
        this.port = newPort;
        previousServerChannel.close().get();
        this.handler.closeAllButCurrent();
    }

    void changeProtocol(boolean https) throws Exception {
        this.sslContext = https ? SslContextBuilder.forServer((File)HttpServer.getRequiredHttpsConfFile(this.confDirs, "ui-cert.pem"), (File)HttpServer.getRequiredHttpsConfFile(this.confDirs, "ui-key.pem")).build() : null;
        this.handler.closeAllButCurrent();
    }

    void close() throws Exception {
        logger.debug("close(): stopping http server");
        Future workerShutdownFuture = this.workerGroup.shutdownGracefully(1L, 5L, TimeUnit.SECONDS);
        Future bossShutdownFuture = this.bossGroup.shutdownGracefully(1L, 5L, TimeUnit.SECONDS);
        Stopwatch stopwatch = Stopwatch.createStarted();
        workerShutdownFuture.get(10L, TimeUnit.SECONDS);
        long remainingMillis = Math.max(0L, 10000L - stopwatch.elapsed(TimeUnit.MILLISECONDS));
        bossShutdownFuture.get(remainingMillis, TimeUnit.MILLISECONDS);
        logger.debug("close(): http server stopped");
    }

    private static File getRequiredHttpsConfFile(List<File> confDirs, String fileName) throws FileNotFoundException {
        File confFile = HttpServer.getHttpsConfFile(confDirs, fileName);
        if (confFile == null) {
            StringBuilder sb = new StringBuilder("HTTPS is enabled, but " + fileName + " was not found under ");
            if (confDirs.size() == 2) {
                sb.append("either of ");
            } else if (confDirs.size() > 2) {
                sb.append("any of ");
            }
            for (int i = 0; i < confDirs.size(); ++i) {
                if (i > 0) {
                    sb.append(", '");
                }
                sb.append(confDirs.get(i).getAbsolutePath());
                sb.append("'");
            }
            throw new FileNotFoundException(sb.toString());
        }
        return confFile;
    }

    private static File getRequiredHttpsConfFile(File confDir, String fileName, String altFileName, String display) throws FileNotFoundException {
        File confFile = new File(confDir, fileName);
        if (confFile.exists()) {
            return confFile;
        }
        if (altFileName == null) {
            throw new FileNotFoundException("HTTPS is enabled, but " + fileName + " was not found under '" + confDir.getAbsolutePath() + "'");
        }
        File altConfFile = new File(confDir, altFileName);
        if (altConfFile.exists()) {
            return altConfFile;
        }
        throw new FileNotFoundException("HTTPS is enabled, but " + fileName + " (or " + altFileName + " if using the same " + display + " for both ui and grpc) was not found under '" + confDir.getAbsolutePath() + "'");
    }

    private static @Nullable File getHttpsConfFile(List<File> confDirs, String fileName) {
        for (File confDir : confDirs) {
            File confFile = new File(confDir, fileName);
            if (!confFile.exists()) continue;
            return confFile;
        }
        return null;
    }

    private static void renameHttpsConfFileIfNeeded(List<File> confDirs, String oldFileName, String newFileName, String display) throws IOException {
        for (File confDir : confDirs) {
            File newConfFile = new File(confDir, newFileName);
            if (newConfFile.exists()) {
                return;
            }
            File oldConfFile = new File(confDir, oldFileName);
            if (!oldConfFile.exists()) continue;
            HttpServer.rename(oldConfFile, newConfFile, display);
            return;
        }
    }

    private static void rename(File oldConfFile, File newConfFile, String display) throws IOException {
        if (oldConfFile.renameTo(newConfFile)) {
            throw new IOException("Unable to rename " + display + " file from '" + oldConfFile.getAbsolutePath() + "' to '" + newConfFile.getAbsolutePath() + "' as part of upgrade to 0.9.27 or later");
        }
    }

    static class PortChangeFailedException
    extends Exception {
        private PortChangeFailedException(Exception cause) {
            super(cause);
        }
    }

    private class BindEventually
    implements Runnable {
        private final int port;

        private BindEventually(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            long backoffMillis = 1000L;
            while (true) {
                try {
                    TimeUnit.MILLISECONDS.sleep(backoffMillis);
                }
                catch (InterruptedException f) {
                    Thread.currentThread().interrupt();
                    return;
                }
                backoffMillis = Math.min(backoffMillis * 2L, 60000L);
                try {
                    HttpServer.this.serverChannel = HttpServer.this.bootstrap.bind((SocketAddress)new InetSocketAddress(HttpServer.this.bindAddress, this.port)).sync().channel();
                    HttpServer.this.onBindSuccess();
                    return;
                }
                catch (Exception e) {
                    startupLogger.error("Error binding to {}:{}, the UI is not available (will keep trying to bind...): {}", new Object[]{HttpServer.this.bindAddress, this.port, e.getMessage()});
                    logger.debug(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

