/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.io.BaseEncoding;

public class Encryption {
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final BaseEncoding encoder = BaseEncoding.base64().omitPadding();

    private Encryption() {
    }

    public static String encrypt(String text, LazySecretKey lazySecretKey) throws Exception {
        SecretKey secretKey = lazySecretKey.getOrCreate();
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        Cipher aesCipherForEncryption = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipherForEncryption.init(1, (Key)secretKey, new IvParameterSpec(iv));
        byte[] encryptedBytes = aesCipherForEncryption.doFinal(text.getBytes(Charsets.UTF_8));
        return encoder.encode(encryptedBytes) + ':' + encoder.encode(iv);
    }

    public static String decrypt(String encrypted, LazySecretKey lazySecretKey) throws Exception {
        SecretKey secretKey = lazySecretKey.getExisting();
        if (secretKey == null) {
            throw new IllegalStateException("Cannot decrypt encrypted value, secret key is missing");
        }
        String[] parts = encrypted.split(":");
        byte[] encryptedText = encoder.decode((CharSequence)parts[0]);
        byte[] iv = encoder.decode((CharSequence)parts[1]);
        Cipher aesCipherForDecryption = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipherForDecryption.init(2, (Key)secretKey, new IvParameterSpec(iv));
        byte[] decryptedBytes = aesCipherForDecryption.doFinal(encryptedText);
        return new String(decryptedBytes, Charsets.UTF_8);
    }

    public static SecretKey generateNewKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        return keyGen.generateKey();
    }
}

