/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.List;
import java.util.Map;
import org.immutables.value.Value;

public interface RepoAdmin {
    public void runHealthCheck() throws Exception;

    public void defragH2Data() throws Exception;

    public void compactH2Data() throws Exception;

    public long getH2DataFileSize();

    public List<H2Table> analyzeH2DiskSpace() throws Exception;

    public TraceCounts analyzeTraceCounts() throws Exception;

    public void deleteAllData() throws Exception;

    public void resizeIfNeeded() throws Exception;

    public int updateCassandraTwcsWindowSizes() throws Exception;

    public List<CassandraWriteTotals> getCassandraWriteTotalsPerTable(int var1);

    public List<CassandraWriteTotals> getCassandraWriteTotalsPerAgentRollup(String var1, int var2);

    public List<CassandraWriteTotals> getCassandraWriteTotalsPerTransactionType(String var1, String var2, int var3);

    public List<CassandraWriteTotals> getCassandraWriteTotalsPerTransactionName(String var1, String var2, String var3, int var4);

    @Value.Immutable
    public static interface CassandraWriteTotals {
        public String display();

        public long rowsWritten();

        public long bytesWritten();

        public Map<String, Long> bytesWrittenPerColumn();

        public boolean drilldown();
    }

    @Value.Immutable
    public static interface TraceCount {
        public String transactionType();

        public String transactionName();

        public long count();

        public long errorCount();
    }

    @Value.Immutable
    public static interface TraceOverallCount {
        public String transactionType();

        public long count();

        public long errorCount();
    }

    @Value.Immutable
    public static interface TraceCounts {
        public List<TraceOverallCount> overallCounts();

        public List<TraceCount> counts();
    }

    @Value.Immutable
    public static interface H2Table {
        public String name();

        public long bytes();

        public long rows();
    }
}

