/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableThreadStats;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.MutableTimer;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableOverviewAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutablePercentileAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableProfile;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;

@Styles.Private
public class MutableAggregate {
    private double totalDurationNanos;
    private long transactionCount;
    private long errorCount;
    private boolean asyncTransactions;
    private final List<MutableTimer> mainThreadRootTimers = Lists.newArrayList();
    private final MutableThreadStats mainThreadStats = new MutableThreadStats();
    private final List<MutableTimer> asyncTimers = Lists.newArrayList();
    private final LazyHistogram durationNanosHistogram = new LazyHistogram();
    private @MonotonicNonNull MutableTimer auxThreadRootTimer;
    private @MonotonicNonNull MutableThreadStats auxThreadStats;
    private @MonotonicNonNull QueryCollector queries;
    private @MonotonicNonNull ServiceCallCollector serviceCalls;
    private @MonotonicNonNull MutableProfile mainThreadProfile;
    private @MonotonicNonNull MutableProfile auxThreadProfile;
    private final int maxQueryAggregates;
    private final int maxServiceCallAggregates;

    public MutableAggregate(int maxQueryAggregates, int maxServiceCallAggregates) {
        this.maxQueryAggregates = maxQueryAggregates;
        this.maxServiceCallAggregates = maxServiceCallAggregates;
    }

    public double getTotalDurationNanos() {
        return this.totalDurationNanos;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public boolean isAsyncTransactions() {
        return this.asyncTransactions;
    }

    public List<AggregateOuterClass.Aggregate.Timer> getMainThreadRootTimersProto() {
        return MutableAggregate.toProto(this.mainThreadRootTimers);
    }

    public MutableThreadStats getMainThreadStats() {
        return this.mainThreadStats;
    }

    public AggregateOuterClass.Aggregate.Timer getAuxThreadRootTimerProto() {
        if (this.auxThreadRootTimer == null) {
            return null;
        }
        return this.auxThreadRootTimer.toProto();
    }

    public @Nullable MutableThreadStats getAuxThreadStats() {
        return this.auxThreadStats;
    }

    public List<AggregateOuterClass.Aggregate.Timer> getAsyncTimersProto() {
        return MutableAggregate.toProto(this.asyncTimers);
    }

    public LazyHistogram getDurationNanosHistogram() {
        return this.durationNanosHistogram;
    }

    public @Nullable QueryCollector getQueries() {
        return this.queries;
    }

    public @Nullable ServiceCallCollector getServiceCalls() {
        return this.serviceCalls;
    }

    public @Nullable MutableProfile getMainThreadProfile() {
        return this.mainThreadProfile;
    }

    public @Nullable MutableProfile getAuxThreadProfile() {
        return this.auxThreadProfile;
    }

    public boolean isEmpty() {
        return this.transactionCount == 0L;
    }

    public void addTotalDurationNanos(double totalDurationNanos) {
        this.totalDurationNanos += totalDurationNanos;
    }

    public void addTransactionCount(long transactionCount) {
        this.transactionCount += transactionCount;
    }

    public void addErrorCount(long errorCount) {
        this.errorCount += errorCount;
    }

    public void addAsyncTransactions(boolean asyncTransactions) {
        if (asyncTransactions) {
            this.asyncTransactions = true;
        }
    }

    public void mergeMainThreadRootTimers(List<AggregateOuterClass.Aggregate.Timer> toBeMergedMainThreadRootTimers) {
        MutableAggregate.mergeRootTimers(toBeMergedMainThreadRootTimers, this.mainThreadRootTimers);
    }

    public void mergeMainThreadStats(AggregateOuterClass.Aggregate.ThreadStats threadStats) {
        this.mainThreadStats.addThreadStats(threadStats);
    }

    public void addMainThreadTotalCpuNanos(double totalCpuNanos) {
        this.mainThreadStats.addTotalCpuNanos(totalCpuNanos);
    }

    public void addMainThreadTotalBlockedNanos(double totalBlockedNanos) {
        this.mainThreadStats.addTotalBlockedNanos(totalBlockedNanos);
    }

    public void addMainThreadTotalWaitedNanos(double totalWaitedNanos) {
        this.mainThreadStats.addTotalWaitedNanos(totalWaitedNanos);
    }

    public void addMainThreadTotalAllocatedBytes(double totalAllocatedBytes) {
        this.mainThreadStats.addTotalAllocatedBytes(totalAllocatedBytes);
    }

    public void mergeAuxThreadRootTimer(AggregateOuterClass.Aggregate.Timer toBeMergedAuxThreadRootTimer) {
        if (this.auxThreadRootTimer == null) {
            this.auxThreadRootTimer = MutableTimer.createAuxThreadRootTimer();
        }
        this.auxThreadRootTimer.merge(toBeMergedAuxThreadRootTimer);
    }

    public void mergeAuxThreadStats(AggregateOuterClass.Aggregate.ThreadStats threadStats) {
        if (this.auxThreadStats == null) {
            this.auxThreadStats = new MutableThreadStats();
        }
        this.auxThreadStats.addThreadStats(threadStats);
    }

    public void addAuxThreadTotalCpuNanos(double totalCpuNanos) {
        if (this.auxThreadStats == null) {
            this.auxThreadStats = new MutableThreadStats();
        }
        this.auxThreadStats.addTotalCpuNanos(totalCpuNanos);
    }

    public void addAuxThreadTotalBlockedNanos(double totalBlockedNanos) {
        if (this.auxThreadStats == null) {
            this.auxThreadStats = new MutableThreadStats();
        }
        this.auxThreadStats.addTotalBlockedNanos(totalBlockedNanos);
    }

    public void addAuxThreadTotalWaitedNanos(double totalWaitedNanos) {
        if (this.auxThreadStats == null) {
            this.auxThreadStats = new MutableThreadStats();
        }
        this.auxThreadStats.addTotalWaitedNanos(totalWaitedNanos);
    }

    public void addAuxThreadTotalAllocatedBytes(double totalAllocatedBytes) {
        if (this.auxThreadStats == null) {
            this.auxThreadStats = new MutableThreadStats();
        }
        this.auxThreadStats.addTotalAllocatedBytes(totalAllocatedBytes);
    }

    public void mergeAsyncTimers(List<AggregateOuterClass.Aggregate.Timer> toBeMergedAsyncTimers) {
        MutableAggregate.mergeRootTimers(toBeMergedAsyncTimers, this.asyncTimers);
    }

    public void mergeDurationNanosHistogram(AggregateOuterClass.Aggregate.Histogram toBeMergedDurationNanosHistogram) {
        this.durationNanosHistogram.merge(toBeMergedDurationNanosHistogram);
    }

    public LiveAggregateRepository.OverviewAggregate toOverviewAggregate(long captureTime) {
        ImmutableOverviewAggregate.Builder builder = ImmutableOverviewAggregate.builder().captureTime(captureTime).totalDurationNanos(this.totalDurationNanos).transactionCount(this.transactionCount).asyncTransactions(this.asyncTransactions).mainThreadRootTimers(MutableAggregate.toProto(this.mainThreadRootTimers)).mainThreadStats(this.mainThreadStats.toProto()).asyncTimers(MutableAggregate.toProto(this.asyncTimers));
        if (this.auxThreadRootTimer != null) {
            builder.auxThreadRootTimer(this.auxThreadRootTimer.toProto());
            builder.auxThreadStats(((MutableThreadStats)Preconditions.checkNotNull((Object)this.auxThreadStats)).toProto());
        }
        return builder.build();
    }

    public LiveAggregateRepository.PercentileAggregate toPercentileAggregate(long captureTime) {
        return ImmutablePercentileAggregate.builder().captureTime(captureTime).totalDurationNanos(this.totalDurationNanos).transactionCount(this.transactionCount).durationNanosHistogram(this.durationNanosHistogram.toProto(new LazyHistogram.ScratchBuffer())).build();
    }

    public void mergeQuery(String queryType, String truncatedQueryText, @Nullable String fullQueryTextSha1, double totalDurationNanos, long executionCount, boolean hasTotalRows, long totalRows) {
        if (this.queries == null) {
            this.queries = new QueryCollector(this.maxQueryAggregates);
        }
        this.queries.mergeQuery(queryType, truncatedQueryText, fullQueryTextSha1, totalDurationNanos, executionCount, hasTotalRows, totalRows);
    }

    public void mergeServiceCall(String serviceCallType, String serviceCallText, double totalDurationNanos, long executionCount) {
        if (this.serviceCalls == null) {
            this.serviceCalls = new ServiceCallCollector(this.maxServiceCallAggregates);
        }
        this.serviceCalls.mergeServiceCall(serviceCallType, serviceCallText, totalDurationNanos, executionCount);
    }

    public void mergeMainThreadProfile(ProfileOuterClass.Profile toBeMergedProfile) {
        if (this.mainThreadProfile == null) {
            this.mainThreadProfile = new MutableProfile();
        }
        this.mainThreadProfile.merge(toBeMergedProfile);
    }

    public void mergeAuxThreadProfile(ProfileOuterClass.Profile toBeMergedProfile) {
        if (this.auxThreadProfile == null) {
            this.auxThreadProfile = new MutableProfile();
        }
        this.auxThreadProfile.merge(toBeMergedProfile);
    }

    public static void mergeRootTimers(List<AggregateOuterClass.Aggregate.Timer> toBeMergedRootTimers, List<MutableTimer> rootTimers) {
        for (AggregateOuterClass.Aggregate.Timer toBeMergedRootTimer : toBeMergedRootTimers) {
            MutableAggregate.mergeRootTimer(toBeMergedRootTimer, rootTimers);
        }
    }

    public static List<AggregateOuterClass.Aggregate.Timer> toProto(List<MutableTimer> rootTimers) {
        ArrayList protobufRootTimers = Lists.newArrayListWithCapacity((int)rootTimers.size());
        for (MutableTimer rootTimer : rootTimers) {
            protobufRootTimers.add(rootTimer.toProto());
        }
        return protobufRootTimers;
    }

    private static void mergeRootTimer(AggregateOuterClass.Aggregate.Timer toBeMergedRootTimer, List<MutableTimer> rootTimers) {
        for (MutableTimer rootTimer : rootTimers) {
            if (!toBeMergedRootTimer.getName().equals(rootTimer.getName())) continue;
            rootTimer.merge(toBeMergedRootTimer);
            return;
        }
        MutableTimer rootTimer = MutableTimer.createRootTimer(toBeMergedRootTimer.getName(), toBeMergedRootTimer.getExtended());
        rootTimer.merge(toBeMergedRootTimer);
        rootTimers.add(rootTimer);
    }
}

