/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.WebConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EmbeddedWebConfig", generator="Immutables")
@Immutable
public final class ImmutableEmbeddedWebConfig
extends EmbeddedWebConfig {
    private final int port;
    private final String bindAddress;
    private final boolean https;
    private final String contextPath;
    private final int sessionTimeoutMinutes;
    private final String sessionCookieName;
    private final transient String version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEmbeddedWebConfig(Builder builder) {
        if (builder.portIsSet()) {
            this.initShim.port(builder.port);
        }
        if (builder.bindAddress != null) {
            this.initShim.bindAddress(builder.bindAddress);
        }
        if (builder.httpsIsSet()) {
            this.initShim.https(builder.https);
        }
        if (builder.contextPath != null) {
            this.initShim.contextPath(builder.contextPath);
        }
        if (builder.sessionTimeoutMinutesIsSet()) {
            this.initShim.sessionTimeoutMinutes(builder.sessionTimeoutMinutes);
        }
        if (builder.sessionCookieName != null) {
            this.initShim.sessionCookieName(builder.sessionCookieName);
        }
        this.port = this.initShim.port();
        this.bindAddress = this.initShim.bindAddress();
        this.https = this.initShim.https();
        this.contextPath = this.initShim.contextPath();
        this.sessionTimeoutMinutes = this.initShim.sessionTimeoutMinutes();
        this.sessionCookieName = this.initShim.sessionCookieName();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    private ImmutableEmbeddedWebConfig(int port, String bindAddress, boolean https, String contextPath, int sessionTimeoutMinutes, String sessionCookieName) {
        this.initShim.port(port);
        this.initShim.bindAddress(bindAddress);
        this.initShim.https(https);
        this.initShim.contextPath(contextPath);
        this.initShim.sessionTimeoutMinutes(sessionTimeoutMinutes);
        this.initShim.sessionCookieName(sessionCookieName);
        this.port = this.initShim.port();
        this.bindAddress = this.initShim.bindAddress();
        this.https = this.initShim.https();
        this.contextPath = this.initShim.contextPath();
        this.sessionTimeoutMinutes = this.initShim.sessionTimeoutMinutes();
        this.sessionCookieName = this.initShim.sessionCookieName();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="port")
    public int port() {
        InitShim shim = this.initShim;
        return shim != null ? shim.port() : this.port;
    }

    @Override
    @JsonProperty(value="bindAddress")
    public String bindAddress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bindAddress() : this.bindAddress;
    }

    @Override
    @JsonProperty(value="https")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public boolean https() {
        InitShim shim = this.initShim;
        return shim != null ? shim.https() : this.https;
    }

    @Override
    @JsonProperty(value="contextPath")
    public String contextPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contextPath() : this.contextPath;
    }

    @Override
    @JsonProperty(value="sessionTimeoutMinutes")
    public int sessionTimeoutMinutes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sessionTimeoutMinutes() : this.sessionTimeoutMinutes;
    }

    @Override
    @JsonProperty(value="sessionCookieName")
    public String sessionCookieName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sessionCookieName() : this.sessionCookieName;
    }

    @Override
    @JsonProperty(value="version")
    @JsonIgnore
    public String version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    public final ImmutableEmbeddedWebConfig withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableEmbeddedWebConfig(value, this.bindAddress, this.https, this.contextPath, this.sessionTimeoutMinutes, this.sessionCookieName);
    }

    public final ImmutableEmbeddedWebConfig withBindAddress(String value) {
        String newValue = Objects.requireNonNull(value, "bindAddress");
        if (this.bindAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableEmbeddedWebConfig(this.port, newValue, this.https, this.contextPath, this.sessionTimeoutMinutes, this.sessionCookieName);
    }

    public final ImmutableEmbeddedWebConfig withHttps(boolean value) {
        if (this.https == value) {
            return this;
        }
        return new ImmutableEmbeddedWebConfig(this.port, this.bindAddress, value, this.contextPath, this.sessionTimeoutMinutes, this.sessionCookieName);
    }

    public final ImmutableEmbeddedWebConfig withContextPath(String value) {
        String newValue = Objects.requireNonNull(value, "contextPath");
        if (this.contextPath.equals(newValue)) {
            return this;
        }
        return new ImmutableEmbeddedWebConfig(this.port, this.bindAddress, this.https, newValue, this.sessionTimeoutMinutes, this.sessionCookieName);
    }

    public final ImmutableEmbeddedWebConfig withSessionTimeoutMinutes(int value) {
        if (this.sessionTimeoutMinutes == value) {
            return this;
        }
        return new ImmutableEmbeddedWebConfig(this.port, this.bindAddress, this.https, this.contextPath, value, this.sessionCookieName);
    }

    public final ImmutableEmbeddedWebConfig withSessionCookieName(String value) {
        String newValue = Objects.requireNonNull(value, "sessionCookieName");
        if (this.sessionCookieName.equals(newValue)) {
            return this;
        }
        return new ImmutableEmbeddedWebConfig(this.port, this.bindAddress, this.https, this.contextPath, this.sessionTimeoutMinutes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmbeddedWebConfig && this.equalTo(0, (ImmutableEmbeddedWebConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmbeddedWebConfig another) {
        return this.port == another.port && this.bindAddress.equals(another.bindAddress) && this.https == another.https && this.contextPath.equals(another.contextPath) && this.sessionTimeoutMinutes == another.sessionTimeoutMinutes && this.sessionCookieName.equals(another.sessionCookieName) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.port;
        h += (h << 5) + this.bindAddress.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.https);
        h += (h << 5) + this.contextPath.hashCode();
        h += (h << 5) + this.sessionTimeoutMinutes;
        h += (h << 5) + this.sessionCookieName.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EmbeddedWebConfig").omitNullValues().add("port", this.port).add("bindAddress", (Object)this.bindAddress).add("https", this.https).add("contextPath", (Object)this.contextPath).add("sessionTimeoutMinutes", this.sessionTimeoutMinutes).add("sessionCookieName", (Object)this.sessionCookieName).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEmbeddedWebConfig fromJson(Json json) {
        Builder builder = ImmutableEmbeddedWebConfig.builder();
        if (json.portIsSet) {
            builder.port(json.port);
        }
        if (json.bindAddress != null) {
            builder.bindAddress(json.bindAddress);
        }
        if (json.httpsIsSet) {
            builder.https(json.https);
        }
        if (json.contextPath != null) {
            builder.contextPath(json.contextPath);
        }
        if (json.sessionTimeoutMinutesIsSet) {
            builder.sessionTimeoutMinutes(json.sessionTimeoutMinutes);
        }
        if (json.sessionCookieName != null) {
            builder.sessionCookieName(json.sessionCookieName);
        }
        return builder.build();
    }

    public static ImmutableEmbeddedWebConfig copyOf(EmbeddedWebConfig instance) {
        if (instance instanceof ImmutableEmbeddedWebConfig) {
            return (ImmutableEmbeddedWebConfig)instance;
        }
        return ImmutableEmbeddedWebConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EmbeddedWebConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_PORT = 1L;
        private static final long OPT_BIT_HTTPS = 2L;
        private static final long OPT_BIT_SESSION_TIMEOUT_MINUTES = 4L;
        private long optBits;
        private int port;
        @Nullable
        private String bindAddress;
        private boolean https;
        @Nullable
        private String contextPath;
        private int sessionTimeoutMinutes;
        @Nullable
        private String sessionCookieName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(WebConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(EmbeddedWebConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            WebConfig instance;
            if (object instanceof WebConfig) {
                instance = (WebConfig)object;
                this.sessionCookieName(instance.sessionCookieName());
                this.sessionTimeoutMinutes(instance.sessionTimeoutMinutes());
            }
            if (object instanceof EmbeddedWebConfig) {
                instance = (EmbeddedWebConfig)object;
                this.contextPath(((EmbeddedWebConfig)instance).contextPath());
                this.https(((EmbeddedWebConfig)instance).https());
                this.port(((EmbeddedWebConfig)instance).port());
                this.bindAddress(((EmbeddedWebConfig)instance).bindAddress());
            }
        }

        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = port;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bindAddress(String bindAddress) {
            this.bindAddress = Objects.requireNonNull(bindAddress, "bindAddress");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder https(boolean https) {
            this.https = https;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contextPath(String contextPath) {
            this.contextPath = Objects.requireNonNull(contextPath, "contextPath");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sessionTimeoutMinutes(int sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = Objects.requireNonNull(sessionCookieName, "sessionCookieName");
            return this;
        }

        public ImmutableEmbeddedWebConfig build() {
            return new ImmutableEmbeddedWebConfig(this);
        }

        private boolean portIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean httpsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean sessionTimeoutMinutesIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EmbeddedWebConfig", generator="Immutables")
    static final class Json
    extends EmbeddedWebConfig {
        int port;
        boolean portIsSet;
        @Nullable
        String bindAddress;
        boolean https;
        boolean httpsIsSet;
        @Nullable
        String contextPath;
        int sessionTimeoutMinutes;
        boolean sessionTimeoutMinutesIsSet;
        @Nullable
        String sessionCookieName;

        Json() {
        }

        @JsonProperty(value="port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @JsonProperty(value="bindAddress")
        public void setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
        }

        @JsonProperty(value="https")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setHttps(boolean https) {
            this.https = https;
            this.httpsIsSet = true;
        }

        @JsonProperty(value="contextPath")
        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        @JsonProperty(value="sessionTimeoutMinutes")
        public void setSessionTimeoutMinutes(int sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            this.sessionTimeoutMinutesIsSet = true;
        }

        @JsonProperty(value="sessionCookieName")
        public void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        @Override
        public int port() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String bindAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean https() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String contextPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int sessionTimeoutMinutes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sessionCookieName() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String version() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="EmbeddedWebConfig", generator="Immutables")
    private final class InitShim {
        private byte portBuildStage = 0;
        private int port;
        private byte bindAddressBuildStage = 0;
        private String bindAddress;
        private byte httpsBuildStage = 0;
        private boolean https;
        private byte contextPathBuildStage = 0;
        private String contextPath;
        private byte sessionTimeoutMinutesBuildStage = 0;
        private int sessionTimeoutMinutes;
        private byte sessionCookieNameBuildStage = 0;
        private String sessionCookieName;
        private byte versionBuildStage = 0;
        private String version;

        private InitShim() {
        }

        int port() {
            if (this.portBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.portBuildStage == 0) {
                this.portBuildStage = (byte)-1;
                this.port = ImmutableEmbeddedWebConfig.super.port();
                this.portBuildStage = 1;
            }
            return this.port;
        }

        void port(int port) {
            this.port = port;
            this.portBuildStage = 1;
        }

        String bindAddress() {
            if (this.bindAddressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bindAddressBuildStage == 0) {
                this.bindAddressBuildStage = (byte)-1;
                this.bindAddress = Objects.requireNonNull(ImmutableEmbeddedWebConfig.super.bindAddress(), "bindAddress");
                this.bindAddressBuildStage = 1;
            }
            return this.bindAddress;
        }

        void bindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            this.bindAddressBuildStage = 1;
        }

        boolean https() {
            if (this.httpsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.httpsBuildStage == 0) {
                this.httpsBuildStage = (byte)-1;
                this.https = ImmutableEmbeddedWebConfig.super.https();
                this.httpsBuildStage = 1;
            }
            return this.https;
        }

        void https(boolean https) {
            this.https = https;
            this.httpsBuildStage = 1;
        }

        String contextPath() {
            if (this.contextPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contextPathBuildStage == 0) {
                this.contextPathBuildStage = (byte)-1;
                this.contextPath = Objects.requireNonNull(ImmutableEmbeddedWebConfig.super.contextPath(), "contextPath");
                this.contextPathBuildStage = 1;
            }
            return this.contextPath;
        }

        void contextPath(String contextPath) {
            this.contextPath = contextPath;
            this.contextPathBuildStage = 1;
        }

        int sessionTimeoutMinutes() {
            if (this.sessionTimeoutMinutesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sessionTimeoutMinutesBuildStage == 0) {
                this.sessionTimeoutMinutesBuildStage = (byte)-1;
                this.sessionTimeoutMinutes = ImmutableEmbeddedWebConfig.super.sessionTimeoutMinutes();
                this.sessionTimeoutMinutesBuildStage = 1;
            }
            return this.sessionTimeoutMinutes;
        }

        void sessionTimeoutMinutes(int sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            this.sessionTimeoutMinutesBuildStage = 1;
        }

        String sessionCookieName() {
            if (this.sessionCookieNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sessionCookieNameBuildStage == 0) {
                this.sessionCookieNameBuildStage = (byte)-1;
                this.sessionCookieName = Objects.requireNonNull(ImmutableEmbeddedWebConfig.super.sessionCookieName(), "sessionCookieName");
                this.sessionCookieNameBuildStage = 1;
            }
            return this.sessionCookieName;
        }

        void sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            this.sessionCookieNameBuildStage = 1;
        }

        String version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableEmbeddedWebConfig.super.version(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.portBuildStage == -1) {
                attributes.add("port");
            }
            if (this.bindAddressBuildStage == -1) {
                attributes.add("bindAddress");
            }
            if (this.httpsBuildStage == -1) {
                attributes.add("https");
            }
            if (this.contextPathBuildStage == -1) {
                attributes.add("contextPath");
            }
            if (this.sessionTimeoutMinutesBuildStage == -1) {
                attributes.add("sessionTimeoutMinutes");
            }
            if (this.sessionCookieNameBuildStage == -1) {
                attributes.add("sessionCookieName");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            return "Cannot build EmbeddedWebConfig, attribute initializers form cycle " + attributes;
        }
    }
}

