/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.StorageConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.immutables.value.Value;

@Value.Immutable
public abstract class EmbeddedStorageConfig
implements StorageConfig {
    private static final ImmutableList<Integer> DEFAULT_ROLLUP_EXPIRATION_HOURS = ImmutableList.of((Object)72, (Object)336, (Object)2160, (Object)2160);
    private static final ImmutableList<Integer> DEFAULT_CAPPED_DATABASE_SIZES_MB = ImmutableList.of((Object)500, (Object)500, (Object)500, (Object)500);

    @Override
    @Value.Default
    public ImmutableList<Integer> rollupExpirationHours() {
        return DEFAULT_ROLLUP_EXPIRATION_HOURS;
    }

    @Override
    @JsonIgnore
    @Value.Derived
    public ImmutableList<Integer> queryAndServiceCallRollupExpirationHours() {
        return this.rollupExpirationHours();
    }

    @Override
    @JsonIgnore
    @Value.Derived
    public ImmutableList<Integer> profileRollupExpirationHours() {
        return this.rollupExpirationHours();
    }

    @Override
    @Value.Default
    public int traceExpirationHours() {
        return 336;
    }

    @Value.Default
    public int fullQueryTextExpirationHours() {
        return 336;
    }

    @Value.Default
    public ImmutableList<Integer> rollupCappedDatabaseSizesMb() {
        return DEFAULT_CAPPED_DATABASE_SIZES_MB;
    }

    @Value.Default
    public int traceCappedDatabaseSizeMb() {
        return 500;
    }

    @JsonIgnore
    @Value.Derived
    public String version() {
        return Versions.getJsonVersion((Object)this);
    }

    @JsonIgnore
    @Value.Derived
    public boolean hasListIssues() {
        return this.rollupExpirationHours().size() != DEFAULT_ROLLUP_EXPIRATION_HOURS.size() || this.rollupCappedDatabaseSizesMb().size() != DEFAULT_CAPPED_DATABASE_SIZES_MB.size();
    }
}

