/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.config;

import java.util.concurrent.TimeUnit;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.StorageConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.UnmodifiableIterator;
import org.glowroot.agent.shaded.com.google.common.primitives.Ints;
import org.glowroot.agent.shaded.org.glowroot.common.util.Versions;
import org.immutables.value.Value;

@Value.Immutable
public abstract class CentralStorageConfig
implements StorageConfig {
    private static final ImmutableList<Integer> DEFAULT_ROLLUP_EXPIRATION_HOURS = ImmutableList.of((Object)48, (Object)336, (Object)2160, (Object)8760);
    private static final ImmutableList<Integer> DEFAULT_DETAIL_ROLLUP_EXPIRATION_HOURS = ImmutableList.of((Object)48, (Object)168, (Object)720, (Object)720);

    @Override
    @Value.Default
    public ImmutableList<Integer> rollupExpirationHours() {
        return DEFAULT_ROLLUP_EXPIRATION_HOURS;
    }

    @Override
    @Value.Default
    public ImmutableList<Integer> queryAndServiceCallRollupExpirationHours() {
        return DEFAULT_DETAIL_ROLLUP_EXPIRATION_HOURS;
    }

    @Override
    @Value.Default
    public ImmutableList<Integer> profileRollupExpirationHours() {
        return DEFAULT_DETAIL_ROLLUP_EXPIRATION_HOURS;
    }

    @Override
    @Value.Default
    public int traceExpirationHours() {
        return 336;
    }

    @JsonIgnore
    @Value.Derived
    public String version() {
        return Versions.getJsonVersion((Object)this);
    }

    public boolean hasListIssues() {
        return this.rollupExpirationHours().size() != DEFAULT_ROLLUP_EXPIRATION_HOURS.size() || this.queryAndServiceCallRollupExpirationHours().size() != DEFAULT_DETAIL_ROLLUP_EXPIRATION_HOURS.size() || this.profileRollupExpirationHours().size() != DEFAULT_DETAIL_ROLLUP_EXPIRATION_HOURS.size();
    }

    @JsonIgnore
    @Value.Derived
    public int getMaxRollupHours() {
        int maxRollupExpirationHours = 0;
        UnmodifiableIterator unmodifiableIterator = this.rollupExpirationHours().iterator();
        while (unmodifiableIterator.hasNext()) {
            int expirationHours = (Integer)unmodifiableIterator.next();
            if (expirationHours == 0) {
                return 0;
            }
            maxRollupExpirationHours = Math.max(maxRollupExpirationHours, expirationHours);
        }
        return maxRollupExpirationHours;
    }

    @JsonIgnore
    @Value.Derived
    public int getMaxRollupTTL() {
        return Ints.saturatedCast((long)TimeUnit.HOURS.toSeconds(this.getMaxRollupHours()));
    }

    @JsonIgnore
    @Value.Derived
    public int getTraceTTL() {
        return Ints.saturatedCast((long)TimeUnit.HOURS.toSeconds(this.traceExpirationHours()));
    }
}

