/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import org.glowroot.agent.embedded.shaded.com.sun.mail.util.FolderClosedIOException;
import org.glowroot.agent.embedded.shaded.javax.activation.DataSource;
import org.glowroot.agent.embedded.shaded.javax.mail.FolderClosedException;
import org.glowroot.agent.embedded.shaded.javax.mail.MessagingException;
import org.glowroot.agent.embedded.shaded.javax.mail.internet.MimeBodyPart;
import org.glowroot.agent.embedded.shaded.javax.mail.internet.MimeMessage;
import org.glowroot.agent.embedded.shaded.javax.mail.internet.MimePart;
import org.glowroot.agent.embedded.shaded.javax.mail.internet.MimeUtility;

public class MimePartDataSource
implements DataSource {
    protected MimePart part;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            InputStream is;
            if (this.part instanceof MimeBodyPart) {
                is = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                is = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String encoding = MimeBodyPart.restrictEncoding(this.part, this.part.getEncoding());
            if (encoding != null) {
                return MimeUtility.decode(is, encoding);
            }
            return is;
        }
        catch (FolderClosedException fex) {
            throw new FolderClosedIOException(fex.getFolder(), fex.getMessage());
        }
        catch (MessagingException mex) {
            IOException ioex = new IOException(mex.getMessage());
            ioex.initCause(mex);
            throw ioex;
        }
    }

    @Override
    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException mex) {
            return "application/octet-stream";
        }
    }

    @Override
    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return "";
    }
}

