/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.impl;

import org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.ChunkEncoder;

public class VanillaChunkEncoder
extends ChunkEncoder {
    public VanillaChunkEncoder(int totalLength) {
        super(totalLength);
    }

    @Override
    protected int tryCompress(byte[] in, int inPos, int inEnd, byte[] out, int outPos) {
        int[] hashTable = this._hashTable;
        ++outPos;
        int seen = this.first(in, inPos);
        int literals = 0;
        inEnd -= 4;
        int firstPos = inPos;
        while (inPos < inEnd) {
            int len;
            byte p2 = in[inPos + 2];
            seen = (seen << 8) + (p2 & 0xFF);
            int off = this.hash(seen);
            int ref = hashTable[off];
            hashTable[off] = inPos;
            if (ref >= inPos || ref < firstPos || (off = inPos - ref) > 8192 || in[ref + 2] != p2 || in[ref + 1] != (byte)(seen >> 8) || in[ref] != (byte)(seen >> 16)) {
                out[outPos++] = in[inPos++];
                if (++literals != 32) continue;
                out[outPos - 33] = 31;
                literals = 0;
                ++outPos;
                continue;
            }
            int maxLen = inEnd - inPos + 2;
            if (maxLen > 264) {
                maxLen = 264;
            }
            if (literals == 0) {
                --outPos;
            } else {
                out[outPos - literals - 1] = (byte)(literals - 1);
                literals = 0;
            }
            for (len = 3; len < maxLen && in[ref + len] == in[inPos + len]; ++len) {
            }
            --off;
            if ((len -= 2) < 7) {
                out[outPos++] = (byte)((off >> 8) + (len << 5));
            } else {
                out[outPos++] = (byte)((off >> 8) + 224);
                out[outPos++] = (byte)(len - 7);
            }
            out[outPos++] = (byte)off;
            ++outPos;
            seen = this.first(in, inPos += len);
            seen = (seen << 8) + (in[inPos + 2] & 0xFF);
            hashTable[this.hash((int)seen)] = inPos++;
            seen = (seen << 8) + (in[inPos + 2] & 0xFF);
            hashTable[this.hash((int)seen)] = inPos++;
        }
        return this._handleTail(in, inPos, inEnd + 4, out, outPos, literals);
    }

    private final int _handleTail(byte[] in, int inPos, int inEnd, byte[] out, int outPos, int literals) {
        while (inPos < inEnd) {
            out[outPos++] = in[inPos++];
            if (++literals != 32) continue;
            out[outPos - literals - 1] = (byte)(literals - 1);
            literals = 0;
            ++outPos;
        }
        out[outPos - literals - 1] = (byte)(literals - 1);
        if (literals == 0) {
            --outPos;
        }
        return outPos;
    }

    private final int first(byte[] in, int inPos) {
        return (in[inPos] << 8) + (in[inPos + 1] & 0xFF);
    }
}

