/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.com.ning.compress.lzf;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.glowroot.agent.embedded.shaded.com.ning.compress.BufferRecycler;
import org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.LZFChunk;

public abstract class ChunkEncoder
implements Closeable {
    protected final BufferRecycler _recycler;
    protected int[] _hashTable;
    protected final int _hashModulo;
    protected byte[] _encodeBuffer;
    protected byte[] _headerBuffer;

    protected ChunkEncoder(int totalLength) {
        this(totalLength, BufferRecycler.instance());
    }

    protected ChunkEncoder(int totalLength, BufferRecycler bufferRecycler) {
        int largestChunkLen = Math.min(totalLength, 65535);
        int suggestedHashLen = ChunkEncoder.calcHashLen(largestChunkLen);
        this._recycler = bufferRecycler;
        this._hashTable = bufferRecycler.allocEncodingHash(suggestedHashLen);
        this._hashModulo = this._hashTable.length - 1;
        int bufferLen = largestChunkLen + (largestChunkLen + 31 >> 5) + 7;
        this._encodeBuffer = bufferRecycler.allocEncodingBuffer(bufferLen);
    }

    private static int calcHashLen(int chunkSize) {
        int hashLen;
        if ((chunkSize += chunkSize) >= 16384) {
            return 16384;
        }
        for (hashLen = 256; hashLen < chunkSize; hashLen += hashLen) {
        }
        return hashLen;
    }

    @Override
    public final void close() {
        int[] ibuf;
        byte[] buf = this._encodeBuffer;
        if (buf != null) {
            this._encodeBuffer = null;
            this._recycler.releaseEncodeBuffer(buf);
        }
        if ((ibuf = this._hashTable) != null) {
            this._hashTable = null;
            this._recycler.releaseEncodingHash(ibuf);
        }
    }

    public void encodeAndWriteChunk(byte[] data, int offset, int len, OutputStream out) throws IOException {
        int compEnd;
        int compLen;
        if (len >= 16 && (compLen = (compEnd = this.tryCompress(data, offset, offset + len, this._encodeBuffer, 7)) - 7) < len - 2) {
            LZFChunk.appendCompressedHeader(len, compLen, this._encodeBuffer, 0);
            out.write(this._encodeBuffer, 0, compEnd);
            return;
        }
        byte[] headerBuf = this._headerBuffer;
        if (headerBuf == null) {
            this._headerBuffer = headerBuf = new byte[7];
        }
        LZFChunk.writeNonCompressedHeader(len, out, headerBuf);
        out.write(data, offset, len);
    }

    protected abstract int tryCompress(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected final int hash(int h) {
        return h * 57321 >> 9 & this._hashModulo;
    }
}

