/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.util.concurrent.TimeUnit;
import org.glowroot.agent.embedded.repo.AggregateDao;
import org.glowroot.agent.embedded.repo.ConfigRepositoryImpl;
import org.glowroot.agent.embedded.repo.FullQueryTextDao;
import org.glowroot.agent.embedded.repo.GaugeIdDao;
import org.glowroot.agent.embedded.repo.GaugeNameDao;
import org.glowroot.agent.embedded.repo.GaugeValueDao;
import org.glowroot.agent.embedded.repo.IncidentDao;
import org.glowroot.agent.embedded.repo.TraceDao;
import org.glowroot.agent.embedded.repo.TransactionTypeDao;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedStorageConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable;

class ReaperRunnable
extends ScheduledRunnable {
    private final ConfigRepositoryImpl configRepository;
    private final AggregateDao aggregateDao;
    private final TraceDao traceDao;
    private final GaugeIdDao gaugeIdDao;
    private final GaugeNameDao gaugeNameDao;
    private final GaugeValueDao gaugeValueDao;
    private final TransactionTypeDao transactionTypeDao;
    private final FullQueryTextDao fullQueryTextDao;
    private final IncidentDao incidentDao;
    private final Clock clock;

    ReaperRunnable(ConfigRepositoryImpl configService, AggregateDao aggregateDao, TraceDao traceDao, GaugeIdDao gaugeIdDao, GaugeNameDao gaugeNameDao, GaugeValueDao gaugeValueDao, TransactionTypeDao transactionTypeDao, FullQueryTextDao fullQueryTextDao, IncidentDao incidentDao, Clock clock) {
        this.configRepository = configService;
        this.aggregateDao = aggregateDao;
        this.traceDao = traceDao;
        this.gaugeIdDao = gaugeIdDao;
        this.gaugeNameDao = gaugeNameDao;
        this.gaugeValueDao = gaugeValueDao;
        this.transactionTypeDao = transactionTypeDao;
        this.fullQueryTextDao = fullQueryTextDao;
        this.incidentDao = incidentDao;
        this.clock = clock;
    }

    protected void runInternal() throws Exception {
        int fullQueryTextExpirationHours;
        int traceExpirationHours;
        long minCaptureTime = Long.MAX_VALUE;
        long currentTime = this.clock.currentTimeMillis();
        EmbeddedStorageConfig storageConfig = this.configRepository.getEmbeddedStorageConfig();
        for (int i = 0; i < storageConfig.rollupExpirationHours().size(); ++i) {
            int expirationHours = (Integer)storageConfig.rollupExpirationHours().get(i);
            if (expirationHours == 0) {
                minCaptureTime = 0L;
                continue;
            }
            long captureTime = currentTime - TimeUnit.HOURS.toMillis(expirationHours);
            this.aggregateDao.deleteBefore(captureTime, i);
            if (i == 0) {
                this.gaugeValueDao.deleteBefore(captureTime, i);
            }
            this.gaugeValueDao.deleteBefore(captureTime, i + 1);
            minCaptureTime = Math.min(minCaptureTime, captureTime);
        }
        if (minCaptureTime != 0L) {
            this.gaugeIdDao.deleteBefore(minCaptureTime);
            this.gaugeNameDao.deleteBefore(minCaptureTime);
        }
        if ((traceExpirationHours = storageConfig.traceExpirationHours()) != 0) {
            long traceCaptureTime = currentTime - TimeUnit.HOURS.toMillis(traceExpirationHours);
            this.traceDao.deleteBefore(traceCaptureTime);
            minCaptureTime = Math.min(minCaptureTime, traceCaptureTime);
        }
        if (minCaptureTime != 0L) {
            this.transactionTypeDao.deleteBefore(minCaptureTime);
        }
        if ((fullQueryTextExpirationHours = storageConfig.fullQueryTextExpirationHours()) != 0) {
            this.fullQueryTextDao.deleteBefore(currentTime - TimeUnit.HOURS.toMillis(fullQueryTextExpirationHours));
        }
        this.incidentDao.deleteResolvedIncidentsBefore(currentTime - TimeUnit.HOURS.toMillis(720L));
    }
}

