/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableOpenIncident;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableResolvedIncident;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.IncidentRepository;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;

class IncidentDao
implements IncidentRepository {
    private static final String AGENT_ID = "";
    private static final ImmutableList<Schemas.Column> incidentColumns = ImmutableList.of((Object)ImmutableColumn.of("open_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("resolve_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("condition", Schemas.ColumnType.VARBINARY), (Object)ImmutableColumn.of("severity", Schemas.ColumnType.VARCHAR), (Object)ImmutableColumn.of("notification", Schemas.ColumnType.VARBINARY));
    private static final ImmutableList<Schemas.Index> incidentIndexes = ImmutableList.of((Object)ImmutableIndex.of("incident_resolve_time_idx", (ImmutableList<String>)ImmutableList.of((Object)"resolve_time")), (Object)ImmutableIndex.of("incident_condition_idx", (ImmutableList<String>)ImmutableList.of((Object)"condition")));
    private final DataSource dataSource;

    IncidentDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        if (dataSource.tableExists("triggered_alert")) {
            dataSource.execute("drop table triggered_alert");
        }
        dataSource.syncTable("incident", (List<Schemas.Column>)incidentColumns);
        dataSource.syncIndexes("incident", incidentIndexes);
    }

    @Override
    public CompletionStage<?> insertOpenIncident(String agentRollupId, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition condition, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification notification, long openTime, CassandraProfile profile) {
        try {
            this.dataSource.update("insert into incident (open_time, condition, severity, notification) values (?, ?, ?, ?)", openTime, condition.toByteArray(), severity.name().toLowerCase(Locale.ENGLISH), notification.toByteArray());
            return CompletableFuture.completedFuture(null);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<IncidentRepository.OpenIncident> readOpenIncident(String agentRollupId, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition condition, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity, CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.query(new SingleOpenIncident(condition, severity)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<List<IncidentRepository.OpenIncident>> readOpenIncidents(String agentRollupId, CassandraProfile profile) {
        return this.readAllOpenIncidents(CassandraProfile.web);
    }

    @Override
    public CompletionStage<List<IncidentRepository.OpenIncident>> readAllOpenIncidents(CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.query(new OpenIncidentRowQuery()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> resolveIncident(IncidentRepository.OpenIncident incident, long resolveTime, CassandraProfile profile) {
        try {
            this.dataSource.update("update incident set resolve_time = ? where condition = ? and severity = ? and resolve_time is null", resolveTime, incident.condition().toByteArray(), incident.severity().name().toLowerCase(Locale.ENGLISH));
            return CompletableFuture.completedFuture(null);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<List<IncidentRepository.ResolvedIncident>> readResolvedIncidents(long from) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.query(new ResolvedIncidentRowQuery(from)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteResolvedIncidentsBefore(long resolvedTime) throws Exception {
        this.dataSource.deleteBefore("incident", "resolve_time", resolvedTime);
    }

    private static class ResolvedIncidentRowQuery
    implements DataSource.JdbcRowQuery<IncidentRepository.ResolvedIncident> {
        private static final String AGENT_ID = "";
        private final long from;

        private ResolvedIncidentRowQuery(long from) {
            this.from = from;
        }

        @Override
        public @Untainted String getSql() {
            return "select open_time, resolve_time, condition, severity, notification from incident where resolve_time >= ? order by resolve_time desc";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setLong(1, this.from);
        }

        @Override
        public IncidentRepository.ResolvedIncident mapRow(ResultSet resultSet) throws Exception {
            int i = 1;
            long openTime = resultSet.getLong(i++);
            long resolveTime = resultSet.getLong(i++);
            byte[] conditionBytes = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
            String severity = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
            byte[] notificationBytes = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
            return ImmutableResolvedIncident.builder().agentRollupId("").openTime(openTime).resolveTime(resolveTime).condition(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.parseFrom((byte[])conditionBytes)).severity(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity.valueOf((String)severity.toUpperCase(Locale.ENGLISH))).notification(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.parseFrom((byte[])notificationBytes)).build();
        }
    }

    private static class OpenIncidentRowQuery
    implements DataSource.JdbcRowQuery<IncidentRepository.OpenIncident> {
        private OpenIncidentRowQuery() {
        }

        @Override
        public @Untainted String getSql() {
            return "select open_time, condition, severity, notification from incident where resolve_time is null";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) {
        }

        @Override
        public IncidentRepository.OpenIncident mapRow(ResultSet resultSet) throws Exception {
            int i = 1;
            long openTime = resultSet.getLong(i++);
            byte[] conditionBytes = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
            String severity = (String)Preconditions.checkNotNull((Object)resultSet.getString(i++));
            byte[] notificationBytes = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(i++));
            return ImmutableOpenIncident.builder().agentRollupId(IncidentDao.AGENT_ID).openTime(openTime).condition(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.parseFrom((byte[])conditionBytes)).severity(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity.valueOf((String)severity.toUpperCase(Locale.ENGLISH))).notification(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.parseFrom((byte[])notificationBytes)).build();
        }
    }

    private static class SingleOpenIncident
    implements DataSource.JdbcQuery<IncidentRepository.OpenIncident> {
        private final AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition condition;
        private final AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity;

        private SingleOpenIncident(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition condition, AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity) {
            this.condition = condition;
            this.severity = severity;
        }

        @Override
        public @Untainted String getSql() {
            return "select notification, open_time from incident where condition = ? and severity = ? and resolve_time is null";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
            preparedStatement.setBytes(1, this.condition.toByteArray());
            preparedStatement.setString(2, this.severity.name().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public @Nullable IncidentRepository.OpenIncident processResultSet(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                return null;
            }
            byte[] notificationBytes = (byte[])Preconditions.checkNotNull((Object)resultSet.getBytes(1));
            long openTime = resultSet.getLong(2);
            return ImmutableOpenIncident.builder().agentRollupId(IncidentDao.AGENT_ID).condition(this.condition).severity(this.severity).notification(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertNotification.parseFrom((byte[])notificationBytes)).openTime(openTime).build();
        }

        @Override
        public @Nullable IncidentRepository.OpenIncident valueIfDataSourceClosed() {
            return null;
        }
    }
}

