/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.repo.AggregateDao;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AggregateDao.TruncatedQueryText", generator="Immutables")
@Immutable
final class ImmutableTruncatedQueryText
implements AggregateDao.TruncatedQueryText {
    private final String truncatedText;
    private final @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1;

    private ImmutableTruncatedQueryText(String truncatedText, @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1) {
        this.truncatedText = Objects.requireNonNull(truncatedText, "truncatedText");
        this.fullTextSha1 = fullTextSha1;
    }

    private ImmutableTruncatedQueryText(ImmutableTruncatedQueryText original, String truncatedText, @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1) {
        this.truncatedText = truncatedText;
        this.fullTextSha1 = fullTextSha1;
    }

    @Override
    @JsonProperty(value="truncatedText")
    public String truncatedText() {
        return this.truncatedText;
    }

    @Override
    @JsonProperty(value="fullTextSha1")
    public @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1() {
        return this.fullTextSha1;
    }

    public final ImmutableTruncatedQueryText withTruncatedText(String value) {
        String newValue = Objects.requireNonNull(value, "truncatedText");
        if (this.truncatedText.equals(newValue)) {
            return this;
        }
        return new ImmutableTruncatedQueryText(this, newValue, this.fullTextSha1);
    }

    public final ImmutableTruncatedQueryText withFullTextSha1(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.fullTextSha1, value)) {
            return this;
        }
        return new ImmutableTruncatedQueryText(this, this.truncatedText, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTruncatedQueryText && this.equalTo(0, (ImmutableTruncatedQueryText)another);
    }

    private boolean equalTo(int synthetic, ImmutableTruncatedQueryText another) {
        return this.truncatedText.equals(another.truncatedText) && Objects.equals(this.fullTextSha1, another.fullTextSha1);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.truncatedText.hashCode();
        h += (h << 5) + Objects.hashCode(this.fullTextSha1);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TruncatedQueryText").omitNullValues().add("truncatedText", (Object)this.truncatedText).add("fullTextSha1", (Object)this.fullTextSha1).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTruncatedQueryText fromJson(Json json) {
        Builder builder = ImmutableTruncatedQueryText.builder();
        if (json.truncatedText != null) {
            builder.truncatedText(json.truncatedText);
        }
        if (json.fullTextSha1 != null) {
            builder.fullTextSha1(json.fullTextSha1);
        }
        return builder.build();
    }

    public static ImmutableTruncatedQueryText of(String truncatedText, @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1) {
        return new ImmutableTruncatedQueryText(truncatedText, fullTextSha1);
    }

    public static ImmutableTruncatedQueryText copyOf(AggregateDao.TruncatedQueryText instance) {
        if (instance instanceof ImmutableTruncatedQueryText) {
            return (ImmutableTruncatedQueryText)instance;
        }
        return ImmutableTruncatedQueryText.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AggregateDao.TruncatedQueryText", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRUNCATED_TEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private String truncatedText;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AggregateDao.TruncatedQueryText instance) {
            Objects.requireNonNull(instance, "instance");
            this.truncatedText(instance.truncatedText());
            @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1Value = instance.fullTextSha1();
            if (fullTextSha1Value != null) {
                this.fullTextSha1(fullTextSha1Value);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder truncatedText(String truncatedText) {
            this.truncatedText = Objects.requireNonNull(truncatedText, "truncatedText");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fullTextSha1(@org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1) {
            this.fullTextSha1 = fullTextSha1;
            return this;
        }

        public ImmutableTruncatedQueryText build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTruncatedQueryText(null, this.truncatedText, this.fullTextSha1);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("truncatedText");
            }
            return "Cannot build TruncatedQueryText, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AggregateDao.TruncatedQueryText", generator="Immutables")
    static final class Json
    implements AggregateDao.TruncatedQueryText {
        @Nullable
        String truncatedText;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1;

        Json() {
        }

        @JsonProperty(value="truncatedText")
        public void setTruncatedText(String truncatedText) {
            this.truncatedText = truncatedText;
        }

        @JsonProperty(value="fullTextSha1")
        public void setFullTextSha1(@org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1) {
            this.fullTextSha1 = fullTextSha1;
        }

        @Override
        public String truncatedText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @org.checkerframework.checker.nullness.qual.Nullable String fullTextSha1() {
            throw new UnsupportedOperationException();
        }
    }
}

