/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.init;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.embedded.init.EmbeddedAgentModule;
import org.glowroot.agent.impl.BytecodeServiceImpl;
import org.glowroot.agent.init.AgentModule;
import org.glowroot.agent.init.GlowrootAgentInit;
import org.glowroot.agent.init.NettyInit;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class EmbeddedGlowrootAgentInit
implements GlowrootAgentInit {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedGlowrootAgentInit.class);
    private final File dataDir;
    private final boolean offlineViewer;
    private final @Nullable Class<? extends Collector> collectorProxyClass;
    private volatile @MonotonicNonNull Closeable agentDirLockCloseable;
    private @MonotonicNonNull EmbeddedAgentModule embeddedAgentModule;

    EmbeddedGlowrootAgentInit(File dataDir, boolean offlineViewer, @Nullable Class<? extends Collector> collectorProxyClass) {
        this.dataDir = dataDir;
        this.offlineViewer = offlineViewer;
        this.collectorProxyClass = collectorProxyClass;
    }

    public void init(@Nullable File pluginsDir, final List<File> confDirs, File logDir, File tmpDir, final @Nullable File glowrootJarFile, final Map<String, String> properties, final @Nullable Instrumentation instrumentation, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer, final String glowrootVersion, Closeable agentDirLockCloseable) throws Exception {
        this.agentDirLockCloseable = agentDirLockCloseable;
        final boolean configReadOnly = Boolean.parseBoolean(properties.get("glowroot.config.readOnly"));
        this.embeddedAgentModule = new EmbeddedAgentModule(pluginsDir, confDirs, configReadOnly, logDir, tmpDir, instrumentation, preCheckClassFileTransformer, glowrootJarFile, glowrootVersion, this.offlineViewer);
        BytecodeServiceImpl.OnEnteringMain onEnteringMain = new BytecodeServiceImpl.OnEnteringMain(){

            public void run(@Nullable String mainClass) throws Exception {
                NettyInit.run();
                Preconditions.checkNotNull((Object)EmbeddedGlowrootAgentInit.this.embeddedAgentModule);
                EmbeddedGlowrootAgentInit.this.embeddedAgentModule.onEnteringMain(confDirs, configReadOnly, EmbeddedGlowrootAgentInit.this.dataDir, glowrootJarFile, properties, instrumentation, EmbeddedGlowrootAgentInit.this.collectorProxyClass, glowrootVersion, mainClass);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Preconditions.checkNotNull((Object)EmbeddedGlowrootAgentInit.this.embeddedAgentModule);
                            EmbeddedGlowrootAgentInit.this.embeddedAgentModule.waitForSimpleRepoModule();
                            EmbeddedGlowrootAgentInit.this.embeddedAgentModule.initEmbeddedServer();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
                thread.setName("Glowroot-Init-UI");
                thread.setDaemon(true);
                thread.start();
            }
        };
        if (instrumentation == null) {
            onEnteringMain.run(null);
        } else {
            this.embeddedAgentModule.setOnEnteringMain(onEnteringMain);
        }
    }

    @OnlyUsedByTests
    public void initConfigForTests() throws IOException {
        EmbeddedAgentModule embeddedAgentModule = (EmbeddedAgentModule)Preconditions.checkNotNull((Object)this.embeddedAgentModule);
        AgentModule agentModule = embeddedAgentModule.getAgentModule();
        agentModule.getConfigService().initConfigForTests();
    }

    @OnlyUsedByTests
    public void resetConfigForTests() throws Exception {
        EmbeddedAgentModule embeddedAgentModule = (EmbeddedAgentModule)Preconditions.checkNotNull((Object)this.embeddedAgentModule);
        AgentModule agentModule = embeddedAgentModule.getAgentModule();
        agentModule.getConfigService().resetConfigForTests();
        embeddedAgentModule.getSimpleRepoModule().getConfigRepository().resetAdminConfigForTests();
        agentModule.getLiveWeavingService().reweave("");
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        ((EmbeddedAgentModule)Preconditions.checkNotNull((Object)this.embeddedAgentModule)).close();
        ((Closeable)Preconditions.checkNotNull((Object)this.agentDirLockCloseable)).close();
    }

    @OnlyUsedByTests
    public void awaitClose() {
    }
}

