/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.init;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.embedded.repo.AggregateDao;
import org.glowroot.agent.embedded.repo.AlertingDisabledDao;
import org.glowroot.agent.embedded.repo.ConfigRepositoryImpl;
import org.glowroot.agent.embedded.repo.EnvironmentDao;
import org.glowroot.agent.embedded.repo.GaugeValueDao;
import org.glowroot.agent.embedded.repo.TraceDao;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HealthchecksIoConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.AlertingService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.HttpClient;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class EmbeddedCollector
implements Collector {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedCollector.class);
    private static final String AGENT_ID = "";
    private final EnvironmentDao environmentDao;
    private final AggregateDao aggregateDao;
    private final TraceDao traceDao;
    private final GaugeValueDao gaugeValueDao;
    private final ConfigRepositoryImpl configRepository;
    private final AlertingService alertingService;
    private final AlertingDisabledDao alertingDisabledDao;
    private final HttpClient httpClient;
    private final Clock clock;

    EmbeddedCollector(EnvironmentDao environmentDao, AggregateDao aggregateDao, TraceDao traceDao, GaugeValueDao gaugeValueDao, ConfigRepositoryImpl configRepository, AlertingService alertingService, AlertingDisabledDao alertingDisabledDao, HttpClient httpClient, Clock clock) {
        this.environmentDao = environmentDao;
        this.aggregateDao = aggregateDao;
        this.traceDao = traceDao;
        this.gaugeValueDao = gaugeValueDao;
        this.configRepository = configRepository;
        this.alertingService = alertingService;
        this.alertingDisabledDao = alertingDisabledDao;
        this.httpClient = httpClient;
        this.clock = clock;
    }

    public void init(List<File> confDirs, CollectorServiceOuterClass.InitMessage.Environment environment, AgentConfigOuterClass.AgentConfig agentConfig, Collector.AgentConfigUpdater agentConfigUpdater) throws SQLException {
        this.environmentDao.store(environment);
    }

    public void collectAggregates(Collector.AggregateReader aggregateReader) throws Exception {
        HealthchecksIoConfig healthchecksIoConfig;
        String healthchecksIoPingUrl;
        this.aggregateDao.store(aggregateReader);
        this.alertingService.checkForDeletedAlerts(AGENT_ID, CassandraProfile.web);
        if (!this.isCurrentlyDisabled().toCompletableFuture().join().booleanValue()) {
            for (AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig : this.configRepository.getAlertConfigs(AGENT_ID).toCompletableFuture().join()) {
                AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition = alertConfig.getCondition();
                if (!EmbeddedCollector.isAggregateMetricCondition(alertCondition)) continue;
                try {
                    this.alertingService.checkMetricAlert(AGENT_ID, AGENT_ID, this.configRepository.getEmbeddedAdminGeneralConfig().agentDisplayNameOrDefault(), alertConfig, alertCondition.getMetricCondition(), aggregateReader.captureTime(), CassandraProfile.collector).toCompletableFuture().join();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!(healthchecksIoPingUrl = (healthchecksIoConfig = this.configRepository.getHealthchecksIoConfig()).pingUrl()).isEmpty()) {
            try {
                this.httpClient.get(healthchecksIoPingUrl);
            }
            catch (Exception e) {
                logger.error("error sending ping to healthchecks.io: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void collectGaugeValues(List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues) throws Exception {
        this.gaugeValueDao.store(gaugeValues);
        long maxCaptureTime = 0L;
        for (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue gaugeValue : gaugeValues) {
            maxCaptureTime = Math.max(maxCaptureTime, gaugeValue.getCaptureTime());
        }
        this.alertingService.checkForDeletedAlerts(AGENT_ID, CassandraProfile.web);
        if (!this.isCurrentlyDisabled().toCompletableFuture().join().booleanValue()) {
            for (AgentConfigOuterClass.AgentConfig.AlertConfig alertConfig : this.configRepository.getAlertConfigs(AGENT_ID).toCompletableFuture().join()) {
                AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition = alertConfig.getCondition();
                if (!EmbeddedCollector.isGaugeMetricCondition(alertCondition)) continue;
                try {
                    this.alertingService.checkMetricAlert(AGENT_ID, AGENT_ID, this.configRepository.getEmbeddedAdminGeneralConfig().agentDisplayNameOrDefault(), alertConfig, alertCondition.getMetricCondition(), maxCaptureTime, CassandraProfile.collector).toCompletableFuture().join();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void collectTrace(Collector.TraceReader traceReader) throws Exception {
        this.traceDao.store(traceReader);
    }

    public void log(CollectorServiceOuterClass.LogMessage.LogEvent logEvent) {
    }

    private CompletionStage<Boolean> isCurrentlyDisabled() {
        return this.alertingDisabledDao.getAlertingDisabledUntilTime(AGENT_ID, CassandraProfile.web).thenApply(disabledUntilTime -> disabledUntilTime != null && disabledUntilTime > this.clock.currentTimeMillis());
    }

    private static boolean isAggregateMetricCondition(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition) {
        if (alertCondition.getValCase() != AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.ValCase.METRIC_CONDITION) {
            return false;
        }
        String metric = alertCondition.getMetricCondition().getMetric();
        return metric.startsWith("transaction:") || metric.startsWith("error:");
    }

    private static boolean isGaugeMetricCondition(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition alertCondition) {
        return alertCondition.getValCase() == AgentConfigOuterClass.AgentConfig.AlertConfig.AlertCondition.ValCase.METRIC_CONDITION && alertCondition.getMetricCondition().getMetric().startsWith("gauge:");
    }
}

