/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.objectweb.asm.AnnotationVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.ClassNames;

class InstrumentationSeekerClassVisitor
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationSeekerClassVisitor.class);
    private final List<InstrumentationConfig> instrumentationConfigs = Lists.newArrayList();
    private @MonotonicNonNull String owner;

    InstrumentationSeekerClassVisitor() {
        super(589824);
    }

    @Override
    public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.owner = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
        return new InstrumentationAnnotationMethodVisitor(name, descriptor);
    }

    List<InstrumentationConfig> getInstrumentationConfigs() {
        return this.instrumentationConfigs;
    }

    private static class TimerAnnotationVisitor
    extends AnnotationVisitor {
        private @Nullable String timerName;

        private TimerAnnotationVisitor() {
            super(589824);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (name == null) {
                return;
            }
            if (name.equals("value")) {
                this.timerName = (String)value;
            }
        }
    }

    private static class TraceEntryAnnotationVisitor
    extends AnnotationVisitor {
        private @Nullable String messageTemplate;
        private @Nullable String timerName;

        private TraceEntryAnnotationVisitor() {
            super(589824);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (name == null) {
                return;
            }
            if (name.equals("message")) {
                this.messageTemplate = (String)value;
            } else if (name.equals("timer")) {
                this.timerName = (String)value;
            }
        }
    }

    private static class TransactionAnnotationVisitor
    extends AnnotationVisitor {
        private @Nullable String transactionType;
        private @Nullable String transactionNameTemplate;
        private @Nullable String traceHeadline;
        private @Nullable String timerName;
        private  @Nullable AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior alreadyInTransactionBehavior;

        private TransactionAnnotationVisitor() {
            super(589824);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (name == null) {
                return;
            }
            if (name.equals("transactionType")) {
                this.transactionType = (String)value;
            } else if (name.equals("transactionName")) {
                this.transactionNameTemplate = (String)value;
            } else if (name.equals("traceHeadline")) {
                this.traceHeadline = (String)value;
            } else if (name.equals("timer")) {
                this.timerName = (String)value;
            }
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            if (name.equals("alreadyInTransactionBehavior")) {
                this.alreadyInTransactionBehavior = TransactionAnnotationVisitor.toProto(value);
            }
        }

        private static AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior toProto(String value) {
            if (value.equals("CAPTURE_TRACE_ENTRY")) {
                return AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.CAPTURE_TRACE_ENTRY;
            }
            if (value.equals("CAPTURE_NEW_TRANSACTION")) {
                return AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.CAPTURE_NEW_TRANSACTION;
            }
            if (value.equals("DO_NOTHING")) {
                return AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.DO_NOTHING;
            }
            throw new IllegalStateException("Unexpected AlreadyInTransactionBehavior: " + value);
        }
    }

    private class InstrumentationAnnotationMethodVisitor
    extends MethodVisitor {
        private final String methodName;
        private final String descriptor;
        private @MonotonicNonNull TransactionAnnotationVisitor transactionAnnotationVisitor;
        private @MonotonicNonNull TraceEntryAnnotationVisitor traceEntryAnnotationVisitor;
        private @MonotonicNonNull TimerAnnotationVisitor timerAnnotationVisitor;

        private InstrumentationAnnotationMethodVisitor(String methodName, String descriptor) {
            super(589824);
            this.methodName = methodName;
            this.descriptor = descriptor;
        }

        @Override
        public @Nullable AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Lorg/glowroot/agent/api/Instrumentation$Transaction;") || descriptor.equals("Lorg/glowroot/agent/api/Instrument$Transaction;")) {
                this.transactionAnnotationVisitor = new TransactionAnnotationVisitor();
                return this.transactionAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/agent/api/Instrumentation$TraceEntry;") || descriptor.equals("Lorg/glowroot/agent/api/Instrument$TraceEntry;")) {
                this.traceEntryAnnotationVisitor = new TraceEntryAnnotationVisitor();
                return this.traceEntryAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/agent/api/Instrumentation$Timer;") || descriptor.equals("Lorg/glowroot/agent/api/Instrument$Timer;")) {
                this.timerAnnotationVisitor = new TimerAnnotationVisitor();
                return this.timerAnnotationVisitor;
            }
            return null;
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            this.processTransaction();
            this.processTraceEntry();
            this.processTimer();
        }

        private void processTransaction() {
            String timerName;
            if (this.transactionAnnotationVisitor == null) {
                return;
            }
            Preconditions.checkNotNull(InstrumentationSeekerClassVisitor.this.owner);
            String transactionType = this.transactionAnnotationVisitor.transactionType;
            if (transactionType == null) {
                logger.error("@Instrumentation.Transaction had no transactionType attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            String transactionNameTemplate = this.transactionAnnotationVisitor.transactionNameTemplate;
            if (transactionNameTemplate == null) {
                logger.error("@Instrumentation.Transaction had no transactionNameTemplate attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            String traceHeadline = this.transactionAnnotationVisitor.traceHeadline;
            if (traceHeadline == null) {
                traceHeadline = transactionNameTemplate;
            }
            if ((timerName = this.transactionAnnotationVisitor.timerName) == null) {
                logger.error("@Instrumentation.Transaction had no timerName attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior alreadyInTransactionBehavior = MoreObjects.firstNonNull(this.transactionAnnotationVisitor.alreadyInTransactionBehavior, AgentConfigOuterClass.AgentConfig.InstrumentationConfig.AlreadyInTransactionBehavior.CAPTURE_TRACE_ENTRY);
            InstrumentationSeekerClassVisitor.this.instrumentationConfigs.add(this.startBuilder().captureKind(AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRANSACTION).transactionType(transactionType).transactionNameTemplate(transactionNameTemplate).traceEntryMessageTemplate(traceHeadline).timerName(timerName).alreadyInTransactionBehavior(alreadyInTransactionBehavior).build());
        }

        private void processTraceEntry() {
            if (this.traceEntryAnnotationVisitor == null) {
                return;
            }
            Preconditions.checkNotNull(InstrumentationSeekerClassVisitor.this.owner);
            String messageTemplate = this.traceEntryAnnotationVisitor.messageTemplate;
            if (messageTemplate == null) {
                logger.error("@Instrumentation.TraceEntry had no messageTemplate attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            String timerName = this.traceEntryAnnotationVisitor.timerName;
            if (timerName == null) {
                logger.error("@Instrumentation.TraceEntry had no timerName attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            InstrumentationSeekerClassVisitor.this.instrumentationConfigs.add(this.startBuilder().captureKind(AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TRACE_ENTRY).traceEntryMessageTemplate(messageTemplate).timerName(timerName).build());
        }

        private void processTimer() {
            if (this.timerAnnotationVisitor == null) {
                return;
            }
            Preconditions.checkNotNull(InstrumentationSeekerClassVisitor.this.owner);
            String timerName = this.timerAnnotationVisitor.timerName;
            if (timerName == null) {
                logger.error("@Instrumentation.Timer had no value attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            InstrumentationSeekerClassVisitor.this.instrumentationConfigs.add(this.startBuilder().captureKind(AgentConfigOuterClass.AgentConfig.InstrumentationConfig.CaptureKind.TIMER).timerName(timerName).build());
        }

        @RequiresNonNull(value={"owner"})
        private ImmutableInstrumentationConfig.Builder startBuilder() {
            Type type = Type.getObjectType(InstrumentationSeekerClassVisitor.this.owner);
            Type[] argumentTypes = Type.getArgumentTypes(this.descriptor);
            ImmutableInstrumentationConfig.Builder builder = ImmutableInstrumentationConfig.builder().className(type.getClassName()).methodName(this.methodName);
            for (Type argumentType : argumentTypes) {
                builder.addMethodParameterTypes(argumentType.getClassName());
            }
            return builder;
        }
    }
}

