/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AnalyzedMethod;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AnalyzedMethod", generator="Immutables")
@Immutable
final class ImmutableAnalyzedMethod
extends AnalyzedMethod {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    private final String returnType;
    private final int modifiers;
    private final @org.checkerframework.checker.nullness.qual.Nullable String signature;
    private final ImmutableList<String> exceptions;
    private final ImmutableList<Advice> advisors;
    private final ImmutableList<Advice> subTypeRestrictedAdvisors;

    private ImmutableAnalyzedMethod(String name, ImmutableList<String> parameterTypes, String returnType, int modifiers, @org.checkerframework.checker.nullness.qual.Nullable String signature, ImmutableList<String> exceptions, ImmutableList<Advice> advisors, ImmutableList<Advice> subTypeRestrictedAdvisors) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.signature = signature;
        this.exceptions = exceptions;
        this.advisors = advisors;
        this.subTypeRestrictedAdvisors = subTypeRestrictedAdvisors;
    }

    @Override
    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parameterTypes")
    ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    @JsonProperty(value="returnType")
    String returnType() {
        return this.returnType;
    }

    @Override
    @JsonProperty(value="modifiers")
    int modifiers() {
        return this.modifiers;
    }

    @Override
    @JsonProperty(value="signature")
    @org.checkerframework.checker.nullness.qual.Nullable String signature() {
        return this.signature;
    }

    @Override
    @JsonProperty(value="exceptions")
    ImmutableList<String> exceptions() {
        return this.exceptions;
    }

    @Override
    @JsonProperty(value="advisors")
    ImmutableList<Advice> advisors() {
        return this.advisors;
    }

    @Override
    @JsonProperty(value="subTypeRestrictedAdvisors")
    ImmutableList<Advice> subTypeRestrictedAdvisors() {
        return this.subTypeRestrictedAdvisors;
    }

    public final ImmutableAnalyzedMethod withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalyzedMethod(newValue, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withReturnType(String value) {
        String newValue = Objects.requireNonNull(value, "returnType");
        if (this.returnType.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, newValue, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withModifiers(int value) {
        if (this.modifiers == value) {
            return this;
        }
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, value, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withSignature(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.signature, value)) {
            return this;
        }
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, value, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withExceptions(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withExceptions(Iterable<String> elements) {
        if (this.exceptions == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withAdvisors(Advice ... elements) {
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, newValue, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withAdvisors(Iterable<? extends Advice> elements) {
        if (this.advisors == elements) {
            return this;
        }
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, newValue, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withSubTypeRestrictedAdvisors(Advice ... elements) {
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, newValue);
    }

    public final ImmutableAnalyzedMethod withSubTypeRestrictedAdvisors(Iterable<? extends Advice> elements) {
        if (this.subTypeRestrictedAdvisors == elements) {
            return this;
        }
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnalyzedMethod && this.equalTo(0, (ImmutableAnalyzedMethod)another);
    }

    private boolean equalTo(int synthetic, ImmutableAnalyzedMethod another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes) && this.returnType.equals(another.returnType) && this.modifiers == another.modifiers && Objects.equals(this.signature, another.signature) && this.exceptions.equals(another.exceptions) && this.advisors.equals(another.advisors) && this.subTypeRestrictedAdvisors.equals(another.subTypeRestrictedAdvisors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.parameterTypes.hashCode();
        h += (h << 5) + this.returnType.hashCode();
        h += (h << 5) + this.modifiers;
        h += (h << 5) + Objects.hashCode(this.signature);
        h += (h << 5) + this.exceptions.hashCode();
        h += (h << 5) + this.advisors.hashCode();
        h += (h << 5) + this.subTypeRestrictedAdvisors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedMethod").omitNullValues().add("name", this.name).add("parameterTypes", this.parameterTypes).add("returnType", this.returnType).add("modifiers", this.modifiers).add("signature", this.signature).add("exceptions", this.exceptions).add("advisors", this.advisors).add("subTypeRestrictedAdvisors", this.subTypeRestrictedAdvisors).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnalyzedMethod fromJson(Json json) {
        Builder builder = ImmutableAnalyzedMethod.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.parameterTypes != null) {
            builder.addAllParameterTypes(json.parameterTypes);
        }
        if (json.returnType != null) {
            builder.returnType(json.returnType);
        }
        if (json.modifiersIsSet) {
            builder.modifiers(json.modifiers);
        }
        if (json.signature != null) {
            builder.signature(json.signature);
        }
        if (json.exceptions != null) {
            builder.addAllExceptions(json.exceptions);
        }
        if (json.advisors != null) {
            builder.addAllAdvisors(json.advisors);
        }
        if (json.subTypeRestrictedAdvisors != null) {
            builder.addAllSubTypeRestrictedAdvisors(json.subTypeRestrictedAdvisors);
        }
        return builder.build();
    }

    public static ImmutableAnalyzedMethod copyOf(AnalyzedMethod instance) {
        if (instance instanceof ImmutableAnalyzedMethod) {
            return (ImmutableAnalyzedMethod)instance;
        }
        return ImmutableAnalyzedMethod.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AnalyzedMethod", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RETURN_TYPE = 2L;
        private static final long INIT_BIT_MODIFIERS = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> parameterTypes = ImmutableList.builder();
        @Nullable
        private String returnType;
        private int modifiers;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String signature;
        private ImmutableList.Builder<String> exceptions = ImmutableList.builder();
        private ImmutableList.Builder<Advice> advisors = ImmutableList.builder();
        private ImmutableList.Builder<Advice> subTypeRestrictedAdvisors = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AnalyzedMethod instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.addAllParameterTypes(instance.parameterTypes());
            this.returnType(instance.returnType());
            this.modifiers(instance.modifiers());
            @org.checkerframework.checker.nullness.qual.Nullable String signatureValue = instance.signature();
            if (signatureValue != null) {
                this.signature(signatureValue);
            }
            this.addAllExceptions(instance.exceptions());
            this.addAllAdvisors(instance.advisors());
            this.addAllSubTypeRestrictedAdvisors(instance.subTypeRestrictedAdvisors());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterTypes(String element) {
            this.parameterTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameterTypes(Iterable<String> elements) {
            this.parameterTypes = ImmutableList.builder();
            return this.addAllParameterTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypes.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returnType(String returnType) {
            this.returnType = Objects.requireNonNull(returnType, "returnType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(@org.checkerframework.checker.nullness.qual.Nullable String signature) {
            this.signature = signature;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExceptions(String element) {
            this.exceptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExceptions(String ... elements) {
            this.exceptions.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exceptions(Iterable<String> elements) {
            this.exceptions = ImmutableList.builder();
            return this.addAllExceptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExceptions(Iterable<String> elements) {
            this.exceptions.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdvisors(Advice element) {
            this.advisors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdvisors(Advice ... elements) {
            this.advisors.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder advisors(Iterable<? extends Advice> elements) {
            this.advisors = ImmutableList.builder();
            return this.addAllAdvisors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdvisors(Iterable<? extends Advice> elements) {
            this.advisors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubTypeRestrictedAdvisors(Advice element) {
            this.subTypeRestrictedAdvisors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSubTypeRestrictedAdvisors(Advice ... elements) {
            this.subTypeRestrictedAdvisors.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subTypeRestrictedAdvisors(Iterable<? extends Advice> elements) {
            this.subTypeRestrictedAdvisors = ImmutableList.builder();
            return this.addAllSubTypeRestrictedAdvisors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSubTypeRestrictedAdvisors(Iterable<? extends Advice> elements) {
            this.subTypeRestrictedAdvisors.addAll(elements);
            return this;
        }

        public ImmutableAnalyzedMethod build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnalyzedMethod(this.name, (ImmutableList)this.parameterTypes.build(), this.returnType, this.modifiers, this.signature, (ImmutableList)this.exceptions.build(), (ImmutableList)this.advisors.build(), (ImmutableList)this.subTypeRestrictedAdvisors.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("returnType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modifiers");
            }
            return "Cannot build AnalyzedMethod, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AnalyzedMethod", generator="Immutables")
    static final class Json
    extends AnalyzedMethod {
        @Nullable
        String name;
        @Nullable
        ImmutableList<String> parameterTypes = ImmutableList.of();
        @Nullable
        String returnType;
        int modifiers;
        boolean modifiersIsSet;
        @Nullable
        @org.checkerframework.checker.nullness.qual.Nullable String signature;
        @Nullable
        ImmutableList<String> exceptions = ImmutableList.of();
        @Nullable
        ImmutableList<Advice> advisors = ImmutableList.of();
        @Nullable
        ImmutableList<Advice> subTypeRestrictedAdvisors = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="parameterTypes")
        public void setParameterTypes(ImmutableList<String> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @JsonProperty(value="returnType")
        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        @JsonProperty(value="modifiers")
        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
            this.modifiersIsSet = true;
        }

        @JsonProperty(value="signature")
        public void setSignature(@org.checkerframework.checker.nullness.qual.Nullable String signature) {
            this.signature = signature;
        }

        @JsonProperty(value="exceptions")
        public void setExceptions(ImmutableList<String> exceptions) {
            this.exceptions = exceptions;
        }

        @JsonProperty(value="advisors")
        public void setAdvisors(ImmutableList<Advice> advisors) {
            this.advisors = advisors;
        }

        @JsonProperty(value="subTypeRestrictedAdvisors")
        public void setSubTypeRestrictedAdvisors(ImmutableList<Advice> subTypeRestrictedAdvisors) {
            this.subTypeRestrictedAdvisors = subTypeRestrictedAdvisors;
        }

        @Override
        String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> parameterTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        String returnType() {
            throw new UnsupportedOperationException();
        }

        @Override
        int modifiers() {
            throw new UnsupportedOperationException();
        }

        @Override
        @org.checkerframework.checker.nullness.qual.Nullable String signature() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> exceptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<Advice> advisors() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<Advice> subTypeRestrictedAdvisors() {
            throw new UnsupportedOperationException();
        }
    }
}

