/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Modifier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AnalyzedMethod;
import org.glowroot.agent.weaving.MixinType;
import org.glowroot.agent.weaving.PublicFinalMethod;
import org.glowroot.agent.weaving.ShimType;
import org.immutables.value.Value;

@Value.Immutable
abstract class AnalyzedClass {
    AnalyzedClass() {
    }

    abstract int modifiers();

    abstract String name();

    abstract @Nullable String superName();

    abstract ImmutableList<String> interfaceNames();

    abstract ImmutableList<AnalyzedMethod> analyzedMethods();

    abstract ImmutableList<PublicFinalMethod> publicFinalMethods();

    abstract ImmutableList<ShimType> shimTypes();

    abstract ImmutableList<MixinType> mixinTypes();

    abstract ImmutableList<MixinType> nonReweavableMixinTypes();

    abstract boolean ejbRemote();

    boolean isInterface() {
        return Modifier.isInterface(this.modifiers());
    }

    boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers());
    }

    boolean hasReweavableAdvice() {
        for (AnalyzedMethod analyzedMethod : this.analyzedMethods()) {
            for (Advice advice : analyzedMethod.advisors()) {
                if (!advice.reweavable()) continue;
                return true;
            }
        }
        return false;
    }
}

