/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.org.glowroot.common.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableServiceCall;

public class ServiceCallCollector {
    private static final String LIMIT_EXCEEDED_BUCKET = "LIMIT EXCEEDED BUCKET";
    private final Map<String, Map<String, MutableServiceCall>> serviceCalls = Maps.newHashMap();
    private final Map<String, MutableServiceCall> limitExceededBuckets = Maps.newHashMap();
    private final int limit;
    private long lastCaptureTime;

    public ServiceCallCollector(int limit) {
        this.limit = limit;
    }

    public void updateLastCaptureTime(long captureTime) {
        this.lastCaptureTime = Math.max(this.lastCaptureTime, captureTime);
    }

    public long getLastCaptureTime() {
        return this.lastCaptureTime;
    }

    public List<MutableServiceCall> getSortedAndTruncatedServiceCalls() {
        List<MutableServiceCall> allServiceCalls = Lists.newArrayList();
        for (Map.Entry<String, Map<String, MutableServiceCall>> outerEntry : this.serviceCalls.entrySet()) {
            allServiceCalls.addAll(outerEntry.getValue().values());
        }
        if (allServiceCalls.size() <= this.limit) {
            allServiceCalls.addAll(this.limitExceededBuckets.values());
            return MutableServiceCall.byTotalDurationDesc.sortedCopy(allServiceCalls);
        }
        allServiceCalls = MutableServiceCall.byTotalDurationDesc.sortedCopy(allServiceCalls);
        List exceededServiceCalls = allServiceCalls.subList(this.limit, allServiceCalls.size());
        allServiceCalls = Lists.newArrayList(allServiceCalls.subList(0, this.limit));
        Map<String, MutableServiceCall> limitExceededBuckets = this.copyLimitExceededBuckets();
        for (MutableServiceCall exceededServiceCall : exceededServiceCalls) {
            String serviceCallType = exceededServiceCall.getType();
            MutableServiceCall limitExceededBucket = limitExceededBuckets.get(serviceCallType);
            if (limitExceededBucket == null) {
                limitExceededBucket = new MutableServiceCall(serviceCallType, LIMIT_EXCEEDED_BUCKET);
                limitExceededBuckets.put(serviceCallType, limitExceededBucket);
            }
            limitExceededBucket.add(exceededServiceCall);
        }
        allServiceCalls.addAll(limitExceededBuckets.values());
        Collections.sort(allServiceCalls, MutableServiceCall.byTotalDurationDesc);
        return allServiceCalls;
    }

    public void mergeServiceCall(String serviceCallType, String serviceCallText, double totalDurationNanos, long executionCount) {
        MutableServiceCall aggregateServiceCall;
        if (serviceCallText.equals(LIMIT_EXCEEDED_BUCKET)) {
            aggregateServiceCall = this.limitExceededBuckets.get(serviceCallType);
            if (aggregateServiceCall == null) {
                aggregateServiceCall = new MutableServiceCall(serviceCallType, LIMIT_EXCEEDED_BUCKET);
                this.limitExceededBuckets.put(serviceCallType, aggregateServiceCall);
            }
        } else {
            Map<String, MutableServiceCall> serviceCallsForType = this.serviceCalls.get(serviceCallType);
            if (serviceCallsForType == null) {
                serviceCallsForType = Maps.newHashMap();
                this.serviceCalls.put(serviceCallType, serviceCallsForType);
            }
            if ((aggregateServiceCall = serviceCallsForType.get(serviceCallText)) == null) {
                aggregateServiceCall = new MutableServiceCall(serviceCallType, serviceCallText);
                serviceCallsForType.put(serviceCallText, aggregateServiceCall);
            }
        }
        aggregateServiceCall.addToTotalDurationNanos(totalDurationNanos);
        aggregateServiceCall.addToExecutionCount(executionCount);
    }

    private Map<String, MutableServiceCall> copyLimitExceededBuckets() {
        HashMap<String, MutableServiceCall> copies = Maps.newHashMap();
        for (Map.Entry<String, MutableServiceCall> entry : this.limitExceededBuckets.entrySet()) {
            String serviceCallType = entry.getKey();
            MutableServiceCall limitExceededBucket = entry.getValue();
            MutableServiceCall copy = new MutableServiceCall(serviceCallType, LIMIT_EXCEEDED_BUCKET);
            copy.add(limitExceededBucket);
            copies.put(serviceCallType, copy);
        }
        return copies;
    }
}

