/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.common.base;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;

public final class Functions {
    public static <E> Function<E, E> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <A, B, C> Function<A, C> compose(Function<B, C> g, Function<A, ? extends B> f) {
        return new FunctionComposition<A, B, C>(g, f);
    }

    private static class FunctionComposition<A, B, C>
    implements Serializable,
    Function<A, C> {
        private final Function<B, C> g;
        private final Function<A, ? extends B> f;

        public FunctionComposition(Function<B, C> g, Function<A, ? extends B> f) {
            this.g = Preconditions.checkNotNull(g);
            this.f = Preconditions.checkNotNull(f);
        }

        @Override
        public C apply(A a) {
            return this.g.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(@CheckForNull Object obj) {
            if (obj instanceof FunctionComposition) {
                FunctionComposition that = (FunctionComposition)obj;
                return this.f.equals(that.f) && this.g.equals(that.g);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.g.hashCode();
        }

        public String toString() {
            return this.g + "(" + this.f + ")";
        }
    }

    private static enum IdentityFunction implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        @CheckForNull
        public Object apply(@CheckForNull Object o) {
            return o;
        }

        public String toString() {
            return "Functions.identity()";
        }
    }
}

