/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.google.common.base;

import org.glowroot.agent.shaded.com.google.common.base.Preconditions;

public final class Ascii {
    public static String toLowerCase(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (!Ascii.isUpperCase(string.charAt(i))) continue;
            char[] chars = string.toCharArray();
            while (i < length) {
                char c = chars[i];
                if (Ascii.isUpperCase(c)) {
                    chars[i] = (char)(c ^ 0x20);
                }
                ++i;
            }
            return String.valueOf(chars);
        }
        return string;
    }

    public static char toLowerCase(char c) {
        return Ascii.isUpperCase(c) ? (char)(c ^ 0x20) : c;
    }

    public static String toUpperCase(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (!Ascii.isLowerCase(string.charAt(i))) continue;
            char[] chars = string.toCharArray();
            while (i < length) {
                char c = chars[i];
                if (Ascii.isLowerCase(c)) {
                    chars[i] = (char)(c ^ 0x20);
                }
                ++i;
            }
            return String.valueOf(chars);
        }
        return string;
    }

    public static char toUpperCase(char c) {
        return Ascii.isLowerCase(c) ? (char)(c ^ 0x20) : c;
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static String truncate(CharSequence seq, int maxLength, String truncationIndicator) {
        Preconditions.checkNotNull(seq);
        int truncationLength = maxLength - truncationIndicator.length();
        Preconditions.checkArgument(truncationLength >= 0, "maxLength (%s) must be >= length of the truncation indicator (%s)", maxLength, truncationIndicator.length());
        if (seq.length() <= maxLength) {
            String string = seq.toString();
            if (string.length() <= maxLength) {
                return string;
            }
            seq = string;
        }
        return new StringBuilder(maxLength).append(seq, 0, truncationLength).append(truncationIndicator).toString();
    }
}

