/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.netty.bclglowrootbcl.Util;

public class NettyAspect {
    private static void endTransaction(ChannelMixin channelMixin) {
        ThreadContext context = channelMixin.glowroot$getThreadContextToComplete();
        if (context != null) {
            context.setTransactionAsyncComplete();
            channelMixin.glowroot$setThreadContextToComplete(null);
            channelMixin.glowroot$setAuxContext(null);
        }
    }

    @Pointcut(className="io.netty.channel.ChannelOutboundHandler", methodName="write", methodParameterTypes={"io.netty.channel.ChannelHandlerContext", "java.lang.Object", "io.netty.channel.ChannelPromise"})
    public static class OutboundAdvice {
        @OnAfter
        public static void onAfter(@BindParameter @Nullable ChannelHandlerContext channelHandlerContext, @BindParameter @Nullable Object msg) {
            if (!(msg instanceof LastHttpContentShim)) {
                return;
            }
            if (channelHandlerContext == null) {
                return;
            }
            Channel channel = channelHandlerContext.channel();
            if (channel == null) {
                return;
            }
            NettyAspect.endTransaction((ChannelMixin)channel);
        }
    }

    @Pointcut(className="io.netty.channel.ChannelHandlerContext", methodName="fireChannelReadComplete", methodParameterTypes={}, nestingGroup="netty-inbound")
    public static class InboundCompleteAdvice {
        @OnBefore
        @Nullable
        public static TraceEntry onBefore(@BindReceiver ChannelHandlerContext channelHandlerContext) {
            ChannelMixin channel = (ChannelMixin)channelHandlerContext.channel();
            if (channel == null) {
                return null;
            }
            AuxThreadContext auxContext = channel.glowroot$getAuxContext();
            if (auxContext == null) {
                return null;
            }
            return auxContext.start();
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.endWithError(t);
            }
        }
    }

    @Pointcut(className="io.netty.channel.ChannelHandlerContext", methodName="fireChannelRead", methodParameterTypes={"java.lang.Object"}, nestingGroup="netty-inbound", timerName="http request")
    public static class InboundAdvice {
        private static final TimerName timerName = Agent.getTimerName(InboundAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(OptionalThreadContext context, @BindReceiver ChannelHandlerContext channelHandlerContext, @BindParameter @Nullable Object msg) {
            Channel channel = channelHandlerContext.channel();
            if (channel == null) {
                return null;
            }
            final ChannelMixin channelMixin = (ChannelMixin)channel;
            AuxThreadContext auxContext = channelMixin.glowroot$getAuxContext();
            if (auxContext != null) {
                return auxContext.start();
            }
            if (!(msg instanceof HttpRequestShim)) {
                return null;
            }
            HttpRequestShim request = (HttpRequestShim)msg;
            HttpMethodShim method = request.glowroot$getMethod();
            String methodName = method == null ? null : method.name();
            TraceEntry traceEntry = Util.startAsyncTransaction(context, methodName, request.getUri(), timerName);
            channelMixin.glowroot$setThreadContextToComplete(context);
            channel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) {
                    NettyAspect.endTransaction(channelMixin);
                }
            });
            if (!(msg instanceof LastHttpContentShim)) {
                channelMixin.glowroot$setAuxContext(context.createAuxThreadContext());
            }
            return traceEntry;
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry) {
            if (traceEntry != null) {
                traceEntry.endWithError(t);
            }
        }
    }

    @Shim(value={"io.netty.handler.codec.http.LastHttpContent"})
    public static interface LastHttpContentShim {
    }

    @Shim(value={"io.netty.handler.codec.http.HttpMethod"})
    public static interface HttpMethodShim {
        @Nullable
        public String name();
    }

    @Shim(value={"io.netty.handler.codec.http.HttpRequest"})
    public static interface HttpRequestShim {
        @Shim(value={"io.netty.handler.codec.http.HttpMethod getMethod()"})
        public HttpMethodShim glowroot$getMethod();

        @Nullable
        public String getUri();
    }

    public static interface ChannelMixin {
        @Nullable
        public ThreadContext glowroot$getThreadContextToComplete();

        public void glowroot$setThreadContextToComplete(@Nullable ThreadContext var1);

        @Nullable
        public AuxThreadContext glowroot$getAuxContext();

        public void glowroot$setAuxContext(@Nullable AuxThreadContext var1);
    }

    @Mixin(value={"io.netty.channel.Channel"})
    public static abstract class ChannelImpl
    implements ChannelMixin {
        @Nullable
        private volatile transient ThreadContext glowroot$threadContextToComplete;
        @Nullable
        private volatile transient AuxThreadContext glowroot$auxContext;

        @Override
        @Nullable
        public ThreadContext glowroot$getThreadContextToComplete() {
            return this.glowroot$threadContextToComplete;
        }

        @Override
        public void glowroot$setThreadContextToComplete(@Nullable ThreadContext threadContextToComplete) {
            this.glowroot$threadContextToComplete = threadContextToComplete;
        }

        @Override
        @Nullable
        public AuxThreadContext glowroot$getAuxContext() {
            return this.glowroot$auxContext;
        }

        @Override
        public void glowroot$setAuxContext(@Nullable AuxThreadContext auxContext) {
            this.glowroot$auxContext = auxContext;
        }
    }
}

