/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.model.MutableServiceCall;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

public class ServiceCallCollector {
    private static final String LIMIT_EXCEEDED_BUCKET = "LIMIT EXCEEDED BUCKET";
    private final Map<String, Map<String, MutableServiceCall>> serviceCalls = Maps.newHashMap();
    private final Map<String, MutableServiceCall> limitExceededBuckets = Maps.newHashMap();
    private final int limit;
    private final int hardLimitMultiplierWhileBuilding;
    private int serviceCallCount;

    public ServiceCallCollector(int limit, int hardLimitMultiplierWhileBuilding) {
        this.limit = limit;
        this.hardLimitMultiplierWhileBuilding = hardLimitMultiplierWhileBuilding;
    }

    public List<AggregateOuterClass.Aggregate.ServiceCall> toAggregateProto() {
        ArrayList<AggregateOuterClass.Aggregate.ServiceCall> allServiceCalls = Lists.newArrayListWithCapacity(Math.min(this.serviceCallCount, this.limit) + this.serviceCalls.size());
        for (Map.Entry<String, Map<String, MutableServiceCall>> entry : this.serviceCalls.entrySet()) {
            for (Map.Entry<String, MutableServiceCall> innerEntry : entry.getValue().entrySet()) {
                allServiceCalls.add(innerEntry.getValue().toAggregateProto(entry.getKey(), innerEntry.getKey()));
            }
        }
        if (allServiceCalls.size() <= this.limit) {
            for (Map.Entry<String, Object> entry : this.limitExceededBuckets.entrySet()) {
                allServiceCalls.add(((MutableServiceCall)entry.getValue()).toAggregateProto(entry.getKey(), LIMIT_EXCEEDED_BUCKET));
            }
            ServiceCallCollector.sort(allServiceCalls);
            return allServiceCalls;
        }
        ServiceCallCollector.sort(allServiceCalls);
        List exceededServiceCalls = allServiceCalls.subList(this.limit, allServiceCalls.size());
        allServiceCalls = Lists.newArrayList(allServiceCalls.subList(0, this.limit));
        Map<String, MutableServiceCall> map = this.copyLimitExceededBuckets();
        for (AggregateOuterClass.Aggregate.ServiceCall exceededServiceCall : exceededServiceCalls) {
            String queryType = exceededServiceCall.getType();
            MutableServiceCall limitExceededBucket = map.get(queryType);
            if (limitExceededBucket == null) {
                limitExceededBucket = new MutableServiceCall();
                map.put(queryType, limitExceededBucket);
            }
            limitExceededBucket.add(exceededServiceCall);
        }
        for (Map.Entry<String, MutableServiceCall> entry : map.entrySet()) {
            allServiceCalls.add(entry.getValue().toAggregateProto(entry.getKey(), LIMIT_EXCEEDED_BUCKET));
        }
        ServiceCallCollector.sort(allServiceCalls);
        return allServiceCalls;
    }

    public void mergeServiceCall(String serviceCallType, String serviceCallText, double totalDurationNanos, long executionCount) {
        MutableServiceCall aggregateServiceCall;
        Map<String, MutableServiceCall> serviceCallsForType = this.serviceCalls.get(serviceCallType);
        if (serviceCallsForType == null) {
            serviceCallsForType = Maps.newHashMap();
            this.serviceCalls.put(serviceCallType, serviceCallsForType);
        }
        if ((aggregateServiceCall = serviceCallsForType.get(serviceCallText)) == null) {
            if (this.serviceCallCount < this.limit * this.hardLimitMultiplierWhileBuilding) {
                aggregateServiceCall = new MutableServiceCall();
                serviceCallsForType.put(serviceCallText, aggregateServiceCall);
                ++this.serviceCallCount;
            } else {
                aggregateServiceCall = this.getOrCreateLimitExceededBucket(serviceCallType);
            }
        }
        aggregateServiceCall.addToTotalDurationNanos(totalDurationNanos);
        aggregateServiceCall.addToExecutionCount(executionCount);
    }

    public void mergeServiceCallsInto(ServiceCallCollector collector) {
        for (Map.Entry<String, Map<String, MutableServiceCall>> entry : this.serviceCalls.entrySet()) {
            for (Map.Entry<String, MutableServiceCall> entry2 : entry.getValue().entrySet()) {
                MutableServiceCall serviceCall = entry2.getValue();
                collector.mergeServiceCall(entry.getKey(), entry2.getKey(), serviceCall.getTotalDurationNanos(), serviceCall.getExecutionCount());
            }
        }
        for (Map.Entry<String, Object> entry : this.limitExceededBuckets.entrySet()) {
            collector.mergeLimitExceededBucket(entry.getKey(), (MutableServiceCall)entry.getValue());
        }
    }

    public void mergeServiceCallsInto(org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector collector) {
        for (Map.Entry<String, Map<String, MutableServiceCall>> entry : this.serviceCalls.entrySet()) {
            for (Map.Entry<String, MutableServiceCall> entry2 : entry.getValue().entrySet()) {
                MutableServiceCall serviceCall = entry2.getValue();
                collector.mergeServiceCall(entry.getKey(), entry2.getKey(), serviceCall.getTotalDurationNanos(), serviceCall.getExecutionCount());
            }
        }
        for (Map.Entry<String, Object> entry : this.limitExceededBuckets.entrySet()) {
            MutableServiceCall serviceCall = (MutableServiceCall)entry.getValue();
            collector.mergeServiceCall(entry.getKey(), LIMIT_EXCEEDED_BUCKET, serviceCall.getTotalDurationNanos(), serviceCall.getExecutionCount());
        }
    }

    private void mergeLimitExceededBucket(String serviceCallType, MutableServiceCall limitExceededBucket) {
        MutableServiceCall serviceCall = this.getOrCreateLimitExceededBucket(serviceCallType);
        serviceCall.add(limitExceededBucket);
    }

    private MutableServiceCall getOrCreateLimitExceededBucket(String serviceCallType) {
        MutableServiceCall serviceCall = this.limitExceededBuckets.get(serviceCallType);
        if (serviceCall == null) {
            serviceCall = new MutableServiceCall();
            this.limitExceededBuckets.put(serviceCallType, serviceCall);
        }
        return serviceCall;
    }

    private Map<String, MutableServiceCall> copyLimitExceededBuckets() {
        HashMap<String, MutableServiceCall> copies = Maps.newHashMap();
        for (Map.Entry<String, MutableServiceCall> entry : this.limitExceededBuckets.entrySet()) {
            String serviceCallType = entry.getKey();
            MutableServiceCall limitExceededBucket = entry.getValue();
            MutableServiceCall copy = new MutableServiceCall();
            copy.add(limitExceededBucket);
            copies.put(serviceCallType, copy);
        }
        return copies;
    }

    private static void sort(List<AggregateOuterClass.Aggregate.ServiceCall> serviceCalls) {
        Collections.sort(serviceCalls, new Comparator<AggregateOuterClass.Aggregate.ServiceCall>(){

            @Override
            public int compare(AggregateOuterClass.Aggregate.ServiceCall left, AggregateOuterClass.Aggregate.ServiceCall right) {
                return Doubles.compare(right.getTotalDurationNanos(), left.getTotalDurationNanos());
            }
        });
    }
}

