/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.impl.NestedTimerMap;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.model.AggregatedTimer;
import org.glowroot.agent.model.ImmutableTransactionTimerSnapshot;
import org.glowroot.agent.model.TimerNameImpl;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Tickers;

@Styles.Private
public class TimerImpl
implements TransactionTimer,
Timer {
    private static final Logger logger = LoggerFactory.getLogger(TimerImpl.class);
    private static final Ticker ticker = Tickers.getTicker();
    private final ThreadContextImpl threadContext;
    private final @Nullable TimerImpl parent;
    private final TimerNameImpl timerName;
    private long totalNanos;
    private long count;
    private long startTick;
    private int selfNestingLevel;
    private @MonotonicNonNull NestedTimerMap nestedTimers;
    private @MonotonicNonNull TimerImpl headChild;
    private final @Nullable TimerImpl nextSibling;

    static TimerImpl createRootTimer(ThreadContextImpl threadContext, TimerNameImpl timerName) {
        return new TimerImpl(threadContext, null, null, timerName);
    }

    private TimerImpl(ThreadContextImpl threadContext, @Nullable TimerImpl parent, @Nullable TimerImpl nextSibling, TimerNameImpl timerName) {
        this.timerName = timerName;
        this.parent = parent;
        this.nextSibling = nextSibling;
        this.threadContext = threadContext;
    }

    @JsonIgnore
    TraceOuterClass.Trace.Timer toProto() {
        TraceOuterClass.Trace.Timer.Builder builder = TraceOuterClass.Trace.Timer.newBuilder();
        builder.setName(this.timerName.name());
        builder.setExtended(this.timerName.extended());
        TransactionTimer.TransactionTimerSnapshot snapshot = this.getSnapshot();
        builder.setTotalNanos(snapshot.totalNanos());
        builder.setCount(snapshot.count());
        builder.setActive(snapshot.active());
        if (this.headChild != null) {
            ArrayList<TraceOuterClass.Trace.Timer> nestedTimers = Lists.newArrayList();
            TimerImpl curr = this.headChild;
            while (curr != null) {
                nestedTimers.add(curr.toProto());
                curr = curr.nextSibling;
            }
            builder.addAllChildTimer(nestedTimers);
        }
        return builder.build();
    }

    @Override
    public TransactionTimer.TransactionTimerSnapshot getSnapshot() {
        if (this.selfNestingLevel > 0) {
            long theTotalNanos = this.totalNanos;
            long theStartTick = this.startTick;
            long curr = ticker.read() - theStartTick;
            if (theTotalNanos == 0L) {
                return ImmutableTransactionTimerSnapshot.of(curr, 1L, true);
            }
            return ImmutableTransactionTimerSnapshot.of(theTotalNanos + curr, this.count + 1L, true);
        }
        return ImmutableTransactionTimerSnapshot.of(this.totalNanos, this.count, false);
    }

    @Override
    public void stop() {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(ticker.read());
        }
    }

    public Timer extend(TimerImpl currentTimer) {
        return this.extend(ticker.read(), currentTimer);
    }

    void end(long endTick) {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(endTick);
        }
    }

    @Override
    public String getName() {
        return this.timerName.name();
    }

    @Override
    public boolean isExtended() {
        return this.timerName.extended();
    }

    @Override
    public long getTotalNanos() {
        return this.totalNanos;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void mergeChildTimersInto(AggregatedTimer timer) {
        TimerImpl curr = this.headChild;
        while (curr != null) {
            String currName = curr.getName();
            boolean extended = curr.isExtended();
            AggregatedTimer matchingChildTimer = null;
            for (AggregatedTimer aggregatedTimer : timer.getChildTimers()) {
                if (!currName.equals(aggregatedTimer.getName()) || extended != aggregatedTimer.isExtended()) continue;
                matchingChildTimer = aggregatedTimer;
                break;
            }
            if (matchingChildTimer == null) {
                matchingChildTimer = timer.newChildTimer(curr.getName(), curr.isExtended());
            }
            matchingChildTimer.addDataFrom(curr);
            curr = curr.nextSibling;
        }
    }

    public TimerImpl startNestedTimer(TimerName timerName, long startTick) {
        if (this.timerName == timerName) {
            ++this.selfNestingLevel;
            return this;
        }
        return this.startNestedTimerInternal(timerName, startTick);
    }

    TimerImpl startNestedTimer(TimerName timerName) {
        if (this.timerName == timerName) {
            ++this.selfNestingLevel;
            return this;
        }
        long nestedTimerStartTick = ticker.read();
        return this.startNestedTimerInternal(timerName, nestedTimerStartTick);
    }

    TimerImpl extend(long startTick, TimerImpl currentTimer) {
        if (currentTimer == this.parent) {
            --this.count;
            this.start(startTick);
            return this;
        }
        if (currentTimer == this) {
            ++this.selfNestingLevel;
            return this;
        }
        TimerNameImpl extendedTimer = this.timerName.extendedTimer();
        if (extendedTimer == null) {
            logger.warn("extend() should only be accessible to non-extended timers");
            return this;
        }
        return currentTimer.startNestedTimer(extendedTimer);
    }

    void start(long startTick) {
        this.startTick = startTick;
        ++this.selfNestingLevel;
        this.threadContext.setCurrentTimer(this);
    }

    private void endInternal(long endTick) {
        this.totalNanos += endTick - this.startTick;
        ++this.count;
        this.threadContext.setCurrentTimer(this.parent);
    }

    private TimerImpl startNestedTimerInternal(TimerName timerName, long nestedTimerStartTick) {
        TimerNameImpl timerNameImpl;
        TimerImpl nestedTimer;
        if (this.nestedTimers == null) {
            this.nestedTimers = new NestedTimerMap();
        }
        if ((nestedTimer = this.nestedTimers.get(timerNameImpl = (TimerNameImpl)timerName)) != null) {
            nestedTimer.start(nestedTimerStartTick);
            return nestedTimer;
        }
        nestedTimer = new TimerImpl(this.threadContext, this, this.headChild, timerNameImpl);
        nestedTimer.start(nestedTimerStartTick);
        this.nestedTimers.put(timerNameImpl, nestedTimer);
        this.headChild = nestedTimer;
        return nestedTimer;
    }
}

