/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.central.CentralConnection;
import org.glowroot.agent.central.DownstreamServiceObserver;
import org.glowroot.agent.central.SharedQueryTextLimiter;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.live.LiveJvmServiceImpl;
import org.glowroot.agent.live.LiveTraceRepositoryImpl;
import org.glowroot.agent.live.LiveWeavingServiceImpl;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.io.Closer;
import org.glowroot.agent.shaded.io.grpc.stub.StreamObserver;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.PropertiesFiles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceGrpc;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class CentralCollector
implements Collector {
    private static final Logger logger = LoggerFactory.getLogger(CentralCollector.class);
    private static final Logger startupLogger = LoggerFactory.getLogger("org.glowroot");
    private static final boolean SKIP_DELAY = Integer.getInteger("glowroot.internal.rollup.0.intervalMillis", 60000) < 10000;
    private final String agentId;
    private final String collectorAddress;
    private final ConfigService configService;
    private final boolean configReadOnly;
    private final File configSyncedFile;
    private final CentralConnection centralConnection;
    private final CollectorServiceGrpc.CollectorServiceStub collectorServiceStub;
    private final DownstreamServiceObserver downstreamServiceObserver;
    private final SharedQueryTextLimiter sharedQueryTextLimiter = new SharedQueryTextLimiter();
    private volatile  @MonotonicNonNull CollectorServiceOuterClass.InitMessage.Environment environment;
    private volatile int nextAggregateDelayMillis;

    public CentralCollector(Map<String, String> properties, String collectorAddress, @Nullable String collectorAuthority, List<File> confDirs, boolean configReadOnly, LiveJvmServiceImpl liveJvmService, LiveWeavingServiceImpl liveWeavingService, LiveTraceRepositoryImpl liveTraceRepository, Collector.AgentConfigUpdater agentConfigUpdater, ConfigService configService) throws Exception {
        String v09AgentRollupId;
        String agentId = properties.get("glowroot.agent.id");
        if (agentId == null) {
            agentId = CentralCollector.escapeHostname(InetAddress.getLocalHost().getHostName());
        } else if (agentId.endsWith("::")) {
            agentId = agentId + CentralCollector.escapeHostname(InetAddress.getLocalHost().getHostName());
        } else if (!agentId.contains("::") && (v09AgentRollupId = properties.get("glowroot.agent.rollup.id")) != null) {
            agentId = CentralCollector.convertFromV09AgentRollupId(v09AgentRollupId) + agentId;
        }
        this.agentId = agentId;
        this.collectorAddress = collectorAddress;
        this.configService = configService;
        this.configReadOnly = configReadOnly;
        this.configSyncedFile = new File(confDirs.get(0), "config.synced");
        startupLogger.info("agent id: {}", (Object)agentId);
        AtomicBoolean inConnectionFailure = new AtomicBoolean();
        this.centralConnection = new CentralConnection(collectorAddress, collectorAuthority, confDirs, inConnectionFailure);
        this.collectorServiceStub = (CollectorServiceGrpc.CollectorServiceStub)CollectorServiceGrpc.newStub(this.centralConnection.getChannel()).withCompression("gzip");
        this.downstreamServiceObserver = new DownstreamServiceObserver(this.centralConnection, agentConfigUpdater, configReadOnly, liveJvmService, liveWeavingService, liveTraceRepository, agentId, inConnectionFailure, this.sharedQueryTextLimiter);
    }

    @Override
    public void init(List<File> confDirs, final CollectorServiceOuterClass.InitMessage.Environment environment, AgentConfigOuterClass.AgentConfig agentConfig, final Collector.AgentConfigUpdater agentConfigUpdater) throws IOException {
        final String configSyncedAgentId = this.configReadOnly ? "" : CentralCollector.readConfigSyncedAgentId(this.configSyncedFile);
        final CollectorServiceOuterClass.InitMessage initMessage = CollectorServiceOuterClass.InitMessage.newBuilder().setAgentId(this.agentId).setEnvironment(environment).setAgentConfig(agentConfig.toBuilder().setConfigReadOnly(this.configReadOnly)).setOverwriteExistingAgentConfig(!this.agentId.equals(configSyncedAgentId) || this.configReadOnly).build();
        this.centralConnection.asyncCallInit(new CentralConnection.GrpcCall<CollectorServiceOuterClass.InitResponse>(){

            @Override
            public void call(StreamObserver<CollectorServiceOuterClass.InitResponse> responseObserver) {
                CentralCollector.this.collectorServiceStub.collectInit(initMessage, responseObserver);
            }

            @Override
            void doWithResponse(CollectorServiceOuterClass.InitResponse response) {
                CentralCollector.this.environment = environment;
                startupLogger.info("connected to the central collector {}, version {}", (Object)CentralCollector.this.collectorAddress, (Object)response.getGlowrootCentralVersion());
                if (CentralCollector.isAgentVersionGreaterThanCentralVersion(environment.getJavaInfo().getGlowrootAgentVersion(), response.getGlowrootCentralVersion())) {
                    startupLogger.warn("the central collector version is older than the agent version which could cause unpredictable issues");
                }
                if (response.hasAgentConfig() && !CentralCollector.this.configReadOnly) {
                    try {
                        agentConfigUpdater.update(response.getAgentConfig());
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), e);
                    }
                }
                if (!CentralCollector.this.agentId.equals(configSyncedAgentId) && !CentralCollector.this.configReadOnly) {
                    try {
                        CentralCollector.writeConfigSyncedFile(CentralCollector.this.configSyncedFile, CentralCollector.this.agentId);
                    }
                    catch (IOException e) {
                        startupLogger.error("could not write to file '{}': {}", CentralCollector.this.configSyncedFile.getAbsolutePath(), e.getMessage(), e);
                    }
                }
                CentralCollector.this.downstreamServiceObserver.connectAsync();
            }
        });
    }

    @Override
    public void collectAggregates(Collector.AggregateReader aggregateReader) throws InterruptedException {
        if (!SKIP_DELAY) {
            TimeUnit.MILLISECONDS.sleep(this.nextAggregateDelayMillis);
        }
        this.centralConnection.blockingCallWithAFewRetries(new CollectAggregatesGrpcCall(aggregateReader));
    }

    @Override
    public void collectGaugeValues(List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues) throws InterruptedException {
        final CollectorServiceOuterClass.GaugeValueMessage gaugeValueMessage = CollectorServiceOuterClass.GaugeValueMessage.newBuilder().setAgentId(this.agentId).addAllGaugeValue(gaugeValues).setPostV09(true).build();
        this.centralConnection.blockingCallWithAFewRetries(new CentralConnection.GrpcCall<CollectorServiceOuterClass.GaugeValueResponseMessage>(){

            @Override
            public void call(StreamObserver<CollectorServiceOuterClass.GaugeValueResponseMessage> responseObserver) {
                CentralCollector.this.collectorServiceStub.collectGaugeValues(gaugeValueMessage, responseObserver);
            }

            @Override
            public void doWithResponse(CollectorServiceOuterClass.GaugeValueResponseMessage response) {
                if (response.getResendInit() && CentralCollector.this.environment != null) {
                    final CollectorServiceOuterClass.InitMessage initMessage = CollectorServiceOuterClass.InitMessage.newBuilder().setAgentId(CentralCollector.this.agentId).setEnvironment(CentralCollector.this.environment).setAgentConfig(CentralCollector.this.configService.getAgentConfig()).build();
                    CentralCollector.this.centralConnection.asyncCallOnce(new CentralConnection.GrpcCall<CollectorServiceOuterClass.InitResponse>(){

                        @Override
                        void call(StreamObserver<CollectorServiceOuterClass.InitResponse> responseObserver) {
                            CentralCollector.this.collectorServiceStub.collectInit(initMessage, responseObserver);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void collectTrace(Collector.TraceReader traceReader) throws InterruptedException {
        if (traceReader.partial()) {
            this.centralConnection.blockingCallOnce(new CollectTraceGrpcCall(traceReader));
        } else {
            this.centralConnection.blockingCallWithAFewRetries(new CollectTraceGrpcCall(traceReader));
        }
    }

    @Override
    public void log(CollectorServiceOuterClass.LogMessage.LogEvent logEvent) throws InterruptedException {
        if (this.centralConnection.suppressLogCollector()) {
            return;
        }
        if (logEvent.getLoggerName().equals("org.glowroot") && logEvent.getLevel() == CollectorServiceOuterClass.LogMessage.LogEvent.Level.INFO) {
            return;
        }
        final CollectorServiceOuterClass.LogMessage logMessage = CollectorServiceOuterClass.LogMessage.newBuilder().setAgentId(this.agentId).setLogEvent(logEvent).setPostV09(true).build();
        this.centralConnection.blockingCallWithAFewRetries(new CentralConnection.GrpcCall<CollectorServiceOuterClass.EmptyMessage>(){

            @Override
            public void call(StreamObserver<CollectorServiceOuterClass.EmptyMessage> responseObserver) {
                CentralCollector.this.collectorServiceStub.log(logMessage, responseObserver);
            }
        });
    }

    @OnlyUsedByTests
    public void close() throws InterruptedException {
        this.downstreamServiceObserver.close();
        this.centralConnection.close();
    }

    @OnlyUsedByTests
    public void awaitClose() throws InterruptedException {
        this.centralConnection.awaitClose();
    }

    static String escapeHostname(String hostname) {
        if ((hostname = hostname.replace("\\", "\\\\")).startsWith(":")) {
            hostname = "\\" + hostname;
        }
        while (hostname.contains("::")) {
            hostname = hostname.replace("::", ":\\:");
        }
        return hostname;
    }

    private static String convertFromV09AgentRollupId(String agentRollupId) {
        return agentRollupId.replaceAll(" */ *", "::").trim() + "::";
    }

    static boolean isAgentVersionGreaterThanCentralVersion(String agentVersion, String centralVersion) {
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\b.*");
        Matcher matcher = pattern.matcher(agentVersion);
        if (!matcher.matches()) {
            if (!agentVersion.equals("unknown")) {
                startupLogger.warn("could not parse agent version: {}", (Object)agentVersion);
            }
            return false;
        }
        int agentMajor = Integer.parseInt(Preconditions.checkNotNull(matcher.group(1)));
        int agentMinor = Integer.parseInt(Preconditions.checkNotNull(matcher.group(2)));
        int agentPatch = Integer.parseInt(Preconditions.checkNotNull(matcher.group(3)));
        matcher = pattern.matcher(centralVersion);
        if (!matcher.matches()) {
            if (!centralVersion.equals("")) {
                startupLogger.warn("could not parse central version: {}", (Object)centralVersion);
            }
            return false;
        }
        int centralMajor = Integer.parseInt(Preconditions.checkNotNull(matcher.group(1)));
        int centralMinor = Integer.parseInt(Preconditions.checkNotNull(matcher.group(2)));
        int centralPatch = Integer.parseInt(Preconditions.checkNotNull(matcher.group(3)));
        if (agentMajor > centralMajor) {
            return true;
        }
        if (agentMajor < centralMajor) {
            return false;
        }
        if (agentMinor > centralMinor) {
            return true;
        }
        if (agentMinor < centralMinor) {
            return false;
        }
        return agentPatch > centralPatch;
    }

    private static String readConfigSyncedAgentId(File file) throws IOException {
        if (file.exists()) {
            Properties properties = PropertiesFiles.load(file);
            return properties.getProperty("agent.id", "").trim();
        }
        return "";
    }

    private static void writeConfigSyncedFile(File file, String agentId) throws IOException {
        try (Closer closer = Closer.create();){
            PrintWriter out = closer.register(new PrintWriter(file, Charsets.UTF_8.name()));
            out.println("# this file is created after the agent has pushed its local configuration to the central collector");
            out.println("#");
            out.println("# when this file is present (and the agent.id below matches the running agent's agent.id), the agent");
            out.println("# will overwrite its local configuration with the agent configuration it retrieves from the central");
            out.println("# collector on JVM startup");
            out.println("#");
            out.println("# when this file is not present (or the agent.id below does not match the running agent's agent.id),");
            out.println("# the agent will push its local configuration to the central collector on JVM startup (overwriting");
            out.println("# any existing remote configuration), after which the agent will (re-)create this file using the");
            out.println("# running agent's agent.id");
            out.println("");
            out.println("agent.id=" + agentId);
        }
    }

    private class TraceVisitorImpl
    implements Collector.TraceVisitor {
        private final StreamObserver<CollectorServiceOuterClass.TraceStreamMessage> requestObserver;
        private final List<String> fullTextSha1s;
        private int entryCount;
        private int sharedQueryTextCount;

        private TraceVisitorImpl(StreamObserver<CollectorServiceOuterClass.TraceStreamMessage> requestObserver, List<String> fullTextSha1s) {
            this.requestObserver = requestObserver;
            this.fullTextSha1s = fullTextSha1s;
        }

        @Override
        public void visitEntry(TraceOuterClass.Trace.Entry entry) {
            this.requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setEntry(entry).build());
            ++this.entryCount;
        }

        @Override
        public void visitQueries(List<AggregateOuterClass.Aggregate.Query> queries) {
            this.requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setQueries(CollectorServiceOuterClass.TraceStreamMessage.Queries.newBuilder().addAllQuery(queries)).build());
        }

        @Override
        public void visitSharedQueryTexts(List<String> sharedQueryTexts) {
            for (String sharedQueryText : sharedQueryTexts) {
                TraceOuterClass.Trace.SharedQueryText traceSharedQueryText = CentralCollector.this.sharedQueryTextLimiter.buildTraceSharedQueryText(sharedQueryText, this.fullTextSha1s);
                this.requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setSharedQueryText(traceSharedQueryText).build());
            }
            this.sharedQueryTextCount = sharedQueryTexts.size();
        }

        @Override
        public void visitMainThreadProfile(ProfileOuterClass.Profile profile) {
            this.requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setMainThreadProfile(profile).build());
        }

        @Override
        public void visitAuxThreadProfile(ProfileOuterClass.Profile profile) {
            this.requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setAuxThreadProfile(profile).build());
        }

        @Override
        public void visitHeader(TraceOuterClass.Trace.Header header) {
            this.requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setHeader(header).build());
        }
    }

    private class CollectTraceGrpcCall
    extends CentralConnection.GrpcCall<CollectorServiceOuterClass.EmptyMessage> {
        private final Collector.TraceReader traceReader;
        private final List<String> fullTextSha1s = Lists.newArrayList();

        private CollectTraceGrpcCall(Collector.TraceReader traceReader) {
            this.traceReader = traceReader;
        }

        @Override
        public void call(StreamObserver<CollectorServiceOuterClass.EmptyMessage> responseObserver) {
            StreamObserver<CollectorServiceOuterClass.TraceStreamMessage> requestObserver = CentralCollector.this.collectorServiceStub.collectTraceStream(responseObserver);
            requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setStreamHeader(CollectorServiceOuterClass.TraceStreamMessage.TraceStreamHeader.newBuilder().setAgentId(CentralCollector.this.agentId).setTraceId(this.traceReader.traceId()).setUpdate(this.traceReader.update()).setPostV09(true)).build());
            this.fullTextSha1s.clear();
            TraceVisitorImpl traceVisitor = new TraceVisitorImpl(requestObserver, this.fullTextSha1s);
            try {
                this.traceReader.accept(traceVisitor);
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
                requestObserver.onError(t);
                return;
            }
            requestObserver.onNext(CollectorServiceOuterClass.TraceStreamMessage.newBuilder().setStreamCounts(CollectorServiceOuterClass.TraceStreamMessage.TraceStreamCounts.newBuilder().setEntryCount(traceVisitor.entryCount).setSharedQueryTextCount(traceVisitor.sharedQueryTextCount)).build());
            requestObserver.onCompleted();
        }

        @Override
        public void doWithResponse(CollectorServiceOuterClass.EmptyMessage response) {
            for (String fullTextSha1 : this.fullTextSha1s) {
                CentralCollector.this.sharedQueryTextLimiter.onSuccessfullySentToCentralCollector(fullTextSha1);
            }
        }
    }

    private class CollectAggregatesGrpcCall
    extends CentralConnection.GrpcCall<CollectorServiceOuterClass.AggregateResponseMessage> {
        private final Collector.AggregateReader aggregateReader;
        private final List<String> fullTextSha1s = Lists.newArrayList();

        private CollectAggregatesGrpcCall(Collector.AggregateReader aggregateReader) {
            this.aggregateReader = aggregateReader;
        }

        @Override
        public void call(StreamObserver<CollectorServiceOuterClass.AggregateResponseMessage> responseObserver) {
            StreamObserver<CollectorServiceOuterClass.AggregateStreamMessage> requestObserver = CentralCollector.this.collectorServiceStub.collectAggregateStream(responseObserver);
            requestObserver.onNext(CollectorServiceOuterClass.AggregateStreamMessage.newBuilder().setStreamHeader(CollectorServiceOuterClass.AggregateStreamMessage.AggregateStreamHeader.newBuilder().setAgentId(CentralCollector.this.agentId).setCaptureTime(this.aggregateReader.captureTime()).setPostV09(true)).build());
            this.fullTextSha1s.clear();
            try {
                this.aggregateReader.accept(new AggregateVisitorImpl(requestObserver));
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
                requestObserver.onError(t);
                return;
            }
            requestObserver.onCompleted();
        }

        @Override
        public void doWithResponse(CollectorServiceOuterClass.AggregateResponseMessage response) {
            CentralCollector.this.nextAggregateDelayMillis = Math.min(response.getNextDelayMillis(), 30000);
            for (String fullTextSha1 : this.fullTextSha1s) {
                CentralCollector.this.sharedQueryTextLimiter.onSuccessfullySentToCentralCollector(fullTextSha1);
            }
        }

        private class AggregateVisitorImpl
        implements Collector.AggregateVisitor {
            private final StreamObserver<CollectorServiceOuterClass.AggregateStreamMessage> requestObserver;

            private AggregateVisitorImpl(StreamObserver<CollectorServiceOuterClass.AggregateStreamMessage> requestObserver) {
                this.requestObserver = requestObserver;
            }

            @Override
            public void visitOverallAggregate(String transactionType, List<String> sharedQueryTexts, AggregateOuterClass.Aggregate overallAggregate) {
                for (String sharedQueryText : sharedQueryTexts) {
                    AggregateOuterClass.Aggregate.SharedQueryText aggregateSharedQueryText = CentralCollector.this.sharedQueryTextLimiter.buildAggregateSharedQueryText(sharedQueryText, CollectAggregatesGrpcCall.this.fullTextSha1s);
                    this.requestObserver.onNext(CollectorServiceOuterClass.AggregateStreamMessage.newBuilder().setSharedQueryText(aggregateSharedQueryText).build());
                }
                this.requestObserver.onNext(CollectorServiceOuterClass.AggregateStreamMessage.newBuilder().setOverallAggregate(CollectorServiceOuterClass.AggregateStreamMessage.OverallAggregate.newBuilder().setTransactionType(transactionType).setAggregate(overallAggregate)).build());
            }

            @Override
            public void visitTransactionAggregate(String transactionType, String transactionName, List<String> sharedQueryTexts, AggregateOuterClass.Aggregate transactionAggregate) {
                for (String sharedQueryText : sharedQueryTexts) {
                    this.requestObserver.onNext(CollectorServiceOuterClass.AggregateStreamMessage.newBuilder().setSharedQueryText(CentralCollector.this.sharedQueryTextLimiter.buildAggregateSharedQueryText(sharedQueryText, CollectAggregatesGrpcCall.this.fullTextSha1s)).build());
                }
                this.requestObserver.onNext(CollectorServiceOuterClass.AggregateStreamMessage.newBuilder().setTransactionAggregate(CollectorServiceOuterClass.AggregateStreamMessage.TransactionAggregate.newBuilder().setTransactionType(transactionType).setTransactionName(transactionName).setAggregate(transactionAggregate)).build());
            }
        }
    }
}

