/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.NotGuava;

class AgentDirsLocking {
    private AgentDirsLocking() {
    }

    static @Nullable Closeable tryLockAgentDirs(File tmpDir, boolean wait) throws Exception {
        NotGuava.mkdirs(tmpDir);
        File lockFile = new File(tmpDir, ".lock");
        AgentDirsLocking.touchLockFile(lockFile);
        final RandomAccessFile openLockFile = new RandomAccessFile(lockFile, "rw");
        FileLock fileLock = openLockFile.getChannel().tryLock();
        if (fileLock == null) {
            if (!wait) {
                return null;
            }
            long startTimeMillis = System.currentTimeMillis();
            do {
                TimeUnit.MILLISECONDS.sleep(100L);
            } while ((fileLock = openLockFile.getChannel().tryLock()) == null && System.currentTimeMillis() < startTimeMillis + 2000L);
            if (fileLock == null) {
                return null;
            }
        }
        lockFile.deleteOnExit();
        final FileLock fileLockFinal = fileLock;
        return new Closeable(){

            @Override
            public void close() throws IOException {
                NotGuava.checkNotNull(fileLockFinal);
                fileLockFinal.release();
                openLockFile.close();
            }
        };
    }

    private static void touchLockFile(File lockFile) throws IOException {
        boolean created;
        try {
            created = lockFile.createNewFile();
        }
        catch (IOException e) {
            throw new IOException("Unable to create lock file: " + lockFile, e);
        }
        if (!created && !lockFile.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Unable to update modification time on lock file: " + lockFile);
        }
    }
}

