#!/bin/sh

[ -z "$JOGET_HOME" ] && JOGET_HOME="."

# For a list of available Java system properties for Joget, please refer to:
# https://kb.joget.org/jw/web/userview/jdocs/docs/DX9/joget-java_opts-properties
#
# Cloud edition also includes additional properties below:
# | Property               | Type    | Default | Version | Description                                                     |
# | ---------------------- | ------- | ------- | ------- | --------------------------------------------------------------- |
# | wflow.virtualhost      | Boolean | FALSE   | DX 8    | To indicate if it is a cloud installation.                      |
# | wflow.allowSetProperty | Boolean | FALSE   | DX 8    | Whether to allow untrusted plugins to run System.setProperty(). |
export JAVA_OPTS="-Xmx1024M -Dfile.encoding=UTF-8 -Djoget.home=$JOGET_HOME -Dwflow.home=$JOGET_HOME/wflow/ -Dwflow.virtualhost=true -Djava.security.manager=allow --add-opens=java.base/java.nio=ALL-UNNAMED -javaagent:$JOGET_HOME/wflow/wflow-cluster.jar -javaagent:$JOGET_HOME/lib/aspectjweaver-1.9.22.jar -javaagent:$JOGET_HOME/wflow/glowroot/glowroot.jar" 

$JOGET_HOME/apache-tomcat-11.0.10/bin/catalina.sh $*
