/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.net.logstash.logback.appender.listener;

import java.time.Duration;
import java.util.Objects;
import org.glowroot.agent.shaded.ch.qos.logback.core.spi.DeferredProcessingAware;
import org.glowroot.agent.shaded.net.logstash.logback.appender.listener.FailureSummaryAppenderListener;
import org.glowroot.agent.shaded.net.logstash.logback.argument.StructuredArguments;
import org.glowroot.agent.shaded.net.logstash.logback.encoder.org.apache.commons.lang3.time.DateFormatUtils;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class FailureSummaryLoggingAppenderListener<Event extends DeferredProcessingAware>
extends FailureSummaryAppenderListener<Event> {
    private volatile Logger logger = LoggerFactory.getLogger(FailureSummaryLoggingAppenderListener.class);

    @Override
    protected void handleFailureSummary(FailureSummaryAppenderListener.FailureSummary failureSummary, FailureSummaryAppenderListener.CallbackType callbackType) {
        if (this.logger.isWarnEnabled()) {
            if (failureSummary.getFirstFailure() != failureSummary.getMostRecentFailure()) {
                failureSummary.getMostRecentFailure().addSuppressed(failureSummary.getFirstFailure());
            }
            this.logger.warn("{} {} failures since {} for {}.", new Object[]{StructuredArguments.value("failEventCount", failureSummary.getConsecutiveFailures()), StructuredArguments.value("failType", callbackType.name().toLowerCase()), StructuredArguments.value("failStartTime", DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(failureSummary.getFirstFailureTime())), StructuredArguments.value("failDuration", Duration.ofMillis(System.currentTimeMillis() - failureSummary.getFirstFailureTime()).toString()), failureSummary.getMostRecentFailure()});
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)Objects.requireNonNull(loggerName));
    }
}

