/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import org.glowroot.agent.embedded.shaded.org.h2.message.DbException;
import org.glowroot.agent.embedded.shaded.org.h2.util.MathUtils;
import org.glowroot.agent.embedded.shaded.org.h2.value.CompareMode;
import org.glowroot.agent.embedded.shaded.org.h2.value.Value;
import org.glowroot.agent.embedded.sql.SQLException;

public class ValueLong
extends Value {
    public static final BigInteger MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MIN_BD = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigInteger MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final ValueLong[] STATIC_CACHE = new ValueLong[100];
    private final long value;

    private ValueLong(long l) {
        this.value = l;
    }

    @Override
    public Value add(Value value) {
        ValueLong valueLong = (ValueLong)value;
        long l = this.value + valueLong.value;
        int n = Long.signum(this.value);
        int n2 = Long.signum(valueLong.value);
        int n3 = Long.signum(l);
        if (n != n2 || n3 == n2 || n == 0 || n2 == 0) {
            return ValueLong.get(l);
        }
        throw this.getOverflow();
    }

    @Override
    public int getSignum() {
        return Long.signum(this.value);
    }

    @Override
    public Value negate() {
        if (this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueLong.get(-this.value);
    }

    private DbException getOverflow() {
        return DbException.get(22003, Long.toString(this.value));
    }

    @Override
    public Value subtract(Value value) {
        int n;
        ValueLong valueLong = (ValueLong)value;
        int n2 = Long.signum(this.value);
        if (n2 == (n = Long.signum(valueLong.value)) || n == 0) {
            return ValueLong.get(this.value - valueLong.value);
        }
        return this.add(valueLong.negate());
    }

    private static boolean isInteger(long l) {
        return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
    }

    @Override
    public Value multiply(Value value) {
        BigInteger bigInteger;
        ValueLong valueLong = (ValueLong)value;
        long l = this.value * valueLong.value;
        if (this.value == 0L || this.value == 1L || valueLong.value == 0L || valueLong.value == 1L) {
            return ValueLong.get(l);
        }
        if (ValueLong.isInteger(this.value) && ValueLong.isInteger(valueLong.value)) {
            return ValueLong.get(l);
        }
        BigInteger bigInteger2 = BigInteger.valueOf(this.value);
        BigInteger bigInteger3 = bigInteger2.multiply(bigInteger = BigInteger.valueOf(valueLong.value));
        if (bigInteger3.compareTo(MIN) < 0 || bigInteger3.compareTo(MAX) > 0) {
            throw this.getOverflow();
        }
        return ValueLong.get(bigInteger3.longValue());
    }

    @Override
    public Value divide(Value value) {
        ValueLong valueLong = (ValueLong)value;
        if (valueLong.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value / valueLong.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueLong valueLong = (ValueLong)value;
        if (valueLong.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value % valueLong.value);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueLong valueLong = (ValueLong)value;
        return MathUtils.compareLong(this.value, valueLong.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 19L;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setLong(n, this.value);
    }

    public static ValueLong get(long l) {
        if (l >= 0L && l < 100L) {
            return STATIC_CACHE[(int)l];
        }
        return (ValueLong)Value.cache(new ValueLong(l));
    }

    @Override
    public int getDisplaySize() {
        return 20;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueLong && this.value == ((ValueLong)object).value;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueLong.STATIC_CACHE[i] = new ValueLong(i);
        }
    }
}

