/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.Utils;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AggregateMerging;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAutoRefresh;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeries;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeriesHelper;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePercentileData;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePercentileMergedAggregate;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePercentileValue;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableQuery;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableServiceCall;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TraceCommonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.TransactionCommonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableAggregateQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableSummaryQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.ImmutableOverallSummary;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableProfile;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableQuery;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableServiceCall;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ProfileCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.immutables.value.Value;

@JsonService
class TransactionJsonService {
    private static final double NANOSECONDS_PER_MILLISECOND = 1000000.0;
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final TransactionCommonService transactionCommonService;
    private final TraceCommonService traceCommonService;
    private final AggregateRepository aggregateRepository;
    private final ConfigRepository configRepository;
    private final RollupLevelService rollupLevelService;
    private final Clock clock;

    TransactionJsonService(TransactionCommonService transactionCommonService, TraceCommonService traceCommonService, AggregateRepository aggregateRepository, ConfigRepository configRepository, RollupLevelService rollupLevelService, Clock clock) {
        this.transactionCommonService = transactionCommonService;
        this.traceCommonService = traceCommonService;
        this.aggregateRepository = aggregateRepository;
        this.configRepository = configRepository;
        this.rollupLevelService = rollupLevelService;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/average", permission="agent:transaction:overview")
    String getOverview(@BindAgentRollupId String agentRollupId, @BindRequest TransactionDataRequest request, @BindAutoRefresh boolean autoRefresh) throws Exception {
        LiveAggregateRepository.AggregateQuery query = this.toChartQuery(request, RollupLevelService.DataKind.GENERAL);
        long liveCaptureTime = this.clock.currentTimeMillis();
        ImmutableList overviewAggregates = this.transactionCommonService.getOverviewAggregates(agentRollupId, query, autoRefresh).toCompletableFuture().get();
        if (overviewAggregates.isEmpty() && this.fallBackToLargestAggregates(query) && !(overviewAggregates = this.transactionCommonService.getOverviewAggregates(agentRollupId, query = this.withLargestRollupLevel(query), autoRefresh).toCompletableFuture().get()).isEmpty() && this.ignoreFallBackData(query, ((LiveAggregateRepository.OverviewAggregate)Iterables.getLast(overviewAggregates)).captureTime())) {
            overviewAggregates = ImmutableList.of();
        }
        long dataPointIntervalMillis = this.configRepository.getRollupConfigs().get(query.rollupLevel()).intervalMillis();
        List<DataSeries> dataSeriesList = TransactionJsonService.getDataSeriesForTimerChart(request, overviewAggregates, dataPointIntervalMillis, liveCaptureTime);
        Map<Long, Long> transactionCounts = TransactionJsonService.getTransactionCounts(overviewAggregates);
        ArrayList overviewAggregatesForMerging = Lists.newArrayList();
        for (LiveAggregateRepository.OverviewAggregate overviewAggregate : overviewAggregates) {
            long captureTime = overviewAggregate.captureTime();
            if (captureTime <= request.from() || captureTime > request.to()) continue;
            overviewAggregatesForMerging.add(overviewAggregate);
        }
        AggregateMerging.MergedAggregate mergedAggregate = AggregateMerging.getMergedAggregate(overviewAggregatesForMerging);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("dataSeries", dataSeriesList);
            jg.writeNumberField("dataPointIntervalMillis", dataPointIntervalMillis);
            jg.writeObjectField("transactionCounts", transactionCounts);
            jg.writeObjectField("mergedAggregate", (Object)mergedAggregate);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/percentiles", permission="agent:transaction:overview")
    String getPercentiles(@BindAgentRollupId String agentRollupId, @BindRequest TransactionPercentileRequest request, @BindAutoRefresh boolean autoRefresh) throws Exception {
        LiveAggregateRepository.AggregateQuery query = this.toChartQuery(request, RollupLevelService.DataKind.GENERAL);
        long liveCaptureTime = this.clock.currentTimeMillis();
        ImmutableList percentileAggregates = this.transactionCommonService.getPercentileAggregates(agentRollupId, query, autoRefresh).toCompletableFuture().get();
        if (percentileAggregates.isEmpty() && this.fallBackToLargestAggregates(query) && !(percentileAggregates = this.transactionCommonService.getPercentileAggregates(agentRollupId, query = this.withLargestRollupLevel(query), autoRefresh).toCompletableFuture().get()).isEmpty() && this.ignoreFallBackData(query, ((LiveAggregateRepository.PercentileAggregate)Iterables.getLast(percentileAggregates)).captureTime())) {
            percentileAggregates = ImmutableList.of();
        }
        long dataPointIntervalMillis = this.configRepository.getRollupConfigs().get(query.rollupLevel()).intervalMillis();
        PercentileData percentileData = TransactionJsonService.getDataSeriesForPercentileChart(request, percentileAggregates, request.percentile(), dataPointIntervalMillis, liveCaptureTime);
        Map<Long, Long> transactionCounts = TransactionJsonService.getTransactionCounts2(percentileAggregates);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("dataSeries", percentileData.dataSeriesList());
            jg.writeNumberField("dataPointIntervalMillis", dataPointIntervalMillis);
            jg.writeObjectField("transactionCounts", transactionCounts);
            jg.writeObjectField("mergedAggregate", (Object)percentileData.mergedAggregate());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/throughput", permission="agent:transaction:overview")
    String getThroughput(@BindAgentRollupId String agentRollupId, @BindRequest TransactionDataRequest request, @BindAutoRefresh boolean autoRefresh) throws Exception {
        LiveAggregateRepository.AggregateQuery query = this.toChartQuery(request, RollupLevelService.DataKind.GENERAL);
        long liveCaptureTime = this.clock.currentTimeMillis();
        ImmutableList throughputAggregates = this.transactionCommonService.getThroughputAggregates(agentRollupId, query, autoRefresh).toCompletableFuture().get();
        if (throughputAggregates.isEmpty() && this.fallBackToLargestAggregates(query) && !(throughputAggregates = this.transactionCommonService.getThroughputAggregates(agentRollupId, query = this.withLargestRollupLevel(query), autoRefresh).toCompletableFuture().get()).isEmpty() && this.ignoreFallBackData(query, ((LiveAggregateRepository.ThroughputAggregate)Iterables.getLast(throughputAggregates)).captureTime())) {
            throughputAggregates = ImmutableList.of();
        }
        long dataPointIntervalMillis = this.configRepository.getRollupConfigs().get(query.rollupLevel()).intervalMillis();
        List<DataSeries> dataSeriesList = TransactionJsonService.getDataSeriesForThroughputChart(request, throughputAggregates, dataPointIntervalMillis, liveCaptureTime);
        long transactionCount = 0L;
        for (LiveAggregateRepository.ThroughputAggregate throughputAggregate : throughputAggregates) {
            long captureTime = throughputAggregate.captureTime();
            if (captureTime <= request.from() || captureTime > request.to()) continue;
            transactionCount += throughputAggregate.transactionCount();
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("dataSeries", dataSeriesList);
            jg.writeNumberField("dataPointIntervalMillis", dataPointIntervalMillis);
            jg.writeNumberField("transactionCount", transactionCount);
            jg.writeNumberField("transactionsPerMin", 60000.0 * (double)transactionCount / (double)(request.to() - request.from()));
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/queries", permission="agent:transaction:queries")
    String getQueries(@BindAgentRollupId String agentRollupId, @BindRequest TransactionDataRequest request) throws Exception {
        LiveAggregateRepository.AggregateQuery query = this.toQuery(request, RollupLevelService.DataKind.QUERY);
        QueryCollector queryCollector = this.transactionCommonService.getMergedQueries(agentRollupId, query).toCompletableFuture().join();
        List queries = queryCollector.getSortedAndTruncatedQueries();
        if (queries.isEmpty() && this.fallBackToLargestAggregates(query)) {
            query = this.withLargestRollupLevel(query);
            queryCollector = this.transactionCommonService.getMergedQueries(agentRollupId, query).toCompletableFuture().join();
            queries = queryCollector.getSortedAndTruncatedQueries();
            if (this.ignoreFallBackData(query, queryCollector.getLastCaptureTime())) {
                queries = ImmutableList.of();
            }
        }
        ArrayList queryList = Lists.newArrayList();
        for (MutableQuery loopQuery : queries) {
            queryList.add(ImmutableQuery.builder().queryType(loopQuery.getType()).truncatedQueryText(loopQuery.getTruncatedText()).fullQueryTextSha1(loopQuery.getFullTextSha1()).totalDurationNanos(loopQuery.getTotalDurationNanos()).executionCount(loopQuery.getExecutionCount()).totalRows(loopQuery.hasTotalRows() ? Long.valueOf(loopQuery.getTotalRows()) : null).build());
        }
        if (queryList.isEmpty() && this.aggregateRepository.shouldHaveQueries(agentRollupId, query).toCompletableFuture().get().booleanValue()) {
            return "{\"overwritten\":true}";
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeObject((Object)queryList);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/full-query-text", permission="agent:transaction:queries")
    String getQueryText(@BindAgentRollupId String agentRollupId, @BindRequest FullQueryTextRequest request) throws Exception {
        String fullQueryText = this.transactionCommonService.readFullQueryText(agentRollupId, request.fullTextSha1(), CassandraProfile.web).toCompletableFuture().get();
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            if (fullQueryText == null) {
                jg.writeBooleanField("expired", true);
            } else {
                jg.writeStringField("fullText", fullQueryText);
            }
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/service-calls", permission="agent:transaction:serviceCalls")
    String getServiceCalls(@BindAgentRollupId String agentRollupId, @BindRequest TransactionDataRequest request) throws Exception {
        LiveAggregateRepository.AggregateQuery query = this.toQuery(request, RollupLevelService.DataKind.SERVICE_CALL);
        ServiceCallCollector serviceCallCollector = this.transactionCommonService.getMergedServiceCalls(agentRollupId, query).toCompletableFuture().join();
        List serviceCalls = serviceCallCollector.getSortedAndTruncatedServiceCalls();
        if (serviceCalls.isEmpty() && this.fallBackToLargestAggregates(query)) {
            query = this.withLargestRollupLevel(query);
            serviceCallCollector = this.transactionCommonService.getMergedServiceCalls(agentRollupId, query).toCompletableFuture().join();
            serviceCalls = serviceCallCollector.getSortedAndTruncatedServiceCalls();
            if (this.ignoreFallBackData(query, serviceCallCollector.getLastCaptureTime())) {
                serviceCalls = ImmutableList.of();
            }
        }
        ArrayList serviceCallList = Lists.newArrayList();
        for (MutableServiceCall loopServiceCall : serviceCalls) {
            serviceCallList.add(ImmutableServiceCall.builder().type(loopServiceCall.getType()).text(loopServiceCall.getText()).totalDurationNanos(loopServiceCall.getTotalDurationNanos()).executionCount(loopServiceCall.getExecutionCount()).build());
        }
        Collections.sort(serviceCallList, new Comparator<ServiceCall>(){

            @Override
            public int compare(ServiceCall left, ServiceCall right) {
                return Doubles.compare((double)right.totalDurationNanos(), (double)left.totalDurationNanos());
            }
        });
        if (serviceCallList.isEmpty() && this.aggregateRepository.shouldHaveServiceCalls(agentRollupId, query).toCompletableFuture().get().booleanValue()) {
            return "{\"overwritten\":true}";
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeObject((Object)serviceCallList);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/profile", permission="agent:transaction:threadProfile")
    String getProfile(@BindAgentRollupId String agentRollupId, @BindRequest TransactionProfileRequest request) throws Exception {
        boolean hasUnfilteredAuxThreadProfile;
        boolean hasUnfilteredMainThreadProfile;
        LiveAggregateRepository.AggregateQuery query = this.toQuery(request, RollupLevelService.DataKind.PROFILE);
        ProfileCollector profileCollector = this.transactionCommonService.getMergedProfile(agentRollupId, query, request.auxiliary(), (List<String>)request.include(), (List<String>)request.exclude(), request.truncateBranchPercentage());
        MutableProfile profile = profileCollector.getProfile();
        if (profile.isEmpty() && this.fallBackToLargestAggregates(query)) {
            query = this.withLargestRollupLevel(query);
            profileCollector = this.transactionCommonService.getMergedProfile(agentRollupId, query, request.auxiliary(), (List<String>)request.include(), (List<String>)request.exclude(), request.truncateBranchPercentage());
            profile = profileCollector.getProfile();
            if (this.ignoreFallBackData(query, profileCollector.getLastCaptureTime())) {
                profile = new MutableProfile();
            }
        }
        if (request.auxiliary()) {
            hasUnfilteredMainThreadProfile = this.transactionCommonService.hasMainThreadProfile(agentRollupId, query);
            hasUnfilteredAuxThreadProfile = profile.getUnfilteredSampleCount() > 0L;
        } else if (profile.getUnfilteredSampleCount() == 0L) {
            hasUnfilteredMainThreadProfile = false;
            profileCollector = this.transactionCommonService.getMergedProfile(agentRollupId, query, true, (List<String>)request.include(), (List<String>)request.exclude(), request.truncateBranchPercentage());
            profile = profileCollector.getProfile();
            if (profile.isEmpty() && this.fallBackToLargestAggregates(query)) {
                query = this.withLargestRollupLevel(query);
                profileCollector = this.transactionCommonService.getMergedProfile(agentRollupId, query, request.auxiliary(), (List<String>)request.include(), (List<String>)request.exclude(), request.truncateBranchPercentage());
                profile = profileCollector.getProfile();
                if (this.ignoreFallBackData(query, profileCollector.getLastCaptureTime())) {
                    profile = new MutableProfile();
                }
            }
            hasUnfilteredAuxThreadProfile = profile.getUnfilteredSampleCount() > 0L;
        } else {
            hasUnfilteredMainThreadProfile = true;
            hasUnfilteredAuxThreadProfile = this.transactionCommonService.hasAuxThreadProfile(agentRollupId, query);
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeBooleanField("hasUnfilteredMainThreadProfile", hasUnfilteredMainThreadProfile);
            jg.writeBooleanField("hasUnfilteredAuxThreadProfile", hasUnfilteredAuxThreadProfile);
            if (profile.getUnfilteredSampleCount() == 0L && this.isProfileOverwritten(request, agentRollupId, query)) {
                jg.writeBooleanField("overwritten", true);
            }
            jg.writeFieldName("profile");
            profile.writeJson(jg);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/transaction/summaries", permission="agent:transaction:overview")
    String getSummaries(@BindAgentRollupId String agentRollupId, @BindRequest TransactionSummaryRequest request, @BindAutoRefresh boolean autoRefresh) throws Exception {
        ImmutableSummaryQuery query = ImmutableSummaryQuery.builder().transactionType(request.transactionType()).from(request.from()).to(request.to()).rollupLevel(this.rollupLevelService.getRollupLevelForView(request.from(), request.to(), RollupLevelService.DataKind.GENERAL)).build();
        OverallSummaryCollector overallSummaryCollector = this.transactionCommonService.readOverallSummary(agentRollupId, (LiveAggregateRepository.SummaryQuery)query, autoRefresh).toCompletableFuture().join();
        OverallSummaryCollector.OverallSummary overallSummary = overallSummaryCollector.getOverallSummary();
        if (overallSummary.transactionCount() == 0L && this.fallBackToLargestAggregate((LiveAggregateRepository.SummaryQuery)query)) {
            query = this.withLargestRollupLevel((LiveAggregateRepository.SummaryQuery)query);
            overallSummaryCollector = this.transactionCommonService.readOverallSummary(agentRollupId, (LiveAggregateRepository.SummaryQuery)query, autoRefresh).toCompletableFuture().join();
            overallSummary = overallSummaryCollector.getOverallSummary();
            if (this.ignoreFallBackData((LiveAggregateRepository.SummaryQuery)query, overallSummaryCollector.getLastCaptureTime())) {
                overallSummary = ImmutableOverallSummary.builder().totalDurationNanos(0.0).totalCpuNanos(0.0).totalAllocatedBytes(0.0).transactionCount(0L).build();
            }
        }
        Result<TransactionNameSummaryCollector.TransactionNameSummary> queryResult = this.transactionCommonService.readTransactionNameSummaries(agentRollupId, (LiveAggregateRepository.SummaryQuery)query, request.sortOrder(), request.limit(), autoRefresh, CassandraProfile.web).toCompletableFuture().join();
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("overall", (Object)overallSummary);
            jg.writeObjectField("transactions", (Object)queryResult.records());
            jg.writeBooleanField("moreAvailable", queryResult.moreAvailable());
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @GET(path="/backend/transaction/flame-graph", permission="agent:transaction:threadProfile")
    String getFlameGraph(@BindAgentRollupId String agentRollupId, @BindRequest FlameGraphRequest request) throws Exception {
        LiveAggregateRepository.AggregateQuery query = this.toQuery(request, RollupLevelService.DataKind.PROFILE);
        ProfileCollector profileCollector = this.transactionCommonService.getMergedProfile(agentRollupId, query, request.auxiliary(), (List<String>)request.include(), (List<String>)request.exclude(), request.truncateBranchPercentage());
        MutableProfile profile = profileCollector.getProfile();
        if (profile.isEmpty() && this.fallBackToLargestAggregates(query)) {
            query = this.withLargestRollupLevel(query);
            profileCollector = this.transactionCommonService.getMergedProfile(agentRollupId, query, request.auxiliary(), (List<String>)request.include(), (List<String>)request.exclude(), request.truncateBranchPercentage());
            profile = profileCollector.getProfile();
            if (this.ignoreFallBackData(query, profileCollector.getLastCaptureTime())) {
                profile = new MutableProfile();
            }
        }
        return profile.toFlameGraphJson();
    }

    @GET(path="/backend/transaction/traces/flame-graph", permission="agent:trace")
    String getTraceFlameGraph(@BindAgentId String agentId, @BindRequest TraceFlameGraphRequest request) throws Exception {
        ProfileOuterClass.Profile profile = request.auxiliary() ? this.traceCommonService.getAuxThreadProfile(agentId, request.traceId(), request.checkLiveTraces()) : this.traceCommonService.getMainThreadProfile(agentId, request.traceId(), request.checkLiveTraces());
        MutableProfile mutableProfile = new MutableProfile();
        if (profile != null) {
            mutableProfile.merge(profile);
        }
        mutableProfile.truncateBranches(request.truncateBranchPercentage());
        return mutableProfile.toFlameGraphJson();
    }

    private LiveAggregateRepository.AggregateQuery toChartQuery(RequestBase request, RollupLevelService.DataKind dataKind) throws Exception {
        int rollupLevel = this.rollupLevelService.getRollupLevelForView(request.from(), request.to(), dataKind);
        long rollupIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel).intervalMillis();
        long from = RollupLevelService.getFloorRollupTime(request.from(), rollupIntervalMillis);
        long to = RollupLevelService.getCeilRollupTime(request.to(), rollupIntervalMillis);
        return ImmutableAggregateQuery.builder().transactionType(request.transactionType()).transactionName(request.transactionName()).from(from).to(to).rollupLevel(rollupLevel).build();
    }

    private LiveAggregateRepository.AggregateQuery toQuery(RequestBase request, RollupLevelService.DataKind dataKind) throws Exception {
        return ImmutableAggregateQuery.builder().transactionType(request.transactionType()).transactionName(request.transactionName()).from(request.from()).to(request.to()).rollupLevel(this.rollupLevelService.getRollupLevelForView(request.from(), request.to(), dataKind)).build();
    }

    private boolean fallBackToLargestAggregates(LiveAggregateRepository.AggregateQuery query) {
        return query.rollupLevel() < this.getLargestRollupLevel() && query.from() < this.clock.currentTimeMillis() - this.getLargestRollupIntervalMillis() * 2L;
    }

    private boolean fallBackToLargestAggregate(LiveAggregateRepository.SummaryQuery query) {
        return query.rollupLevel() < this.getLargestRollupLevel() && query.from() < this.clock.currentTimeMillis() - this.getLargestRollupIntervalMillis() * 2L;
    }

    private LiveAggregateRepository.AggregateQuery withLargestRollupLevel(LiveAggregateRepository.AggregateQuery query) {
        return ImmutableAggregateQuery.builder().copyFrom(query).rollupLevel(this.getLargestRollupLevel()).build();
    }

    private LiveAggregateRepository.SummaryQuery withLargestRollupLevel(LiveAggregateRepository.SummaryQuery query) {
        return ImmutableSummaryQuery.builder().copyFrom(query).rollupLevel(this.getLargestRollupLevel()).build();
    }

    private boolean ignoreFallBackData(LiveAggregateRepository.AggregateQuery query, long lastCaptureTime) {
        return lastCaptureTime < query.from() + this.getLargestRollupIntervalMillis();
    }

    private boolean ignoreFallBackData(LiveAggregateRepository.SummaryQuery query, long lastCaptureTime) {
        return lastCaptureTime < query.from() + this.getLargestRollupIntervalMillis();
    }

    private int getLargestRollupLevel() {
        return this.configRepository.getRollupConfigs().size() - 1;
    }

    private long getLargestRollupIntervalMillis() {
        List<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
        return rollupConfigs.get(rollupConfigs.size() - 1).intervalMillis();
    }

    private boolean isProfileOverwritten(TransactionProfileRequest request, String agentRollupId, LiveAggregateRepository.AggregateQuery query) throws Exception {
        if (request.auxiliary() && this.aggregateRepository.shouldHaveAuxThreadProfile(agentRollupId, query).toCompletableFuture().get().booleanValue()) {
            return true;
        }
        return !request.auxiliary() && this.aggregateRepository.shouldHaveMainThreadProfile(agentRollupId, query).toCompletableFuture().get() != false;
    }

    private static PercentileData getDataSeriesForPercentileChart(TransactionPercentileRequest request, List<LiveAggregateRepository.PercentileAggregate> percentileAggregates, List<Double> percentiles, long dataPointIntervalMillis, long liveCaptureTime) {
        if (percentileAggregates.isEmpty()) {
            return ImmutablePercentileData.builder().mergedAggregate(ImmutablePercentileMergedAggregate.builder().transactionCount(0L).totalDurationNanos(0.0).build()).build();
        }
        DataSeriesHelper dataSeriesHelper = new DataSeriesHelper(liveCaptureTime, dataPointIntervalMillis);
        ArrayList dataSeriesList = Lists.newArrayList();
        for (double percentile : percentiles) {
            dataSeriesList.add(new DataSeries(Utils.getPercentileWithSuffix(percentile) + " percentile"));
        }
        long transactionCount = 0L;
        double totalDurationNanos = 0.0;
        LazyHistogram mergedHistogram = new LazyHistogram();
        LiveAggregateRepository.PercentileAggregate priorPercentileAggregate = null;
        for (LiveAggregateRepository.PercentileAggregate percentileAggregate : percentileAggregates) {
            long captureTime = percentileAggregate.captureTime();
            if (priorPercentileAggregate == null) {
                dataSeriesHelper.addInitialUpslopeIfNeeded(request.from(), captureTime, dataSeriesList, null);
            } else {
                dataSeriesHelper.addGapIfNeeded(priorPercentileAggregate.captureTime(), captureTime, dataSeriesList, null);
            }
            LazyHistogram durationNanosHistogram = new LazyHistogram(percentileAggregate.durationNanosHistogram());
            for (int i = 0; i < percentiles.size(); ++i) {
                DataSeries dataSeries = (DataSeries)dataSeriesList.get(i);
                double percentile = percentiles.get(i);
                dataSeries.add(captureTime, (double)durationNanosHistogram.getValueAtPercentile(percentile) / 1000000.0);
            }
            if (captureTime > request.from() && captureTime <= request.to()) {
                transactionCount += percentileAggregate.transactionCount();
                totalDurationNanos += percentileAggregate.totalDurationNanos();
                mergedHistogram.merge(durationNanosHistogram);
            }
            priorPercentileAggregate = percentileAggregate;
        }
        if (priorPercentileAggregate != null) {
            dataSeriesHelper.addFinalDownslopeIfNeeded(dataSeriesList, null, priorPercentileAggregate.captureTime());
        }
        ArrayList percentileValues = Lists.newArrayList();
        for (double percentile : percentiles) {
            percentileValues.add(ImmutablePercentileValue.of(Utils.getPercentileWithSuffix(percentile) + " percentile", mergedHistogram.getValueAtPercentile(percentile)));
        }
        return ImmutablePercentileData.builder().dataSeriesList(dataSeriesList).mergedAggregate(ImmutablePercentileMergedAggregate.builder().transactionCount(transactionCount).totalDurationNanos(totalDurationNanos).addAllPercentileValues(percentileValues).build()).build();
    }

    private static List<DataSeries> getDataSeriesForThroughputChart(TransactionDataRequest request, List<LiveAggregateRepository.ThroughputAggregate> throughputAggregates, long dataPointIntervalMillis, long liveCaptureTime) {
        if (throughputAggregates.isEmpty()) {
            return Lists.newArrayList();
        }
        DataSeriesHelper dataSeriesHelper = new DataSeriesHelper(liveCaptureTime, dataPointIntervalMillis);
        DataSeries dataSeries = new DataSeries("throughput");
        ArrayList dataSeriesList = Lists.newArrayList((Object[])new DataSeries[]{dataSeries});
        LiveAggregateRepository.ThroughputAggregate priorThroughputAggregate = null;
        for (LiveAggregateRepository.ThroughputAggregate throughputAggregate : throughputAggregates) {
            if (priorThroughputAggregate == null) {
                dataSeriesHelper.addInitialUpslopeIfNeeded(request.from(), throughputAggregate.captureTime(), dataSeriesList, null);
            } else {
                dataSeriesHelper.addGapIfNeeded(priorThroughputAggregate.captureTime(), throughputAggregate.captureTime(), dataSeriesList, null);
            }
            long from = throughputAggregate.captureTime() - dataPointIntervalMillis;
            from = CaptureTimes.getRollup((long)from, (long)dataPointIntervalMillis);
            double transactionsPerMin = 60000.0 * (double)throughputAggregate.transactionCount() / (double)(throughputAggregate.captureTime() - from);
            dataSeries.add(throughputAggregate.captureTime(), transactionsPerMin);
            priorThroughputAggregate = throughputAggregate;
        }
        if (priorThroughputAggregate != null) {
            dataSeriesHelper.addFinalDownslopeIfNeeded(dataSeriesList, null, priorThroughputAggregate.captureTime());
        }
        return dataSeriesList;
    }

    private static List<DataSeries> getDataSeriesForTimerChart(TransactionDataRequest request, List<LiveAggregateRepository.OverviewAggregate> aggregates, long dataPointIntervalMillis, long liveCaptureTime) {
        if (aggregates.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList stackedPoints = Lists.newArrayList();
        for (LiveAggregateRepository.OverviewAggregate aggregate : aggregates) {
            stackedPoints.add(StackedPoint.create(aggregate));
        }
        return TransactionJsonService.getTimerDataSeries(request, stackedPoints, dataPointIntervalMillis, liveCaptureTime);
    }

    private static List<DataSeries> getTimerDataSeries(TransactionDataRequest request, List<StackedPoint> stackedPoints, long dataPointIntervalMillis, long liveCaptureTime) {
        DataSeriesHelper dataSeriesHelper = new DataSeriesHelper(liveCaptureTime, dataPointIntervalMillis);
        int topX = 5;
        List<String> timerNames = TransactionJsonService.getTopTimerNames(stackedPoints, 6);
        ArrayList dataSeriesList = Lists.newArrayList();
        for (int i = 0; i < Math.min(timerNames.size(), 5); ++i) {
            dataSeriesList.add(new DataSeries(timerNames.get(i)));
        }
        DataSeries otherDataSeries = new DataSeries(null);
        LiveAggregateRepository.OverviewAggregate priorOverviewAggregate = null;
        for (StackedPoint stackedPoint : stackedPoints) {
            LiveAggregateRepository.OverviewAggregate overviewAggregate = stackedPoint.getOverviewAggregate();
            if (priorOverviewAggregate == null) {
                dataSeriesHelper.addInitialUpslopeIfNeeded(request.from(), overviewAggregate.captureTime(), dataSeriesList, otherDataSeries);
            } else {
                dataSeriesHelper.addGapIfNeeded(priorOverviewAggregate.captureTime(), overviewAggregate.captureTime(), dataSeriesList, otherDataSeries);
            }
            MutableDoubleMap stackedTimers = stackedPoint.getStackedTimers();
            double totalOtherNanos = overviewAggregate.totalDurationNanos();
            for (DataSeries dataSeries : dataSeriesList) {
                MutableDouble totalNanos = (MutableDouble)stackedTimers.get(dataSeries.getName());
                if (totalNanos == null) {
                    dataSeries.add(overviewAggregate.captureTime(), 0.0);
                    continue;
                }
                double value = totalNanos.doubleValue() / (double)overviewAggregate.transactionCount() / 1000000.0;
                dataSeries.add(overviewAggregate.captureTime(), value);
                totalOtherNanos -= totalNanos.doubleValue();
            }
            if (overviewAggregate.transactionCount() == 0L) {
                otherDataSeries.add(overviewAggregate.captureTime(), 0.0);
            } else {
                otherDataSeries.add(overviewAggregate.captureTime(), totalOtherNanos / (double)overviewAggregate.transactionCount() / 1000000.0);
            }
            priorOverviewAggregate = overviewAggregate;
        }
        if (priorOverviewAggregate != null) {
            dataSeriesHelper.addFinalDownslopeIfNeeded(dataSeriesList, otherDataSeries, priorOverviewAggregate.captureTime());
        }
        dataSeriesList.add(otherDataSeries);
        return dataSeriesList;
    }

    private static Map<Long, Long> getTransactionCounts(List<LiveAggregateRepository.OverviewAggregate> overviewAggregates) {
        HashMap transactionCounts = Maps.newHashMap();
        for (LiveAggregateRepository.OverviewAggregate overviewAggregate : overviewAggregates) {
            transactionCounts.put(overviewAggregate.captureTime(), overviewAggregate.transactionCount());
        }
        return transactionCounts;
    }

    private static Map<Long, Long> getTransactionCounts2(List<LiveAggregateRepository.PercentileAggregate> percentileAggregates) {
        HashMap transactionCounts = Maps.newHashMap();
        for (LiveAggregateRepository.PercentileAggregate percentileAggregate : percentileAggregates) {
            transactionCounts.put(percentileAggregate.captureTime(), percentileAggregate.transactionCount());
        }
        return transactionCounts;
    }

    private static List<String> getTopTimerNames(List<StackedPoint> stackedPoints, int topX) {
        MutableDoubleMap timerTotals = new MutableDoubleMap();
        for (StackedPoint stackedPoint : stackedPoints) {
            for (Map.Entry entry : stackedPoint.getStackedTimers().entrySet()) {
                timerTotals.add((String)entry.getKey(), ((MutableDouble)entry.getValue()).doubleValue());
            }
        }
        Ordering valueOrdering = Ordering.natural().onResultOf((Function)new Function<Map.Entry<String, MutableDouble>, Double>(){

            public Double apply(Map.Entry<String, MutableDouble> entry) {
                Preconditions.checkNotNull(entry);
                return entry.getValue().doubleValue();
            }
        });
        ArrayList timerNames = Lists.newArrayList();
        List topTimerTotals = valueOrdering.greatestOf(timerTotals.entrySet(), topX);
        for (Map.Entry entry : topTimerTotals) {
            timerNames.add((String)entry.getKey());
        }
        return timerNames;
    }

    @Value.Immutable
    static interface PercentileMergedAggregate {
        public long transactionCount();

        public double totalDurationNanos();

        public ImmutableList<AggregateMerging.PercentileValue> percentileValues();
    }

    @Value.Immutable
    static interface PercentileData {
        public ImmutableList<DataSeries> dataSeriesList();

        public PercentileMergedAggregate mergedAggregate();
    }

    @Value.Immutable
    static interface ServiceCall {
        public String type();

        public String text();

        public double totalDurationNanos();

        public long executionCount();
    }

    @Value.Immutable
    static interface Query {
        public String queryType();

        public String truncatedQueryText();

        public @Nullable String fullQueryTextSha1();

        public double totalDurationNanos();

        public long executionCount();

        public @Nullable Long totalRows();
    }

    @Value.Immutable
    static abstract class TraceFlameGraphRequest {
        TraceFlameGraphRequest() {
        }

        abstract String traceId();

        abstract boolean auxiliary();

        abstract ImmutableList<String> include();

        abstract ImmutableList<String> exclude();

        abstract double truncateBranchPercentage();

        @Value.Default
        boolean checkLiveTraces() {
            return false;
        }
    }

    @Value.Immutable
    static interface FlameGraphRequest
    extends RequestBase {
        public boolean auxiliary();

        public ImmutableList<String> include();

        public ImmutableList<String> exclude();

        public double truncateBranchPercentage();
    }

    @Value.Immutable
    static interface TransactionProfileRequest
    extends RequestBase {
        public boolean auxiliary();

        public ImmutableList<String> include();

        public ImmutableList<String> exclude();

        public double truncateBranchPercentage();
    }

    @Value.Immutable
    static interface FullQueryTextRequest {
        public String fullTextSha1();
    }

    @Value.Immutable
    static interface TransactionPercentileRequest
    extends RequestBase {
        public ImmutableList<Double> percentile();
    }

    @Value.Immutable
    static interface TransactionDataRequest
    extends RequestBase {
    }

    static interface RequestBase {
        public String transactionType();

        public @Nullable String transactionName();

        public long from();

        public long to();
    }

    @Value.Immutable
    static interface TransactionSummaryRequest {
        public String transactionType();

        public long from();

        public long to();

        public TransactionNameSummaryCollector.SummarySortOrder sortOrder();

        public int limit();
    }

    private static class MutableDouble {
        private double value;

        private MutableDouble(double value) {
            this.value = value;
        }

        private double doubleValue() {
            return this.value;
        }
    }

    private static class MutableDoubleMap<K>
    extends HashMap<K, MutableDouble> {
        private MutableDoubleMap() {
        }

        private void add(K key, double delta) {
            MutableDouble existing = (MutableDouble)this.get(key);
            if (existing == null) {
                this.put(key, new MutableDouble(delta));
            } else {
                existing.value += delta;
            }
        }
    }

    private static class StackedPoint {
        private final LiveAggregateRepository.OverviewAggregate overviewAggregate;
        private final MutableDoubleMap<String> stackedTimers;

        private static StackedPoint create(LiveAggregateRepository.OverviewAggregate overviewAggregate) {
            MutableDoubleMap<String> stackedTimers = new MutableDoubleMap<String>();
            for (AggregateOuterClass.Aggregate.Timer rootTimer : overviewAggregate.mainThreadRootTimers()) {
                for (AggregateOuterClass.Aggregate.Timer topLevelTimer : rootTimer.getChildTimerList()) {
                    StackedPoint.addToStackedTimer(topLevelTimer, stackedTimers);
                }
            }
            return new StackedPoint(overviewAggregate, stackedTimers);
        }

        private StackedPoint(LiveAggregateRepository.OverviewAggregate overviewAggregate, MutableDoubleMap<String> stackedTimers) {
            this.overviewAggregate = overviewAggregate;
            this.stackedTimers = stackedTimers;
        }

        private LiveAggregateRepository.OverviewAggregate getOverviewAggregate() {
            return this.overviewAggregate;
        }

        private MutableDoubleMap<String> getStackedTimers() {
            return this.stackedTimers;
        }

        private static void addToStackedTimer(AggregateOuterClass.Aggregate.Timer timer, MutableDoubleMap<String> stackedTimers) {
            double totalNestedNanos = 0.0;
            for (AggregateOuterClass.Aggregate.Timer childTimer : timer.getChildTimerList()) {
                totalNestedNanos += childTimer.getTotalNanos();
                StackedPoint.addToStackedTimer(childTimer, stackedTimers);
            }
            String timerName = timer.getName();
            ((MutableDoubleMap)stackedTimers).add(timerName, timer.getTotalNanos() - totalNestedNanos);
        }
    }
}

