/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.InstrumentationConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstrumentationConfigJsonService.MethodSignaturesRequest", generator="Immutables")
@Immutable
final class ImmutableMethodSignaturesRequest
implements InstrumentationConfigJsonService.MethodSignaturesRequest {
    private final String className;
    private final String methodName;

    private ImmutableMethodSignaturesRequest(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    @JsonProperty(value="className")
    public String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="methodName")
    public String methodName() {
        return this.methodName;
    }

    public final ImmutableMethodSignaturesRequest withClassName(String value) {
        String newValue = Objects.requireNonNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return new ImmutableMethodSignaturesRequest(newValue, this.methodName);
    }

    public final ImmutableMethodSignaturesRequest withMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "methodName");
        if (this.methodName.equals(newValue)) {
            return this;
        }
        return new ImmutableMethodSignaturesRequest(this.className, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMethodSignaturesRequest && this.equalTo(0, (ImmutableMethodSignaturesRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableMethodSignaturesRequest another) {
        return this.className.equals(another.className) && this.methodName.equals(another.methodName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + this.methodName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MethodSignaturesRequest").omitNullValues().add("className", (Object)this.className).add("methodName", (Object)this.methodName).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMethodSignaturesRequest fromJson(Json json) {
        Builder builder = ImmutableMethodSignaturesRequest.builder();
        if (json.className != null) {
            builder.className(json.className);
        }
        if (json.methodName != null) {
            builder.methodName(json.methodName);
        }
        return builder.build();
    }

    public static ImmutableMethodSignaturesRequest copyOf(InstrumentationConfigJsonService.MethodSignaturesRequest instance) {
        if (instance instanceof ImmutableMethodSignaturesRequest) {
            return (ImmutableMethodSignaturesRequest)instance;
        }
        return ImmutableMethodSignaturesRequest.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationConfigJsonService.MethodSignaturesRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLASS_NAME = 1L;
        private static final long INIT_BIT_METHOD_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String className;
        @Nullable
        private String methodName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(InstrumentationConfigJsonService.MethodSignaturesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.className(instance.className());
            this.methodName(instance.methodName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder className(String className) {
            this.className = Objects.requireNonNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methodName(String methodName) {
            this.methodName = Objects.requireNonNull(methodName, "methodName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMethodSignaturesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMethodSignaturesRequest(this.className, this.methodName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("className");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("methodName");
            }
            return "Cannot build MethodSignaturesRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InstrumentationConfigJsonService.MethodSignaturesRequest", generator="Immutables")
    static final class Json
    implements InstrumentationConfigJsonService.MethodSignaturesRequest {
        @Nullable
        String className;
        @Nullable
        String methodName;

        Json() {
        }

        @JsonProperty(value="className")
        public void setClassName(String className) {
            this.className = className;
        }

        @JsonProperty(value="methodName")
        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public String className() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String methodName() {
            throw new UnsupportedOperationException();
        }
    }
}

