/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigJsonService.JvmConfigDto", generator="Immutables")
@Immutable
final class ImmutableJvmConfigDto
extends ConfigJsonService.JvmConfigDto {
    private final ImmutableList<String> maskSystemProperties;
    private final ImmutableList<String> maskMBeanAttributes;
    private final String version;

    private ImmutableJvmConfigDto(ImmutableList<String> maskSystemProperties, ImmutableList<String> maskMBeanAttributes, String version) {
        this.maskSystemProperties = maskSystemProperties;
        this.maskMBeanAttributes = maskMBeanAttributes;
        this.version = version;
    }

    @Override
    @JsonProperty(value="maskSystemProperties")
    ImmutableList<String> maskSystemProperties() {
        return this.maskSystemProperties;
    }

    @Override
    @JsonProperty(value="maskMBeanAttributes")
    ImmutableList<String> maskMBeanAttributes() {
        return this.maskMBeanAttributes;
    }

    @Override
    @JsonProperty(value="version")
    String version() {
        return this.version;
    }

    public final ImmutableJvmConfigDto withMaskSystemProperties(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableJvmConfigDto((ImmutableList<String>)newValue, this.maskMBeanAttributes, this.version);
    }

    public final ImmutableJvmConfigDto withMaskSystemProperties(Iterable<String> elements) {
        if (this.maskSystemProperties == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableJvmConfigDto((ImmutableList<String>)newValue, this.maskMBeanAttributes, this.version);
    }

    public final ImmutableJvmConfigDto withMaskMBeanAttributes(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableJvmConfigDto(this.maskSystemProperties, (ImmutableList<String>)newValue, this.version);
    }

    public final ImmutableJvmConfigDto withMaskMBeanAttributes(Iterable<String> elements) {
        if (this.maskMBeanAttributes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableJvmConfigDto(this.maskSystemProperties, (ImmutableList<String>)newValue, this.version);
    }

    public final ImmutableJvmConfigDto withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableJvmConfigDto(this.maskSystemProperties, this.maskMBeanAttributes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJvmConfigDto && this.equalTo(0, (ImmutableJvmConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableJvmConfigDto another) {
        return this.maskSystemProperties.equals(another.maskSystemProperties) && this.maskMBeanAttributes.equals(another.maskMBeanAttributes) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.maskSystemProperties.hashCode();
        h += (h << 5) + this.maskMBeanAttributes.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JvmConfigDto").omitNullValues().add("maskSystemProperties", this.maskSystemProperties).add("maskMBeanAttributes", this.maskMBeanAttributes).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJvmConfigDto fromJson(Json json) {
        Builder builder = ImmutableJvmConfigDto.builder();
        if (json.maskSystemProperties != null) {
            builder.addAllMaskSystemProperties((Iterable<String>)json.maskSystemProperties);
        }
        if (json.maskMBeanAttributes != null) {
            builder.addAllMaskMBeanAttributes((Iterable<String>)json.maskMBeanAttributes);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableJvmConfigDto copyOf(ConfigJsonService.JvmConfigDto instance) {
        if (instance instanceof ImmutableJvmConfigDto) {
            return (ImmutableJvmConfigDto)instance;
        }
        return ImmutableJvmConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigJsonService.JvmConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<String> maskSystemProperties = ImmutableList.builder();
        private ImmutableList.Builder<String> maskMBeanAttributes = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigJsonService.JvmConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMaskSystemProperties((Iterable<String>)instance.maskSystemProperties());
            this.addAllMaskMBeanAttributes((Iterable<String>)instance.maskMBeanAttributes());
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMaskSystemProperties(String element) {
            this.maskSystemProperties.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMaskSystemProperties(String ... elements) {
            this.maskSystemProperties.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maskSystemProperties(Iterable<String> elements) {
            this.maskSystemProperties = ImmutableList.builder();
            return this.addAllMaskSystemProperties(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMaskSystemProperties(Iterable<String> elements) {
            this.maskSystemProperties.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMaskMBeanAttributes(String element) {
            this.maskMBeanAttributes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMaskMBeanAttributes(String ... elements) {
            this.maskMBeanAttributes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maskMBeanAttributes(Iterable<String> elements) {
            this.maskMBeanAttributes = ImmutableList.builder();
            return this.addAllMaskMBeanAttributes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMaskMBeanAttributes(Iterable<String> elements) {
            this.maskMBeanAttributes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableJvmConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJvmConfigDto(this.maskSystemProperties.build(), this.maskMBeanAttributes.build(), this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build JvmConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigJsonService.JvmConfigDto", generator="Immutables")
    static final class Json
    extends ConfigJsonService.JvmConfigDto {
        @Nullable
        ImmutableList<String> maskSystemProperties = ImmutableList.of();
        @Nullable
        ImmutableList<String> maskMBeanAttributes = ImmutableList.of();
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="maskSystemProperties")
        public void setMaskSystemProperties(ImmutableList<String> maskSystemProperties) {
            this.maskSystemProperties = maskSystemProperties;
        }

        @JsonProperty(value="maskMBeanAttributes")
        public void setMaskMBeanAttributes(ImmutableList<String> maskMBeanAttributes) {
            this.maskMBeanAttributes = maskMBeanAttributes;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        ImmutableList<String> maskSystemProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> maskMBeanAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        String version() {
            throw new UnsupportedOperationException();
        }
    }
}

