/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ImmutableGauge;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAgentRollupId;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeries;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Function;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.immutables.value.Value;

@JsonService
class GaugeValueJsonService {
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private final GaugeValueRepository gaugeValueRepository;
    private final RollupLevelService rollupLevelService;
    private final ConfigRepository configRepository;

    GaugeValueJsonService(GaugeValueRepository gaugeValueRepository, RollupLevelService rollupLevelService, ConfigRepository configRepository) {
        this.gaugeValueRepository = gaugeValueRepository;
        this.rollupLevelService = rollupLevelService;
        this.configRepository = configRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET(path="/backend/jvm/gauges", permission="agent:jvm:gauges")
    String getGaugeValues(@BindAgentRollupId String agentRollupId, @BindRequest GaugeValueRequest request) throws Exception {
        int rollupLevel;
        long dataPointIntervalMillis = (rollupLevel = this.rollupLevelService.getGaugeRollupLevelForView(request.from(), request.to(), agentRollupId.endsWith("::"))) == 0 ? this.configRepository.getGaugeCollectionIntervalMillis() : this.configRepository.getRollupConfigs().get(rollupLevel - 1).intervalMillis();
        Map<String, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> origGaugeValues = this.getGaugeValues(agentRollupId, request, rollupLevel, dataPointIntervalMillis, CassandraProfile.web);
        Map<String, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> gaugeValues = origGaugeValues;
        if (GaugeValueJsonService.isEmpty(gaugeValues) && this.noHarmFallingBackToLargestAggregate(agentRollupId, rollupLevel, request)) {
            rollupLevel = this.getLargestRollupLevel();
            dataPointIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel - 1).intervalMillis();
            gaugeValues = this.getGaugeValues(agentRollupId, request, rollupLevel, dataPointIntervalMillis, CassandraProfile.web);
            long lastCaptureTime = 0L;
            for (List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> list : gaugeValues.values()) {
                if (list.isEmpty()) continue;
                lastCaptureTime = Math.max(lastCaptureTime, ((CollectorServiceOuterClass.GaugeValueMessage.GaugeValue)Iterables.getLast((Iterable)list)).getCaptureTime());
            }
            if (lastCaptureTime != 0L && this.ignoreFallBackData(request, lastCaptureTime)) {
                gaugeValues = origGaugeValues;
            }
        }
        if (rollupLevel != 0) {
            this.syncManualRollupCaptureTimes(gaugeValues, rollupLevel);
        }
        double gapMillis = (double)dataPointIntervalMillis * 1.5;
        ArrayList dataSeriesList = Lists.newArrayList();
        for (Map.Entry<String, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> entry : gaugeValues.entrySet()) {
            dataSeriesList.add(GaugeValueJsonService.convertToDataSeriesWithGaps(entry.getKey(), entry.getValue(), gapMillis));
        }
        List<GaugeValueRepository.Gauge> gauges = this.gaugeValueRepository.getGauges(agentRollupId, request.from(), request.to(), CassandraProfile.web).toCompletableFuture().get();
        Object sortedGauges = new GaugeOrdering().immutableSortedCopy(gauges);
        sortedGauges = GaugeValueJsonService.addCounterSuffixesIfAndWhereNeeded((List<GaugeValueRepository.Gauge>)sortedGauges);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("dataSeries", (Object)dataSeriesList);
            jg.writeNumberField("dataPointIntervalMillis", dataPointIntervalMillis);
            jg.writeObjectField("allGauges", sortedGauges);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    private Map<String, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> getGaugeValues(String agentRollupId, GaugeValueRequest request, int rollupLevel, long dataPointIntervalMillis, CassandraProfile profile) throws Exception {
        long revisedFrom = request.from() - dataPointIntervalMillis;
        long revisedTo = request.to() + dataPointIntervalMillis;
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (String gaugeName : request.gaugeName()) {
            List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues = this.getGaugeValues(agentRollupId, revisedFrom, revisedTo, gaugeName, rollupLevel, profile);
            map.put(gaugeName, gaugeValues);
        }
        return map;
    }

    private List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> getGaugeValues(String agentRollupId, long from, long to, String gaugeName, int rollupLevel, CassandraProfile profile) throws Exception {
        ArrayList gaugeValues = this.gaugeValueRepository.readGaugeValues(agentRollupId, gaugeName, from, to, rollupLevel, profile).toCompletableFuture().get();
        if (rollupLevel == 0) {
            return gaugeValues;
        }
        long nonRolledUpFrom = from;
        if (!gaugeValues.isEmpty()) {
            nonRolledUpFrom = ((CollectorServiceOuterClass.GaugeValueMessage.GaugeValue)Iterables.getLast(gaugeValues)).getCaptureTime() + 1L;
        }
        ArrayList orderedNonRolledUpGaugeValues = Lists.newArrayList();
        int lowestLevel = agentRollupId.endsWith("::") ? 1 : 0;
        orderedNonRolledUpGaugeValues.addAll((Collection)this.gaugeValueRepository.readGaugeValues(agentRollupId, gaugeName, nonRolledUpFrom, to, lowestLevel, profile).toCompletableFuture().get());
        gaugeValues = Lists.newArrayList(gaugeValues);
        long fixedIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel - 1).intervalMillis();
        gaugeValues.addAll(GaugeValueJsonService.rollUpGaugeValues(orderedNonRolledUpGaugeValues, gaugeName, new RollupCaptureTimeFn(fixedIntervalMillis)));
        return gaugeValues;
    }

    private <K> void syncManualRollupCaptureTimes(Map<K, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> map, int rollupLevel) {
        long fixedIntervalMillis = this.configRepository.getRollupConfigs().get(rollupLevel - 1).intervalMillis();
        HashMap manualRollupCaptureTimes = Maps.newHashMap();
        long maxCaptureTime = Long.MIN_VALUE;
        for (Map.Entry<K, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> entry : map.entrySet()) {
            List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues = entry.getValue();
            if (gaugeValues.isEmpty()) continue;
            long lastCaptureTime = ((CollectorServiceOuterClass.GaugeValueMessage.GaugeValue)Iterables.getLast(gaugeValues)).getCaptureTime();
            maxCaptureTime = Math.max(maxCaptureTime, lastCaptureTime);
            if (lastCaptureTime % fixedIntervalMillis == 0L) continue;
            manualRollupCaptureTimes.put(entry.getKey(), lastCaptureTime);
        }
        if (maxCaptureTime == Long.MIN_VALUE) {
            return;
        }
        long maxRollupCaptureTime = CaptureTimes.getRollup((long)maxCaptureTime, (long)fixedIntervalMillis);
        long maxDiffToSync = Math.min(fixedIntervalMillis / 5L, 60000L);
        for (Map.Entry entry : manualRollupCaptureTimes.entrySet()) {
            Long captureTime = (Long)entry.getValue();
            if (CaptureTimes.getRollup((long)captureTime, (long)fixedIntervalMillis) != maxRollupCaptureTime || maxCaptureTime - captureTime > maxDiffToSync) continue;
            Object key = entry.getKey();
            List gaugeValues = (List)Preconditions.checkNotNull(map.get(key));
            gaugeValues = Lists.newArrayList((Iterable)gaugeValues);
            CollectorServiceOuterClass.GaugeValueMessage.GaugeValue lastGaugeValue = (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue)Iterables.getLast((Iterable)gaugeValues);
            gaugeValues.set(gaugeValues.size() - 1, lastGaugeValue.toBuilder().setCaptureTime(maxCaptureTime).build());
            map.put(key, gaugeValues);
        }
    }

    private boolean noHarmFallingBackToLargestAggregate(String agentRollupId, int rollupLevel, GaugeValueRequest request) throws Exception {
        if (rollupLevel == this.getLargestRollupLevel()) {
            return false;
        }
        for (String gaugeName : request.gaugeName()) {
            long oldestCaptureTime = this.gaugeValueRepository.getOldestCaptureTime(agentRollupId, gaugeName, rollupLevel, CassandraProfile.web).toCompletableFuture().get();
            if (oldestCaptureTime >= request.to()) continue;
            return false;
        }
        return true;
    }

    private boolean ignoreFallBackData(GaugeValueRequest request, long lastCaptureTime) {
        return lastCaptureTime < request.from() + this.getLargestRollupIntervalMillis();
    }

    private int getLargestRollupLevel() {
        return this.configRepository.getRollupConfigs().size();
    }

    private long getLargestRollupIntervalMillis() {
        List<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
        return rollupConfigs.get(rollupConfigs.size() - 1).intervalMillis();
    }

    static List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> rollUpGaugeValues(List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> orderedNonRolledUpGaugeValues, String gaugeName, Function<Long, Long> rollupCaptureTimeFn) {
        ArrayList rolledUpGaugeValues = Lists.newArrayList();
        double currTotal = 0.0;
        long currWeight = 0L;
        long currRollupCaptureTime = Long.MIN_VALUE;
        for (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue nonRolledUpGaugeValue : orderedNonRolledUpGaugeValues) {
            long captureTime = nonRolledUpGaugeValue.getCaptureTime();
            long rollupCaptureTime = (Long)rollupCaptureTimeFn.apply((Object)captureTime);
            if (rollupCaptureTime != currRollupCaptureTime && currWeight > 0L) {
                rolledUpGaugeValues.add(CollectorServiceOuterClass.GaugeValueMessage.GaugeValue.newBuilder().setGaugeName(gaugeName).setCaptureTime(currRollupCaptureTime).setValue(currTotal / (double)currWeight).setWeight(currWeight).build());
                currTotal = 0.0;
                currWeight = 0L;
            }
            currRollupCaptureTime = rollupCaptureTime;
            currTotal += nonRolledUpGaugeValue.getValue() * (double)nonRolledUpGaugeValue.getWeight();
            currWeight += nonRolledUpGaugeValue.getWeight();
        }
        if (currWeight > 0L) {
            long lastCaptureTime = ((CollectorServiceOuterClass.GaugeValueMessage.GaugeValue)Iterables.getLast(orderedNonRolledUpGaugeValues)).getCaptureTime();
            rolledUpGaugeValues.add(CollectorServiceOuterClass.GaugeValueMessage.GaugeValue.newBuilder().setGaugeName(gaugeName).setCaptureTime(lastCaptureTime).setValue(currTotal / (double)currWeight).setWeight(currWeight).build());
        }
        return rolledUpGaugeValues;
    }

    private static boolean isEmpty(Map<String, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> map) {
        for (List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> values : map.values()) {
            if (values.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static DataSeries convertToDataSeriesWithGaps(String dataSeriesName, List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues, double gapMillis) {
        DataSeries dataSeries = new DataSeries(dataSeriesName);
        CollectorServiceOuterClass.GaugeValueMessage.GaugeValue lastGaugeValue = null;
        for (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue gaugeValue : gaugeValues) {
            if (lastGaugeValue != null && (double)(gaugeValue.getCaptureTime() - lastGaugeValue.getCaptureTime()) > gapMillis) {
                dataSeries.addNull();
            }
            dataSeries.add(gaugeValue.getCaptureTime(), gaugeValue.getValue());
            lastGaugeValue = gaugeValue;
        }
        return dataSeries;
    }

    private static List<GaugeValueRepository.Gauge> addCounterSuffixesIfAndWhereNeeded(List<GaugeValueRepository.Gauge> gauges) {
        HashSet nonCounterGaugeNames = Sets.newHashSet();
        for (GaugeValueRepository.Gauge gauge : gauges) {
            if (gauge.counter()) continue;
            nonCounterGaugeNames.add(gauge.name());
        }
        ArrayList updatedGauges = Lists.newArrayList();
        for (GaugeValueRepository.Gauge gauge : gauges) {
            if (gauge.counter() && nonCounterGaugeNames.contains(gauge.name().substring(0, gauge.name().length() - "[counter]".length()))) {
                ArrayList displayParts = Lists.newArrayList(gauge.displayParts());
                displayParts.set(displayParts.size() - 1, (String)displayParts.get(displayParts.size() - 1) + " (Counter)");
                updatedGauges.add(ImmutableGauge.builder().copyFrom(gauge).display(gauge.display() + " (Counter)").displayParts(displayParts).build());
                continue;
            }
            updatedGauges.add(gauge);
        }
        return updatedGauges;
    }

    private static class RollupCaptureTimeFn
    implements Function<Long, Long> {
        private final long fixedIntervalMillis;

        private RollupCaptureTimeFn(long fixedIntervalMillis) {
            this.fixedIntervalMillis = fixedIntervalMillis;
        }

        public Long apply(Long captureTime) {
            return CaptureTimes.getRollup((long)captureTime, (long)this.fixedIntervalMillis);
        }
    }

    static class GaugeOrdering
    extends Ordering<GaugeValueRepository.Gauge> {
        GaugeOrdering() {
        }

        public int compare(GaugeValueRepository.Gauge left, GaugeValueRepository.Gauge right) {
            return left.display().compareToIgnoreCase(right.display());
        }
    }

    @Value.Immutable
    static interface AllGaugeResponse {
        public List<GaugeValueRepository.Gauge> allGauges();

        public List<String> defaultGaugeNames();
    }

    @Value.Immutable
    static interface GaugeValueRequest {
        public long from();

        public long to();

        public ImmutableList<String> gaugeName();
    }
}

