/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.AllCentralAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.AllEmbeddedAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.CentralAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.CentralStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.CentralWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.EmbeddedWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HealthchecksIoConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.HttpProxyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableAllCentralAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableAllEmbeddedAdminConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableCentralAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableCentralStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableCentralWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableEmbeddedAdminGeneralConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableEmbeddedStorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableEmbeddedWebConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableHealthchecksIoConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableHttpProxyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableLdapConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutablePagerDutyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutablePagerDutyIntegrationKey;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableSlackConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableSlackWebhook;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableSmtpConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableUserConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.LdapConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.PagerDutyConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SlackConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.SmtpConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.UserConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AllAdminConfigUtil;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.PasswordHash;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.RepoAdmin;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.AlertingService;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Encryption;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.HttpClient;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.IdGenerator;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.MailService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindAuthentication;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpServer;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableCentralAdminGeneralConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableCentralStorageConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableCentralWebConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableCentralWebConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableEmbeddedAdminGeneralConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableEmbeddedAdminGeneralConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableEmbeddedStorageConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableEmbeddedWebConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableEmbeddedWebConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableHealthchecksIoConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableHttpProxyConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableLdapConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableLdapConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutablePagerDutyConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSlackConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSlackWebhookDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSmtpConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableSmtpConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.LdapAuthentication;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.TreeNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.com.google.common.net.MediaType;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class AdminJsonService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final Ordering<RepoAdmin.H2Table> orderingByBytesDesc = new Ordering<RepoAdmin.H2Table>(){

        public int compare(RepoAdmin.H2Table left, RepoAdmin.H2Table right) {
            return Longs.compare((long)right.bytes(), (long)left.bytes());
        }
    };
    private static final Set<String> NOT_ALLOWED_HOST_FOR_PROXY = Sets.newHashSet((Object[])new String[]{"localhost", "127.0.0.1", "::1"});
    private final boolean central;
    private final boolean offlineViewer;
    private final boolean webPortReadOnly;
    private final List<File> confDirs;
    private final ConfigRepository configRepository;
    private final RepoAdmin repoAdmin;
    private final LiveAggregateRepository liveAggregateRepository;
    private final MailService mailService;
    private final HttpClient httpClient;
    private volatile @MonotonicNonNull HttpServer httpServer;

    AdminJsonService(boolean central, boolean offlineViewer, boolean webPortReadOnly, List<File> confDirs, ConfigRepository configRepository, RepoAdmin repoAdmin, LiveAggregateRepository liveAggregateRepository, MailService mailService, HttpClient httpClient) {
        this.central = central;
        this.offlineViewer = offlineViewer;
        this.webPortReadOnly = webPortReadOnly;
        this.confDirs = confDirs;
        this.configRepository = configRepository;
        this.repoAdmin = repoAdmin;
        this.liveAggregateRepository = liveAggregateRepository;
        this.mailService = mailService;
        this.httpClient = httpClient;
    }

    void setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    @POST(path="/backend/change-password", permission="")
    String changePassword(@BindRequest ChangePassword changePassword, @BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        if (authentication.anonymous()) {
            throw new JsonServiceException(HttpResponseStatus.BAD_REQUEST, "cannot change anonymous password");
        }
        UserConfig userConfig = this.configRepository.getUserConfigCaseInsensitive(authentication.caseAmbiguousUsername()).toCompletableFuture().join();
        Preconditions.checkNotNull((Object)userConfig, (Object)"user no longer exists");
        if (!PasswordHash.validatePassword(changePassword.currentPassword(), userConfig.passwordHash())) {
            return "{\"currentPasswordIncorrect\":true}";
        }
        ImmutableUserConfig updatedUserConfig = ImmutableUserConfig.builder().copyFrom(userConfig).passwordHash(PasswordHash.createHash(changePassword.newPassword())).build();
        this.configRepository.updateUserConfig(updatedUserConfig, userConfig.version(), CassandraProfile.web).toCompletableFuture().join();
        return "";
    }

    @GET(path="/backend/admin/general", permission="admin:view:general")
    String getGeneralConfig() throws Exception {
        if (this.central) {
            return this.getCentralAdminGeneralConfig();
        }
        return this.getEmbeddedAdminGeneralConfig();
    }

    @GET(path="/backend/admin/web", permission="admin:view:web")
    String getWebConfig() throws Exception {
        if (this.central) {
            return this.getCentralWebConfig();
        }
        return this.getEmbeddedWebConfig(false);
    }

    @GET(path="/backend/admin/storage", permission="admin:view:storage")
    String getStorageConfig() throws Exception {
        if (this.central) {
            CentralStorageConfig config = this.configRepository.getCentralStorageConfig().toCompletableFuture().join();
            return mapper.writeValueAsString((Object)CentralStorageConfigDto.create(config));
        }
        EmbeddedStorageConfig config = this.configRepository.getEmbeddedStorageConfig();
        return mapper.writeValueAsString((Object)EmbeddedStorageConfigDto.create(config));
    }

    @GET(path="/backend/admin/smtp", permission="admin:view:smtp")
    String getSmtpConfig() throws Exception {
        SmtpConfig config = this.configRepository.getSmtpConfig().toCompletableFuture().join();
        String localServerName = InetAddress.getLocalHost().getHostName();
        return mapper.writeValueAsString((Object)ImmutableSmtpConfigResponse.builder().config(SmtpConfigDto.create(config)).localServerName(localServerName).build());
    }

    @GET(path="/backend/admin/http-proxy", permission="admin:view:httpProxy")
    String getHttpProxyConfig() throws Exception {
        HttpProxyConfig config = this.configRepository.getHttpProxyConfig().toCompletableFuture().join();
        return mapper.writeValueAsString((Object)HttpProxyConfigDto.create(config));
    }

    @GET(path="/backend/admin/ldap", permission="admin:view:ldap")
    String getLdapConfig() throws Exception {
        List<String> allGlowrootRoles = Lists.newArrayList();
        for (RoleConfig roleConfig : this.configRepository.getRoleConfigs().toCompletableFuture().join()) {
            allGlowrootRoles.add(roleConfig.name());
        }
        allGlowrootRoles = Ordering.natural().sortedCopy((Iterable)allGlowrootRoles);
        return mapper.writeValueAsString((Object)ImmutableLdapConfigResponse.builder().config(LdapConfigDto.create(this.configRepository.getLdapConfig().toCompletableFuture().join())).allGlowrootRoles(allGlowrootRoles).build());
    }

    @GET(path="/backend/admin/pager-duty", permission="admin:view:pagerDuty")
    String getPagerDutyConfig() throws Exception {
        PagerDutyConfig config = this.configRepository.getPagerDutyConfig().toCompletableFuture().join();
        return mapper.writeValueAsString((Object)PagerDutyConfigDto.create(config));
    }

    @GET(path="/backend/admin/slack", permission="admin:view:slack")
    String getSlackConfig() throws Exception {
        SlackConfig config = this.configRepository.getSlackConfig().toCompletableFuture().join();
        return mapper.writeValueAsString((Object)SlackConfigDto.create(config));
    }

    @GET(path="/backend/admin/healthchecks-io", permission="admin:view:healthchecksIo")
    String getHealthchecksIoConfig() throws Exception {
        HealthchecksIoConfig config = this.configRepository.getHealthchecksIoConfig();
        return mapper.writeValueAsString((Object)HealthchecksIoConfigDto.create(config));
    }

    @GET(path="/backend/admin/json", permission="admin:view")
    String getAllAdmin() throws Exception {
        Object config = this.central ? this.configRepository.getAllCentralAdminConfig() : this.configRepository.getAllEmbeddedAdminConfig();
        ObjectNode rootNode = (ObjectNode)mapper.valueToTree(config);
        AllAdminConfigUtil.removePasswords(rootNode);
        ObjectMappers.stripEmptyContainerNodes((ObjectNode)rootNode);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.setPrettyPrinter(ObjectMappers.getPrettyPrinter());
            jg.writeObject((Object)rootNode);
        }
        sb.append(ObjectMappers.NEWLINE);
        return sb.toString();
    }

    @POST(path="/backend/admin/general", permission="admin:edit:general")
    String updateGeneralConfig(@BindRequest String content) throws Exception {
        if (this.central) {
            CentralAdminGeneralConfigDto configDto = (CentralAdminGeneralConfigDto)mapper.readValue(content, ImmutableCentralAdminGeneralConfigDto.class);
            CentralAdminGeneralConfig config = configDto.convert();
            try {
                this.configRepository.updateCentralAdminGeneralConfig(config, configDto.version(), CassandraProfile.web).toCompletableFuture().join();
            }
            catch (ConfigRepository.OptimisticLockException e) {
                throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
            }
            return this.getCentralAdminGeneralConfig();
        }
        EmbeddedAdminGeneralConfigDto configDto = (EmbeddedAdminGeneralConfigDto)mapper.readValue(content, ImmutableEmbeddedAdminGeneralConfigDto.class);
        EmbeddedAdminGeneralConfig config = configDto.convert();
        try {
            this.configRepository.updateEmbeddedAdminGeneralConfig(config, configDto.version(), CassandraProfile.web).toCompletableFuture().join();
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getEmbeddedAdminGeneralConfig();
    }

    @POST(path="/backend/admin/web", permission="admin:edit:web")
    Object updateWebConfig(@BindRequest String content) throws Exception {
        if (this.central) {
            CentralWebConfigDto configDto = (CentralWebConfigDto)mapper.readValue(content, ImmutableCentralWebConfigDto.class);
            CentralWebConfig config = configDto.convert();
            try {
                this.configRepository.updateCentralWebConfig(config, configDto.version()).toCompletableFuture().join();
            }
            catch (ConfigRepository.OptimisticLockException e) {
                throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
            }
            return this.getCentralWebConfig();
        }
        Preconditions.checkNotNull((Object)this.httpServer);
        EmbeddedWebConfigDto configDto = (EmbeddedWebConfigDto)mapper.readValue(content, ImmutableEmbeddedWebConfigDto.class);
        EmbeddedWebConfig config = configDto.convert();
        if (config.https() && !this.httpServer.getHttps()) {
            File certificateFile = this.getConfFile("ui-cert.pem");
            if (certificateFile == null) {
                return "{\"httpsRequiredFilesDoNotExist\":true}";
            }
            File privateKeyFile = this.getConfFile("ui-key.pem");
            if (privateKeyFile == null) {
                return "{\"httpsRequiredFilesDoNotExist\":true}";
            }
            try {
                SslContextBuilder.forServer((File)certificateFile, (File)privateKeyFile);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                StringBuilder sb = new StringBuilder();
                try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
                    jg.writeStartObject();
                    jg.writeStringField("httpsValidationError", e.getMessage());
                    jg.writeEndObject();
                }
                return sb.toString();
            }
        }
        if (this.webPortReadOnly && config.port() != ((Integer)Preconditions.checkNotNull((Object)this.httpServer.getPort())).intValue()) {
            throw new JsonServiceException(HttpResponseStatus.BAD_REQUEST, "cannot change port when using -Dglowroot.agent.port");
        }
        try {
            this.configRepository.updateEmbeddedWebConfig(config, configDto.version());
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.onSuccessfulEmbeddedWebUpdate(config);
    }

    @POST(path="/backend/admin/storage", permission="admin:edit:storage")
    String updateStorageConfig(@BindRequest String content) throws Exception {
        if (this.central) {
            CentralStorageConfigDto configDto = (CentralStorageConfigDto)mapper.readValue(content, ImmutableCentralStorageConfigDto.class);
            try {
                this.configRepository.updateCentralStorageConfig(configDto.convert(), configDto.version()).toCompletableFuture().join();
            }
            catch (ConfigRepository.OptimisticLockException e) {
                throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
            }
        }
        EmbeddedStorageConfigDto configDto = (EmbeddedStorageConfigDto)mapper.readValue(content, ImmutableEmbeddedStorageConfigDto.class);
        try {
            this.configRepository.updateEmbeddedStorageConfig(configDto.convert(), configDto.version());
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        this.repoAdmin.resizeIfNeeded();
        return this.getStorageConfig();
    }

    @POST(path="/backend/admin/smtp", permission="admin:edit:smtp")
    String updateSmtpConfig(@BindRequest SmtpConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateSmtpConfig(configDto.convert(this.configRepository), configDto.version()).toCompletableFuture().join();
        }
        catch (LazySecretKey.SymmetricEncryptionKeyMissingException e) {
            return "{\"symmetricEncryptionKeyMissing\":true}";
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getSmtpConfig();
    }

    @POST(path="/backend/admin/http-proxy", permission="admin:edit:httpProxy")
    String updateHttpProxyConfig(@BindRequest HttpProxyConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateHttpProxyConfig(configDto.convert(this.configRepository), configDto.version()).toCompletableFuture().join();
        }
        catch (LazySecretKey.SymmetricEncryptionKeyMissingException e) {
            return "{\"symmetricEncryptionKeyMissing\":true}";
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getHttpProxyConfig();
    }

    @POST(path="/backend/admin/ldap", permission="admin:edit:ldap")
    String updateLdapConfig(@BindRequest LdapConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateLdapConfig(configDto.convert(this.configRepository), configDto.version()).toCompletableFuture().join();
        }
        catch (LazySecretKey.SymmetricEncryptionKeyMissingException e) {
            return "{\"symmetricEncryptionKeyMissing\":true}";
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getLdapConfig();
    }

    @POST(path="/backend/admin/pager-duty", permission="admin:edit:pagerDuty")
    String updatePagerDutyConfig(@BindRequest PagerDutyConfigDto configDto) throws Exception {
        try {
            this.configRepository.updatePagerDutyConfig(configDto.convert(), configDto.version()).toCompletableFuture().join();
        }
        catch (ConfigRepository.DuplicatePagerDutyIntegrationKeyException e) {
            return "{\"duplicateIntegrationKey\":true}";
        }
        catch (ConfigRepository.DuplicatePagerDutyIntegrationKeyDisplayException e) {
            return "{\"duplicateIntegrationKeyDisplay\":true}";
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getPagerDutyConfig();
    }

    @POST(path="/backend/admin/slack", permission="admin:edit:slack")
    String updateSlackConfig(@BindRequest SlackConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateSlackConfig(configDto.convert(), configDto.version()).toCompletableFuture().join();
        }
        catch (ConfigRepository.DuplicateSlackWebhookUrlException e) {
            return "{\"duplicateWebhookUrl\":true}";
        }
        catch (ConfigRepository.DuplicateSlackWebhookDisplayException e) {
            return "{\"duplicateWebhookDisplay\":true}";
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getSlackConfig();
    }

    @POST(path="/backend/admin/healthchecks-io", permission="admin:edit:healthchecksIo")
    String updateHealthchecksIoConfig(@BindRequest HealthchecksIoConfigDto configDto) throws Exception {
        try {
            this.configRepository.updateHealthchecksIoConfig(configDto.convert(), configDto.version());
        }
        catch (ConfigRepository.OptimisticLockException e) {
            throw new JsonServiceException(HttpResponseStatus.PRECONDITION_FAILED, (Throwable)e);
        }
        return this.getHealthchecksIoConfig();
    }

    @POST(path="/backend/admin/json", permission="admin:edit")
    String updateAllAdmin(@BindRequest String content) throws Exception {
        JsonNode rootNode = mapper.readTree(content);
        AllAdminConfigUtil.updatePasswords(rootNode, this.configRepository);
        if (this.central) {
            AllCentralAdminConfig config = (AllCentralAdminConfig)mapper.treeToValue((TreeNode)rootNode, ImmutableAllCentralAdminConfig.class);
            this.configRepository.updateAllCentralAdminConfig(config, config.version());
        } else {
            AllEmbeddedAdminConfig config = (AllEmbeddedAdminConfig)mapper.treeToValue((TreeNode)rootNode, ImmutableAllEmbeddedAdminConfig.class);
            this.configRepository.updateAllEmbeddedAdminConfig(config, config.version());
        }
        return this.getAllAdmin();
    }

    @POST(path="/backend/admin/send-test-email", permission="admin:edit:smtp")
    String sendTestEmail(@BindRequest SmtpConfigDto configDto) throws IOException {
        String passwordOverride;
        SmtpConfigDto configDtoWithoutNewPassword;
        String newPassword = configDto.newPassword();
        if (newPassword.isEmpty()) {
            configDtoWithoutNewPassword = configDto;
            passwordOverride = null;
        } else {
            configDtoWithoutNewPassword = ImmutableSmtpConfigDto.builder().copyFrom(configDto).newPassword("").build();
            passwordOverride = newPassword;
        }
        String testEmailRecipient = configDtoWithoutNewPassword.testEmailRecipient();
        Preconditions.checkNotNull((Object)testEmailRecipient);
        List emailAddresses = Splitter.on((char)',').trimResults().splitToList((CharSequence)testEmailRecipient);
        try {
            String agentDisplay;
            String centralDisplay;
            if (this.central) {
                centralDisplay = this.configRepository.getCentralAdminGeneralConfig().toCompletableFuture().join().centralDisplayName();
                agentDisplay = "";
            } else {
                centralDisplay = "";
                agentDisplay = this.configRepository.getEmbeddedAdminGeneralConfig().agentDisplayNameOrDefault();
            }
            String subject = "Test email";
            AlertingService.sendEmail(centralDisplay, agentDisplay, subject, emailAddresses, "", configDtoWithoutNewPassword.convert(this.configRepository), passwordOverride, this.configRepository.getLazySecretKey(), this.mailService, true);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return AdminJsonService.createErrorResponse(e);
        }
        return "{}";
    }

    @POST(path="/backend/admin/test-http-proxy", permission="admin:edit:httpProxy")
    String testHttpProxy(@BindRequest HttpProxyConfigDto configDto) throws IOException {
        String responseContent;
        URI uri;
        String passwordOverride;
        HttpProxyConfigDto configDtoWithoutNewPassword;
        String newPassword = configDto.newPassword();
        if (newPassword.isEmpty()) {
            configDtoWithoutNewPassword = configDto;
            passwordOverride = null;
        } else {
            configDtoWithoutNewPassword = ImmutableHttpProxyConfigDto.builder().copyFrom(configDto).newPassword("").build();
            passwordOverride = newPassword;
        }
        String testUrl = configDtoWithoutNewPassword.testUrl();
        Preconditions.checkNotNull((Object)testUrl);
        try {
            uri = new URI(testUrl);
        }
        catch (URISyntaxException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return AdminJsonService.createErrorResponse(e);
        }
        if (uri.getScheme() == null) {
            return AdminJsonService.createErrorResponse("Invalid url, missing protocol (e.g. http://)");
        }
        if (uri.getHost() == null) {
            return AdminJsonService.createErrorResponse("Invalid url, missing host");
        }
        if (NOT_ALLOWED_HOST_FOR_PROXY.contains(uri.getHost())) {
            return AdminJsonService.createErrorResponse("Invalid url, invalid host");
        }
        try {
            responseContent = this.httpClient.getWithHttpProxyConfigOverride(testUrl, configDtoWithoutNewPassword.convert(this.configRepository), passwordOverride);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return AdminJsonService.createErrorResponse(e);
        }
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeStringField("content", responseContent);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @POST(path="/backend/admin/test-ldap", permission="admin:edit:ldap")
    String testLdap(@BindRequest LdapConfigDto configDto) throws Exception {
        Set<String> ldapGroupDns;
        String passwordOverride;
        LdapConfigDto configDtoWithoutNewPassword;
        String newPassword = configDto.newPassword();
        if (newPassword.isEmpty()) {
            configDtoWithoutNewPassword = configDto;
            passwordOverride = null;
        } else {
            configDtoWithoutNewPassword = ImmutableLdapConfigDto.builder().copyFrom(configDto).newPassword("").build();
            passwordOverride = newPassword;
        }
        LdapConfig config = configDtoWithoutNewPassword.convert(this.configRepository);
        String authTestUsername = (String)Preconditions.checkNotNull((Object)configDtoWithoutNewPassword.authTestUsername());
        String authTestPassword = (String)Preconditions.checkNotNull((Object)configDtoWithoutNewPassword.authTestPassword());
        try {
            ldapGroupDns = LdapAuthentication.authenticateAndGetLdapGroupDns(authTestUsername, authTestPassword, config, passwordOverride, this.configRepository.getLazySecretKey());
        }
        catch (LdapAuthentication.AuthenticationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return AdminJsonService.createErrorResponse(e);
        }
        Set<String> glowrootRoles = LdapAuthentication.getGlowrootRoles(ldapGroupDns, config);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeObjectField("ldapGroupDns", ldapGroupDns);
            jg.writeObjectField("glowrootRoles", glowrootRoles);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @POST(path="/backend/admin/defrag-h2-data", permission="")
    void defragH2Data(@BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        if (!this.offlineViewer && !authentication.isAdminPermitted("admin:edit:storage")) {
            throw new JsonServiceException(HttpResponseStatus.FORBIDDEN);
        }
        this.repoAdmin.defragH2Data();
    }

    @POST(path="/backend/admin/compact-h2-data", permission="")
    void compactH2Data(@BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        if (!this.offlineViewer && !authentication.isAdminPermitted("admin:edit:storage")) {
            throw new JsonServiceException(HttpResponseStatus.FORBIDDEN);
        }
        this.repoAdmin.compactH2Data();
    }

    @POST(path="/backend/admin/analyze-h2-disk-space", permission="")
    String analyzeH2DiskSpace(@BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        if (!this.offlineViewer && !authentication.isAdminPermitted("admin:edit:storage")) {
            throw new JsonServiceException(HttpResponseStatus.FORBIDDEN);
        }
        long h2DataFileSize = this.repoAdmin.getH2DataFileSize();
        List<RepoAdmin.H2Table> tables = this.repoAdmin.analyzeH2DiskSpace();
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeNumberField("h2DataFileSize", h2DataFileSize);
            jg.writeObjectField("tables", (Object)orderingByBytesDesc.sortedCopy(tables));
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @POST(path="/backend/admin/analyze-trace-counts", permission="")
    String analyzeTraceCounts(@BindAuthentication HttpSessionManager.Authentication authentication) throws Exception {
        if (!this.offlineViewer && !authentication.isAdminPermitted("admin:edit:storage")) {
            throw new JsonServiceException(HttpResponseStatus.FORBIDDEN);
        }
        return mapper.writeValueAsString((Object)this.repoAdmin.analyzeTraceCounts());
    }

    @POST(path="/backend/admin/delete-all-stored-data", permission="admin:edit:storage")
    void deleteAllData() throws Exception {
        this.repoAdmin.deleteAllData();
        this.liveAggregateRepository.clearInMemoryData();
    }

    @POST(path="/backend/admin/update-cassandra-twcs-window-sizes", permission="admin:edit:storage")
    String updateCassandraTwcsWindowSizes() throws Exception {
        return Integer.toString(this.repoAdmin.updateCassandraTwcsWindowSizes());
    }

    @GET(path="/backend/admin/cassandra-write-totals", permission="admin:view:storage")
    String getCassandraWriteTotals(@BindRequest CassandraWriteTotalsRequest request) throws JsonProcessingException {
        String tableName = request.tableName();
        String agentRollupId = request.agentRollupId();
        String transactionType = request.transactionType();
        int limit = request.limit();
        if (tableName == null) {
            return mapper.writeValueAsString(this.repoAdmin.getCassandraWriteTotalsPerTable(limit));
        }
        if (agentRollupId == null) {
            return mapper.writeValueAsString(this.repoAdmin.getCassandraWriteTotalsPerAgentRollup(tableName, limit));
        }
        if (transactionType == null) {
            return mapper.writeValueAsString(this.repoAdmin.getCassandraWriteTotalsPerTransactionType(tableName, agentRollupId, limit));
        }
        return mapper.writeValueAsString(this.repoAdmin.getCassandraWriteTotalsPerTransactionName(tableName, agentRollupId, transactionType, limit));
    }

    private @Nullable File getConfFile(String fileName) {
        for (File confDir : this.confDirs) {
            File confFile = new File(confDir, fileName);
            if (!confFile.exists()) continue;
            return confFile;
        }
        return null;
    }

    @RequiresNonNull(value={"httpServer"})
    private CommonHandler.CommonResponse onSuccessfulEmbeddedWebUpdate(EmbeddedWebConfig config) throws Exception {
        boolean closeCurrentChannelAfterPortChange = false;
        boolean portChangeFailed = false;
        if (config.port() != ((Integer)Preconditions.checkNotNull((Object)this.httpServer.getPort())).intValue()) {
            try {
                this.httpServer.changePort(config.port());
                closeCurrentChannelAfterPortChange = true;
            }
            catch (HttpServer.PortChangeFailedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                portChangeFailed = true;
            }
        }
        if (config.https() != this.httpServer.getHttps() && !portChangeFailed) {
            this.httpServer.changeProtocol(config.https());
            closeCurrentChannelAfterPortChange = true;
        }
        String responseText = this.getEmbeddedWebConfig(portChangeFailed);
        CommonHandler.CommonResponse response = new CommonHandler.CommonResponse(HttpResponseStatus.OK, MediaType.JSON_UTF_8, responseText);
        if (closeCurrentChannelAfterPortChange) {
            response.setCloseConnectionAfterPortChange();
        }
        return response;
    }

    private String getEmbeddedAdminGeneralConfig() throws Exception {
        return mapper.writeValueAsString((Object)ImmutableEmbeddedAdminGeneralConfigResponse.builder().config(EmbeddedAdminGeneralConfigDto.create(this.configRepository.getEmbeddedAdminGeneralConfig())).defaultAgentDisplayName(EmbeddedAdminGeneralConfig.defaultAgentDisplayName()).build());
    }

    private String getCentralAdminGeneralConfig() throws Exception {
        return mapper.writeValueAsString((Object)CentralAdminGeneralConfigDto.create(this.configRepository.getCentralAdminGeneralConfig().toCompletableFuture().join()));
    }

    private String getEmbeddedWebConfig(boolean portChangeFailed) throws Exception {
        EmbeddedWebConfig config = this.configRepository.getEmbeddedWebConfig();
        ImmutableEmbeddedWebConfigResponse.Builder builder = ImmutableEmbeddedWebConfigResponse.builder().config(EmbeddedWebConfigDto.create(config)).portReadOnly(this.webPortReadOnly).portChangeFailed(portChangeFailed);
        if (this.httpServer == null) {
            builder.activePort(config.port()).activeBindAddress(config.bindAddress()).activeHttps(config.https());
        } else {
            builder.activePort((Integer)Preconditions.checkNotNull((Object)this.httpServer.getPort())).activeBindAddress(this.httpServer.getBindAddress()).activeHttps(this.httpServer.getHttps());
        }
        for (File confDir : this.confDirs) {
            builder.addConfDirs(confDir.getAbsolutePath());
        }
        return mapper.writeValueAsString((Object)builder.build());
    }

    private String getCentralWebConfig() throws Exception {
        return mapper.writeValueAsString((Object)ImmutableCentralWebConfigResponse.builder().config(CentralWebConfigDto.create(this.configRepository.getCentralWebConfig().toCompletableFuture().join())).build());
    }

    private static String createErrorResponse(Exception exception) throws IOException {
        String message = exception.getLocalizedMessage();
        String exceptionName = exception.getClass().getSimpleName();
        if (message == null) {
            return AdminJsonService.createErrorResponse(exceptionName);
        }
        return AdminJsonService.createErrorResponse(exceptionName + ": " + message);
    }

    private static String createErrorResponse(@Nullable String message) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter((Appendable)sb));){
            jg.writeStartObject();
            jg.writeBooleanField("error", true);
            jg.writeStringField("message", message);
            jg.writeEndObject();
        }
        return sb.toString();
    }

    @Value.Immutable
    static abstract class HealthchecksIoConfigDto {
        HealthchecksIoConfigDto() {
        }

        abstract String pingUrl();

        abstract String version();

        private HealthchecksIoConfig convert() {
            return ImmutableHealthchecksIoConfig.builder().pingUrl(this.pingUrl()).build();
        }

        private static HealthchecksIoConfigDto create(HealthchecksIoConfig config) {
            return ImmutableHealthchecksIoConfigDto.builder().pingUrl(config.pingUrl()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class SlackWebhookDto {
        SlackWebhookDto() {
        }

        abstract @Nullable String id();

        abstract String url();

        abstract String display();

        private ImmutableSlackWebhook convert() {
            String id = this.id();
            if (id == null) {
                id = IdGenerator.generateNewId();
            }
            return ImmutableSlackWebhook.builder().id(id).url(this.url()).display(this.display()).build();
        }

        private static ImmutableSlackWebhookDto create(SlackConfig.SlackWebhook webhook) {
            return ImmutableSlackWebhookDto.builder().id(webhook.id()).url(webhook.url()).display(webhook.display()).build();
        }
    }

    @Value.Immutable
    static abstract class SlackConfigDto {
        SlackConfigDto() {
        }

        public abstract List<ImmutableSlackWebhookDto> webhooks();

        abstract String version();

        private SlackConfig convert() {
            ImmutableSlackConfig.Builder builder = ImmutableSlackConfig.builder();
            for (SlackWebhookDto slackWebhookDto : this.webhooks()) {
                builder.addWebhooks(slackWebhookDto.convert());
            }
            return builder.build();
        }

        private static SlackConfigDto create(SlackConfig config) {
            ImmutableSlackConfigDto.Builder builder = ImmutableSlackConfigDto.builder();
            for (SlackConfig.SlackWebhook slackWebhook : config.webhooks()) {
                builder.addWebhooks(SlackWebhookDto.create(slackWebhook));
            }
            return builder.version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class PagerDutyConfigDto {
        PagerDutyConfigDto() {
        }

        public abstract List<ImmutablePagerDutyIntegrationKey> integrationKeys();

        abstract String version();

        private PagerDutyConfig convert() {
            return ImmutablePagerDutyConfig.builder().addAllIntegrationKeys(this.integrationKeys()).build();
        }

        private static PagerDutyConfigDto create(PagerDutyConfig config) {
            return ImmutablePagerDutyConfigDto.builder().addAllIntegrationKeys(config.integrationKeys()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class LdapConfigDto {
        LdapConfigDto() {
        }

        abstract String host();

        @JsonInclude
        abstract @Nullable Integer port();

        abstract boolean ssl();

        abstract String username();

        abstract boolean passwordExists();

        @Value.Default
        String newPassword() {
            return "";
        }

        abstract String userBaseDn();

        abstract String userSearchFilter();

        abstract String groupBaseDn();

        abstract String groupSearchFilter();

        abstract Map<String, List<String>> roleMappings();

        abstract @Nullable String authTestUsername();

        abstract @Nullable String authTestPassword();

        abstract String version();

        private LdapConfig convert(ConfigRepository configRepository) throws Exception {
            ImmutableLdapConfig.Builder builder = ImmutableLdapConfig.builder().host(this.host()).port(this.port()).ssl(this.ssl()).username(this.username()).userBaseDn(this.userBaseDn()).userSearchFilter(this.userSearchFilter()).groupBaseDn(this.groupBaseDn()).groupSearchFilter(this.groupSearchFilter()).roleMappings(this.roleMappings());
            if (!this.passwordExists()) {
                builder.encryptedPassword("");
            } else if (this.passwordExists() && !this.newPassword().isEmpty()) {
                builder.encryptedPassword(Encryption.encrypt(this.newPassword(), configRepository.getLazySecretKey()));
            } else {
                builder.encryptedPassword(configRepository.getLdapConfig().toCompletableFuture().join().encryptedPassword());
            }
            return builder.build();
        }

        private static LdapConfigDto create(LdapConfig config) {
            return ImmutableLdapConfigDto.builder().host(config.host()).port(config.port()).ssl(config.ssl()).username(config.username()).passwordExists(!config.encryptedPassword().isEmpty()).userBaseDn(config.userBaseDn()).userSearchFilter(config.userSearchFilter()).groupBaseDn(config.groupBaseDn()).groupSearchFilter(config.groupSearchFilter()).roleMappings(config.roleMappings()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class HttpProxyConfigDto {
        HttpProxyConfigDto() {
        }

        abstract String host();

        @JsonInclude
        abstract @Nullable Integer port();

        abstract String username();

        abstract boolean passwordExists();

        @Value.Default
        String newPassword() {
            return "";
        }

        abstract @Nullable String testUrl();

        abstract String version();

        private HttpProxyConfig convert(ConfigRepository configRepository) throws Exception {
            ImmutableHttpProxyConfig.Builder builder = ImmutableHttpProxyConfig.builder().host(this.host()).port(this.port()).username(this.username());
            if (!this.passwordExists()) {
                builder.encryptedPassword("");
            } else if (this.passwordExists() && !this.newPassword().isEmpty()) {
                builder.encryptedPassword(Encryption.encrypt(this.newPassword(), configRepository.getLazySecretKey()));
            } else {
                builder.encryptedPassword(configRepository.getHttpProxyConfig().toCompletableFuture().join().encryptedPassword());
            }
            return builder.build();
        }

        private static HttpProxyConfigDto create(HttpProxyConfig config) {
            return ImmutableHttpProxyConfigDto.builder().host(config.host()).port(config.port()).username(config.username()).passwordExists(!config.encryptedPassword().isEmpty()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class SmtpConfigDto {
        SmtpConfigDto() {
        }

        abstract String host();

        @JsonInclude
        abstract @Nullable Integer port();

        @JsonInclude
        abstract @Nullable SmtpConfig.ConnectionSecurity connectionSecurity();

        abstract String username();

        abstract boolean passwordExists();

        @Value.Default
        String newPassword() {
            return "";
        }

        abstract Map<String, String> additionalProperties();

        abstract String fromEmailAddress();

        abstract String fromDisplayName();

        abstract @Nullable String testEmailRecipient();

        abstract String version();

        private SmtpConfig convert(ConfigRepository configRepository) throws Exception {
            ImmutableSmtpConfig.Builder builder = ImmutableSmtpConfig.builder().host(this.host()).port(this.port()).connectionSecurity(this.connectionSecurity()).username(this.username()).putAllAdditionalProperties(this.additionalProperties()).fromEmailAddress(this.fromEmailAddress()).fromDisplayName(this.fromDisplayName());
            if (!this.passwordExists()) {
                builder.encryptedPassword("");
            } else if (this.passwordExists() && !this.newPassword().isEmpty()) {
                builder.encryptedPassword(Encryption.encrypt(this.newPassword(), configRepository.getLazySecretKey()));
            } else {
                builder.encryptedPassword(configRepository.getSmtpConfig().toCompletableFuture().join().encryptedPassword());
            }
            return builder.build();
        }

        private static SmtpConfigDto create(SmtpConfig config) {
            return ImmutableSmtpConfigDto.builder().host(config.host()).port(config.port()).connectionSecurity(config.connectionSecurity()).username(config.username()).passwordExists(!config.encryptedPassword().isEmpty()).putAllAdditionalProperties(config.additionalProperties()).fromEmailAddress(config.fromEmailAddress()).fromDisplayName(config.fromDisplayName()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class CentralStorageConfigDto {
        CentralStorageConfigDto() {
        }

        abstract ImmutableList<Integer> rollupExpirationHours();

        abstract ImmutableList<Integer> queryAndServiceCallRollupExpirationHours();

        abstract ImmutableList<Integer> profileRollupExpirationHours();

        abstract int traceExpirationHours();

        abstract String version();

        private CentralStorageConfig convert() {
            return ImmutableCentralStorageConfig.builder().rollupExpirationHours((Iterable<Integer>)this.rollupExpirationHours()).queryAndServiceCallRollupExpirationHours((Iterable<Integer>)this.queryAndServiceCallRollupExpirationHours()).profileRollupExpirationHours((Iterable<Integer>)this.profileRollupExpirationHours()).traceExpirationHours(this.traceExpirationHours()).build();
        }

        private static CentralStorageConfigDto create(CentralStorageConfig config) {
            return ImmutableCentralStorageConfigDto.builder().addAllRollupExpirationHours((Iterable<Integer>)config.rollupExpirationHours()).addAllQueryAndServiceCallRollupExpirationHours((Iterable<Integer>)config.queryAndServiceCallRollupExpirationHours()).addAllProfileRollupExpirationHours((Iterable<Integer>)config.profileRollupExpirationHours()).traceExpirationHours(config.traceExpirationHours()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class EmbeddedStorageConfigDto {
        EmbeddedStorageConfigDto() {
        }

        abstract ImmutableList<Integer> rollupExpirationHours();

        abstract int traceExpirationHours();

        abstract int fullQueryTextExpirationHours();

        abstract ImmutableList<Integer> rollupCappedDatabaseSizesMb();

        abstract int traceCappedDatabaseSizeMb();

        abstract String version();

        private EmbeddedStorageConfig convert() {
            return ImmutableEmbeddedStorageConfig.builder().rollupExpirationHours((Iterable<Integer>)this.rollupExpirationHours()).traceExpirationHours(this.traceExpirationHours()).fullQueryTextExpirationHours(this.fullQueryTextExpirationHours()).rollupCappedDatabaseSizesMb((Iterable<Integer>)this.rollupCappedDatabaseSizesMb()).traceCappedDatabaseSizeMb(this.traceCappedDatabaseSizeMb()).build();
        }

        private static EmbeddedStorageConfigDto create(EmbeddedStorageConfig config) {
            return ImmutableEmbeddedStorageConfigDto.builder().addAllRollupExpirationHours((Iterable<Integer>)config.rollupExpirationHours()).traceExpirationHours(config.traceExpirationHours()).fullQueryTextExpirationHours(config.fullQueryTextExpirationHours()).addAllRollupCappedDatabaseSizesMb((Iterable<Integer>)config.rollupCappedDatabaseSizesMb()).traceCappedDatabaseSizeMb(config.traceCappedDatabaseSizeMb()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class CentralWebConfigDto {
        CentralWebConfigDto() {
        }

        abstract int sessionTimeoutMinutes();

        abstract String sessionCookieName();

        abstract String version();

        private CentralWebConfig convert() {
            return ImmutableCentralWebConfig.builder().sessionTimeoutMinutes(this.sessionTimeoutMinutes()).sessionCookieName(this.sessionCookieName()).build();
        }

        private static CentralWebConfigDto create(CentralWebConfig config) {
            return ImmutableCentralWebConfigDto.builder().sessionTimeoutMinutes(config.sessionTimeoutMinutes()).sessionCookieName(config.sessionCookieName()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class EmbeddedWebConfigDto {
        EmbeddedWebConfigDto() {
        }

        abstract int port();

        abstract String bindAddress();

        abstract boolean https();

        abstract String contextPath();

        abstract int sessionTimeoutMinutes();

        abstract String sessionCookieName();

        abstract String version();

        private EmbeddedWebConfig convert() {
            return ImmutableEmbeddedWebConfig.builder().port(this.port()).bindAddress(this.bindAddress()).https(this.https()).contextPath(this.contextPath()).sessionTimeoutMinutes(this.sessionTimeoutMinutes()).sessionCookieName(this.sessionCookieName()).build();
        }

        private static EmbeddedWebConfigDto create(EmbeddedWebConfig config) {
            return ImmutableEmbeddedWebConfigDto.builder().port(config.port()).bindAddress(config.bindAddress()).https(config.https()).contextPath(config.contextPath()).sessionTimeoutMinutes(config.sessionTimeoutMinutes()).sessionCookieName(config.sessionCookieName()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class CentralAdminGeneralConfigDto {
        CentralAdminGeneralConfigDto() {
        }

        abstract String centralDisplayName();

        abstract String version();

        private CentralAdminGeneralConfig convert() {
            return ImmutableCentralAdminGeneralConfig.builder().centralDisplayName(this.centralDisplayName()).build();
        }

        private static CentralAdminGeneralConfigDto create(CentralAdminGeneralConfig config) {
            return ImmutableCentralAdminGeneralConfigDto.builder().centralDisplayName(config.centralDisplayName()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static abstract class EmbeddedAdminGeneralConfigDto {
        EmbeddedAdminGeneralConfigDto() {
        }

        abstract String agentDisplayName();

        abstract String version();

        private EmbeddedAdminGeneralConfig convert() {
            return ImmutableEmbeddedAdminGeneralConfig.builder().agentDisplayName(this.agentDisplayName()).build();
        }

        private static EmbeddedAdminGeneralConfigDto create(EmbeddedAdminGeneralConfig config) {
            return ImmutableEmbeddedAdminGeneralConfigDto.builder().agentDisplayName(config.agentDisplayName()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static interface CassandraWriteTotalsRequest {
        public @Nullable String tableName();

        public @Nullable String agentRollupId();

        public @Nullable String transactionType();

        public int limit();
    }

    @Value.Immutable
    static interface LdapConfigResponse {
        public LdapConfigDto config();

        public List<String> allGlowrootRoles();
    }

    @Value.Immutable
    static interface SmtpConfigResponse {
        public SmtpConfigDto config();

        public String localServerName();
    }

    @Value.Immutable
    static interface CentralWebConfigResponse {
        public CentralWebConfigDto config();
    }

    @Value.Immutable
    static interface EmbeddedWebConfigResponse {
        public EmbeddedWebConfigDto config();

        public int activePort();

        public String activeBindAddress();

        public boolean activeHttps();

        public boolean portReadOnly();

        public boolean portChangeFailed();

        public List<String> confDirs();
    }

    @Value.Immutable
    static interface EmbeddedAdminGeneralConfigResponse {
        public EmbeddedAdminGeneralConfigDto config();

        public String defaultAgentDisplayName();
    }

    @Value.Immutable
    static interface ChangePassword {
        public String currentPassword();

        public String newPassword();
    }
}

