/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LockSet<K extends Serializable> {
    public @Nullable UUID lock(K var1);

    public void unlock(K var1, UUID var2);

    public static class LockSetImpl<K extends Serializable>
    implements LockSet<K> {
        private final ConcurrentMap<K, UUID> map;

        public LockSetImpl(ConcurrentMap<K, UUID> map) {
            this.map = map;
        }

        @Override
        public @Nullable UUID lock(K key) {
            UUID lockToken = UUID.randomUUID();
            if (this.map.putIfAbsent(key, lockToken) == null) {
                return lockToken;
            }
            return null;
        }

        @Override
        public void unlock(K key, UUID lockToken) {
            this.map.remove(key, lockToken);
        }
    }
}

