/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.com.ning.compress.lzf;

import java.io.IOException;
import java.io.InputStream;
import org.glowroot.agent.embedded.shaded.com.ning.compress.lzf.LZFException;

public abstract class ChunkDecoder {
    public abstract int decodeChunk(InputStream var1, byte[] var2, byte[] var3) throws IOException;

    public abstract int skipOrDecodeChunk(InputStream var1, byte[] var2, byte[] var3, long var4) throws IOException;

    protected static final int uint16(byte[] data, int ptr) {
        return ((data[ptr] & 0xFF) << 8) + (data[ptr + 1] & 0xFF);
    }

    protected static final int readHeader(InputStream is, byte[] inputBuffer) throws IOException {
        int needed = 5;
        int count = is.read(inputBuffer, 0, needed);
        if (count == needed) {
            return count;
        }
        if (count <= 0) {
            return 0;
        }
        int offset = count;
        needed -= count;
        while ((count = is.read(inputBuffer, offset, needed)) > 0) {
            offset += count;
            if ((needed -= count) > 0) continue;
        }
        return offset;
    }

    protected static final void readFully(InputStream is, boolean compressed, byte[] outputBuffer, int offset, int len) throws IOException {
        int count;
        for (int left = len; left > 0; left -= count) {
            count = is.read(outputBuffer, offset, left);
            if (count < 0) {
                throw new LZFException("EOF in " + len + " byte (" + (compressed ? "" : "un") + "compressed) block: could only read " + (len - left) + " bytes");
            }
            offset += count;
        }
    }

    protected static final void skipFully(InputStream is, int amount) throws IOException {
        int orig = amount;
        while (amount > 0) {
            long skipped = is.skip(amount);
            if (skipped <= 0L) {
                throw new LZFException("Input problem: failed to skip " + orig + " bytes in input stream, only skipped " + (orig - amount));
            }
            amount -= (int)skipped;
        }
    }

    protected void _reportCorruptHeader() throws LZFException {
        throw new LZFException("Corrupt input data, block did not start with 2 byte signature ('ZV') followed by type byte, 2-byte length)");
    }
}

