/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.repo.GaugeIdDao;
import org.glowroot.agent.embedded.repo.GaugeNameDao;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.GaugeValueRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Gauges;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.RollupLevelService;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.ImmutableIndex;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.util.Checkers;

public class GaugeValueDao
implements GaugeValueRepository {
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("gauge_id", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("capture_time", Schemas.ColumnType.BIGINT), (Object)ImmutableColumn.of("value", Schemas.ColumnType.DOUBLE), (Object)ImmutableColumn.of("weight", Schemas.ColumnType.BIGINT));
    private final GaugeIdDao gaugeIdDao;
    private final GaugeNameDao gaugeNameDao;
    private final DataSource dataSource;
    private final Clock clock;
    private final ImmutableList<ConfigRepository.RollupConfig> rollupConfigs;
    private final AtomicLongArray lastRollupTimes;
    private final Object rollupLock = new Object();

    GaugeValueDao(DataSource dataSource, GaugeIdDao gaugeIdDao, GaugeNameDao gaugeNameDao, Clock clock) throws Exception {
        this.dataSource = dataSource;
        this.gaugeIdDao = gaugeIdDao;
        this.gaugeNameDao = gaugeNameDao;
        this.clock = clock;
        this.rollupConfigs = ImmutableList.copyOf(ConfigRepository.RollupConfig.buildRollupConfigs());
        for (int i = 0; i <= this.rollupConfigs.size(); ++i) {
            dataSource.syncTable("gauge_value_rollup_" + Checkers.castUntainted((Object)i), (List<Schemas.Column>)columns);
            dataSource.syncIndexes("gauge_value_rollup_" + Checkers.castUntainted((Object)i), (ImmutableList<Schemas.Index>)ImmutableList.of((Object)ImmutableIndex.of("gauge_value_rollup_" + Checkers.castUntainted((Object)i) + "_idx", (ImmutableList<String>)ImmutableList.of((Object)"gauge_id", (Object)"capture_time", (Object)"value", (Object)"weight")), (Object)ImmutableIndex.of("gauge_value_rollup_" + Checkers.castUntainted((Object)i) + "_by_capture_time_idx", (ImmutableList<String>)ImmutableList.of((Object)"capture_time", (Object)"gauge_id", (Object)"value", (Object)"weight"))));
        }
        ArrayList columns = Lists.newArrayList();
        for (int i = 1; i <= this.rollupConfigs.size(); ++i) {
            columns.add(ImmutableColumn.of("last_rollup_" + i + "_time", Schemas.ColumnType.BIGINT));
        }
        dataSource.syncTable("gauge_value_last_rollup_times", columns);
        this.lastRollupTimes = GaugeValueDao.initData(this.rollupConfigs, dataSource);
    }

    @Override
    public CompletionStage<List<GaugeValueRepository.Gauge>> getRecentlyActiveGauges(String agentRollupId) {
        long now = this.clock.currentTimeMillis();
        long from = now - TimeUnit.DAYS.toMillis(7L);
        return this.getGauges(agentRollupId, from, now + TimeUnit.DAYS.toMillis(365L), CassandraProfile.web);
    }

    @Override
    public CompletionStage<List<GaugeValueRepository.Gauge>> getGauges(String agentRollupId, long from, long to, CassandraProfile profile) {
        Set<String> allGaugeNames = this.gaugeNameDao.readAllGaugeNames(from, to);
        ArrayList gauges = Lists.newArrayList();
        for (String gaugeName : allGaugeNames) {
            gauges.add(Gauges.getGauge(gaugeName));
        }
        return CompletableFuture.completedFuture(gauges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues) throws Exception {
        if (gaugeValues.isEmpty()) {
            return;
        }
        LinkedHashMap gaugeValueIdMap = Maps.newLinkedHashMap();
        for (CollectorServiceOuterClass.GaugeValueMessage.GaugeValue gaugeValue : gaugeValues) {
            long gaugeId = this.gaugeIdDao.updateLastCaptureTime(gaugeValue.getGaugeName(), gaugeValue.getCaptureTime());
            if (gaugeId == -1L) {
                return;
            }
            this.gaugeNameDao.insert(gaugeValue.getCaptureTime(), gaugeValue.getGaugeName());
            gaugeValueIdMap.put(gaugeValue, gaugeId);
        }
        this.dataSource.batchUpdate(new GaugeValuesBinder(gaugeValueIdMap));
        Object object = this.rollupLock;
        synchronized (object) {
            long safeCurrentTime = this.clock.currentTimeMillis() - 1L;
            for (int i = 0; i < this.rollupConfigs.size(); ++i) {
                long lastRollupTime;
                long intervalMillis = ((ConfigRepository.RollupConfig)this.rollupConfigs.get(i)).intervalMillis();
                long safeRollupTime = RollupLevelService.getSafeRollupTime(safeCurrentTime, intervalMillis);
                if (safeRollupTime <= (lastRollupTime = this.lastRollupTimes.get(i))) continue;
                this.rollup(lastRollupTime, safeRollupTime, intervalMillis, i + 1, i);
                this.dataSource.update("update gauge_value_last_rollup_times set last_rollup_" + Checkers.castUntainted((Object)(i + 1)) + "_time = ?", safeRollupTime);
                this.lastRollupTimes.set(i, safeRollupTime);
            }
        }
    }

    @Override
    public CompletionStage<List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue>> readGaugeValues(String agentRollupId, String gaugeName, long from, long to, int rollupLevel, CassandraProfile profile) {
        try {
            Long gaugeId = this.gaugeIdDao.getGaugeId(gaugeName);
            if (gaugeId == null) {
                return CompletableFuture.completedFuture(ImmutableList.of());
            }
            return CompletableFuture.completedFuture(this.dataSource.query(new GaugeValueQuery(gaugeId, from, to, rollupLevel)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<Long> getOldestCaptureTime(String agentRollupId, String gaugeName, int rollupLevel, CassandraProfile profile) {
        try {
            Long gaugeId = this.gaugeIdDao.getGaugeId(gaugeName);
            if (gaugeId == null) {
                return CompletableFuture.completedFuture(Long.MAX_VALUE);
            }
            Long oldestCaptureTime = this.dataSource.queryForOptionalLong("select top 1 capture_time from gauge_value_rollup_" + Checkers.castUntainted((Object)rollupLevel) + " where gauge_id = ? order by capture_time", gaugeId);
            return CompletableFuture.completedFuture(oldestCaptureTime == null ? Long.MAX_VALUE : oldestCaptureTime);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteBefore(long captureTime, int rollupLevel) throws SQLException {
        this.dataSource.deleteBefore("gauge_value_rollup_" + Checkers.castUntainted((Object)rollupLevel), captureTime);
    }

    void reinitAfterDeletingDatabase() throws Exception {
        AtomicLongArray lastRollupTimes = GaugeValueDao.initData(this.rollupConfigs, this.dataSource);
        for (int i = 0; i < lastRollupTimes.length(); ++i) {
            this.lastRollupTimes.set(i, lastRollupTimes.get(i));
        }
    }

    private void rollup(long lastRollupTime, long safeRollupTime, long fixedIntervalMillis, int toRollupLevel, int fromRollupLevel) throws Exception {
        String captureTimeSql = (String)Checkers.castUntainted((Object)("ceil(capture_time / " + fixedIntervalMillis + ".0) * " + fixedIntervalMillis));
        this.dataSource.update("merge into gauge_value_rollup_" + Checkers.castUntainted((Object)toRollupLevel) + " (gauge_id, capture_time, value, weight) key (gauge_id, capture_time) select gauge_id, " + captureTimeSql + " ceil_capture_time, sum(value * weight) / sum(weight), sum(weight) from gauge_value_rollup_" + Checkers.castUntainted((Object)fromRollupLevel) + " gp where gp.capture_time > ? and gp.capture_time <= ? group by gp.gauge_id, ceil_capture_time", lastRollupTime, safeRollupTime);
    }

    private static AtomicLongArray initData(ImmutableList<ConfigRepository.RollupConfig> rollupConfigs, DataSource dataSource) throws Exception {
        ArrayList columnNames = Lists.newArrayList();
        for (int i = 1; i <= rollupConfigs.size(); ++i) {
            columnNames.add("last_rollup_" + i + "_time");
        }
        Joiner joiner = Joiner.on((String)", ");
        String selectClause = (String)Checkers.castUntainted((Object)joiner.join((Iterable)columnNames));
        long[] lastRollupTimes = dataSource.query(new LastRollupTimesQuery(selectClause));
        if (lastRollupTimes.length == 0) {
            long[] values = new long[rollupConfigs.size()];
            String valueClause = (String)Checkers.castUntainted((Object)joiner.join((Iterable)Longs.asList((long[])values)));
            dataSource.update("insert into gauge_value_last_rollup_times (" + selectClause + ") values (" + valueClause + ")", new Object[0]);
            return new AtomicLongArray(values);
        }
        return new AtomicLongArray(lastRollupTimes);
    }

    private static class GaugeValueQuery
    implements DataSource.JdbcRowQuery<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> {
        private final long gaugeId;
        private final long from;
        private final long to;
        private final int rollupLevel;

        private GaugeValueQuery(long gaugeId, long from, long to, int rollupLevel) {
            this.gaugeId = gaugeId;
            this.from = from;
            this.to = to;
            this.rollupLevel = rollupLevel;
        }

        @Override
        public @Untainted String getSql() {
            return "select capture_time, value, weight from gauge_value_rollup_" + Checkers.castUntainted((Object)this.rollupLevel) + " where gauge_id = ? and capture_time >= ? and capture_time <= ? order by capture_time";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            int i = 1;
            preparedStatement.setLong(i++, this.gaugeId);
            preparedStatement.setLong(i++, this.from);
            preparedStatement.setLong(i++, this.to);
        }

        @Override
        public CollectorServiceOuterClass.GaugeValueMessage.GaugeValue mapRow(ResultSet resultSet) throws SQLException {
            int i = 1;
            return CollectorServiceOuterClass.GaugeValueMessage.GaugeValue.newBuilder().setCaptureTime(resultSet.getLong(i++)).setValue(resultSet.getDouble(i++)).setWeight(resultSet.getLong(i++)).build();
        }
    }

    private static class LastRollupTimesQuery
    implements DataSource.JdbcQuery<long[]> {
        private final @Untainted String selectClause;

        public LastRollupTimesQuery(@Untainted String selectClause) {
            this.selectClause = selectClause;
        }

        @Override
        public @Untainted String getSql() {
            return "select " + this.selectClause + " from gauge_value_last_rollup_times";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws Exception {
        }

        @Override
        public long[] processResultSet(ResultSet resultSet) throws Exception {
            if (!resultSet.next()) {
                return new long[0];
            }
            int columns = resultSet.getMetaData().getColumnCount();
            long[] values = new long[columns];
            for (int i = 0; i < columns; ++i) {
                values[i] = resultSet.getLong(i + 1);
            }
            return values;
        }

        @Override
        public long[] valueIfDataSourceClosed() {
            return new long[0];
        }
    }

    private static class GaugeValuesBinder
    implements DataSource.JdbcUpdate {
        private final Map<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue, Long> gaugeValueIdMap;

        private GaugeValuesBinder(Map<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue, Long> gaugeValueIdMap) {
            this.gaugeValueIdMap = gaugeValueIdMap;
        }

        @Override
        public @Untainted String getSql() {
            return "insert into gauge_value_rollup_0 (gauge_id, capture_time, value, weight) values (?, ?, ?, ?)";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            for (Map.Entry<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue, Long> entry : this.gaugeValueIdMap.entrySet()) {
                CollectorServiceOuterClass.GaugeValueMessage.GaugeValue gaugeValue = entry.getKey();
                long gaugeId = entry.getValue();
                int i = 1;
                preparedStatement.setLong(i++, gaugeId);
                preparedStatement.setLong(i++, gaugeValue.getCaptureTime());
                preparedStatement.setDouble(i++, gaugeValue.getValue());
                preparedStatement.setLong(i++, gaugeValue.getWeight());
                preparedStatement.addBatch();
            }
        }
    }
}

