/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AlertingDisabledRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;

public class AlertingDisabledDao
implements AlertingDisabledRepository {
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("disabled_until_time", Schemas.ColumnType.BIGINT));
    private final DataSource dataSource;

    AlertingDisabledDao(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        dataSource.syncTable("alerting_disabled", (List<Schemas.Column>)columns);
        AlertingDisabledDao.init(dataSource);
    }

    @Override
    public CompletionStage<Long> getAlertingDisabledUntilTime(String agentRollupId, CassandraProfile profile) {
        try {
            return CompletableFuture.completedFuture(this.dataSource.queryForOptionalLong("select disabled_until_time from alerting_disabled", new Object[0]));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletionStage<?> setAlertingDisabledUntilTime(String agentRollupId, @Nullable Long disabledUntilTime, CassandraProfile profile) {
        try {
            this.dataSource.update(new AlertingDisabledBinder(disabledUntilTime));
            return CompletableFuture.completedFuture(null);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void reinitAfterDeletingDatabase() throws Exception {
        AlertingDisabledDao.init(this.dataSource);
    }

    private static void init(DataSource dataSource) throws SQLException {
        long rowCount = dataSource.queryForLong("select count(*) from alerting_disabled", new Object[0]);
        if (rowCount == 0L) {
            dataSource.execute("insert into alerting_disabled (disabled_until_time) values (null)");
        } else {
            Preconditions.checkState((rowCount == 1L ? 1 : 0) != 0);
        }
    }

    private static class AlertingDisabledBinder
    implements DataSource.JdbcUpdate {
        private final @Nullable Long disabledUntilTime;

        private AlertingDisabledBinder(@Nullable Long disabledUntilTime) {
            this.disabledUntilTime = disabledUntilTime;
        }

        @Override
        public @Untainted String getSql() {
            return "update alerting_disabled set disabled_until_time = ?";
        }

        @Override
        public void bind(PreparedStatement preparedStatement) throws SQLException {
            if (this.disabledUntilTime == null) {
                preparedStatement.setNull(1, -5);
            } else {
                preparedStatement.setLong(1, this.disabledUntilTime);
            }
        }
    }
}

