/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.bytecode.api.Bytecode;
import org.glowroot.agent.bytecode.api.Util;
import org.glowroot.agent.plugin.api.ClassInfo;
import org.glowroot.agent.plugin.api.MethodInfo;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.objectweb.asm.FieldVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Label;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Opcodes;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.AdviceAdapter;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.GeneratorAdapter;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Method;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.MethodRemapper;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.SimpleRemapper;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.ClassNode;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.FieldNode;
import org.glowroot.agent.shaded.org.objectweb.asm.tree.MethodNode;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Advice;
import org.glowroot.agent.weaving.AnalyzedClass;
import org.glowroot.agent.weaving.AnalyzedMethod;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.glowroot.agent.weaving.BootstrapMetaHolders;
import org.glowroot.agent.weaving.ClassInfoImpl;
import org.glowroot.agent.weaving.ClassLoaders;
import org.glowroot.agent.weaving.ClassNames;
import org.glowroot.agent.weaving.ImmutableMethodMetaGroup;
import org.glowroot.agent.weaving.MethodInfoImpl;
import org.glowroot.agent.weaving.MixinType;
import org.glowroot.agent.weaving.ShimType;
import org.glowroot.agent.weaving.WeavingMethodVisitor;
import org.immutables.value.Value;

class WeavingClassVisitor
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(WeavingClassVisitor.class);
    private static final Type bytecodeType = Type.getType(Bytecode.class);
    private static final Type bytecodeUtilType = Type.getType(Util.class);
    private static final Type classInfoType = Type.getType(ClassInfo.class);
    private static final Type classInfoImplType = Type.getType(ClassInfoImpl.class);
    private static final Type methodInfoType = Type.getType(MethodInfo.class);
    private static final Type methodInfoImplType = Type.getType(MethodInfoImpl.class);
    private static final AtomicLong metaHolderCounter = new AtomicLong();
    private final ClassWriter cw;
    private final @Nullable ClassLoader loader;
    private final boolean frames;
    private final boolean noLongerNeedToWeaveMainMethods;
    private final boolean isClassLoader;
    private final AnalyzedClass analyzedClass;
    private final List<AnalyzedMethod> methodsThatOnlyNowFulfillAdvice;
    private final List<ShimType> shimTypes;
    private final List<MixinType> mixinTypes;
    private final List<ClassNode> mixinClassNodes;
    private final Map<String, List<Advice>> methodAdvisors;
    private final AnalyzedWorld analyzedWorld;
    private final Set<String> shimMethods;
    private @MonotonicNonNull Type type;
    private final Set<Type> classMetaTypes = Sets.newHashSet();
    private final Set<MethodMetaGroup> methodMetaGroups = Sets.newHashSet();
    private @MonotonicNonNull String metaHolderInternalName;
    private int methodMetaCounter;
    private final Set<Advice> usedAdvisors = Sets.newHashSet();

    public WeavingClassVisitor(ClassWriter cw, @Nullable ClassLoader loader, boolean frames, boolean noLongerNeedToWeaveMainMethods, AnalyzedClass analyzedClass, boolean isClassLoader, List<AnalyzedMethod> methodsThatOnlyNowFulfillAdvice, List<ShimType> shimTypes, List<MixinType> mixinTypes, Map<String, List<Advice>> methodAdvisors, AnalyzedWorld analyzedWorld) {
        super(589824, cw);
        this.cw = cw;
        this.loader = loader;
        this.frames = frames;
        this.noLongerNeedToWeaveMainMethods = noLongerNeedToWeaveMainMethods;
        this.isClassLoader = isClassLoader;
        this.analyzedClass = analyzedClass;
        this.methodsThatOnlyNowFulfillAdvice = methodsThatOnlyNowFulfillAdvice;
        this.shimTypes = shimTypes;
        this.mixinTypes = mixinTypes;
        this.methodAdvisors = methodAdvisors;
        this.analyzedWorld = analyzedWorld;
        this.shimMethods = Sets.newHashSet();
        for (ShimType shimType : shimTypes) {
            for (java.lang.reflect.Method shimMethod : shimType.shimMethods()) {
                Method method = Method.getMethod(shimMethod);
                this.shimMethods.add(method.getName() + method.getDescriptor());
            }
        }
        this.mixinClassNodes = Lists.newArrayList();
        if (!analyzedClass.isInterface()) {
            for (MixinType mixinType : mixinTypes) {
                ClassReader cr = new ClassReader(mixinType.implementationBytes());
                ClassNode cn = new ClassNode();
                cr.accept(cn, 8);
                this.mixinClassNodes.add(cn);
            }
        }
    }

    @Override
    public void visit(int version, int access, String internalName, @Nullable String signature, @Nullable String superInternalName, String[] interfaceInternalNamesNullable) {
        this.type = Type.getObjectType(internalName);
        String[] interfacesPlus = interfaceInternalNamesNullable;
        if (!this.analyzedClass.isInterface()) {
            interfacesPlus = WeavingClassVisitor.getInterfacesIncludingShimsAndMixins(interfaceInternalNamesNullable, this.shimTypes, this.mixinTypes);
        }
        this.cw.visit(version, access, internalName, signature, superInternalName, interfacesPlus);
    }

    @Override
    public @Nullable MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
        Preconditions.checkNotNull(this.type);
        if (WeavingClassVisitor.isAbstractOrNativeOrSynthetic(access)) {
            return this.cw.visitMethod(access, name, descriptor, signature, exceptions);
        }
        if (this.isMixinProxy(name, descriptor)) {
            return null;
        }
        if (this.shimMethods.contains(name + descriptor)) {
            return null;
        }
        List<Advice> matchingAdvisors = this.methodAdvisors.get(name + descriptor);
        matchingAdvisors = matchingAdvisors == null ? ImmutableList.of() : WeavingClassVisitor.removeSuperseded(matchingAdvisors);
        if (this.isInitWithMixins(name)) {
            return this.visitInitWithMixins(access, name, descriptor, signature, exceptions, matchingAdvisors);
        }
        MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
        if (!this.noLongerNeedToWeaveMainMethods) {
            if (Modifier.isPublic(access) && Modifier.isStatic(access) && descriptor.equals("([Ljava/lang/String;)V")) {
                if (name.equals("main")) {
                    mv.visitLdcInsn(this.type.getClassName());
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(184, bytecodeType.getInternalName(), "enteringMainMethod", "(Ljava/lang/String;[Ljava/lang/String;)V", false);
                } else if (name.startsWith("start")) {
                    mv.visitLdcInsn(this.type.getClassName());
                    mv.visitLdcInsn(name);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(184, bytecodeType.getInternalName(), "enteringPossibleProcrunStartMethod", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", false);
                }
            } else if (this.type.getInternalName().equals("org/apache/commons/daemon/support/DaemonLoader") && Modifier.isPublic(access) && Modifier.isStatic(access) && name.equals("load") && descriptor.equals("(Ljava/lang/String;[Ljava/lang/String;)Z")) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(184, bytecodeType.getInternalName(), "enteringApacheCommonsDaemonLoadMethod", "(Ljava/lang/String;[Ljava/lang/String;)V", false);
            }
        }
        if (this.isClassLoader && name.equals("loadClass") && (Modifier.isPublic(access) || Modifier.isProtected(access)) && !Modifier.isStatic(access)) {
            if (descriptor.equals("(Ljava/lang/String;)Ljava/lang/Class;")) {
                WeavingClassVisitor.addLoadClassConditional(mv, new Object[]{this.type.getInternalName(), "java/lang/String"});
            } else if (descriptor.equals("(Ljava/lang/String;Z)Ljava/lang/Class;")) {
                WeavingClassVisitor.addLoadClassConditional(mv, new Object[]{this.type.getInternalName(), "java/lang/String", Opcodes.INTEGER});
            }
        }
        if (matchingAdvisors.isEmpty()) {
            return mv;
        }
        return this.visitMethodWithAdvice(mv, access, name, descriptor, matchingAdvisors);
    }

    Set<Advice> getUsedAdvisors() {
        return this.usedAdvisors;
    }

    private boolean isMixinProxy(String name, String descriptor) {
        for (ClassNode cn : this.mixinClassNodes) {
            List<MethodNode> methodNodes = cn.methods;
            for (MethodNode mn : methodNodes) {
                if (mn.name.equals("<init>") || !mn.name.equals(name) || !mn.desc.equals(descriptor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitEnd() {
        Preconditions.checkNotNull(this.type);
        this.analyzedWorld.add(this.analyzedClass, this.loader);
        if (!this.analyzedClass.isInterface()) {
            for (ShimType shimType : this.shimTypes) {
                this.addShim(shimType);
            }
            for (ClassNode mixinClassNode : this.mixinClassNodes) {
                this.addMixin(mixinClassNode);
            }
        }
        for (AnalyzedMethod methodThatOnlyNowFulfillAdvice : this.methodsThatOnlyNowFulfillAdvice) {
            this.overrideAndWeaveInheritedMethod(methodThatOnlyNowFulfillAdvice);
        }
        if (this.metaHolderInternalName != null) {
            this.handleMetaHolders();
        }
        this.cw.visitEnd();
    }

    @RequiresNonNull(value={"type", "metaHolderInternalName"})
    private void handleMetaHolders() {
        if (this.loader == null) {
            this.initializeBoostrapMetaHolders();
        } else {
            try {
                this.generateMetaHolder();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @RequiresNonNull(value={"type", "metaHolderInternalName"})
    private void initializeBoostrapMetaHolders() {
        for (Type classMetaType : this.classMetaTypes) {
            String classMetaInternalName = classMetaType.getInternalName();
            String classMetaFieldName = "glowroot$class$meta$" + classMetaInternalName.replace('/', '$');
            BootstrapMetaHolders.createClassMetaHolder(this.metaHolderInternalName, classMetaFieldName, classMetaType, this.type);
        }
        for (MethodMetaGroup methodMetaGroup : this.methodMetaGroups) {
            for (Type methodMetaType : methodMetaGroup.methodMetaTypes()) {
                String methodMetaInternalName = methodMetaType.getInternalName();
                String methodMetaFieldName = "glowroot$method$meta$" + methodMetaGroup.uniqueNum() + '$' + methodMetaInternalName.replace('/', '$');
                BootstrapMetaHolders.createMethodMetaHolder(this.metaHolderInternalName, methodMetaFieldName, methodMetaType, this.type, methodMetaGroup.methodName(), methodMetaGroup.methodReturnType(), methodMetaGroup.methodParameterTypes());
            }
        }
    }

    @RequiresNonNull(value={"type", "metaHolderInternalName", "loader"})
    private void generateMetaHolder() throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(49, 33, this.metaHolderInternalName, null, "java/lang/Object", null);
        Type metaHolderType = Type.getObjectType(this.metaHolderInternalName);
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Throwable");
        mv.visitLabel(l0);
        for (Type classMetaType : this.classMetaTypes) {
            String classMetaInternalName = classMetaType.getInternalName();
            String classMetaFieldName = "glowroot$class$meta$" + classMetaInternalName.replace('/', '$');
            FieldVisitor fv = cw.visitField(25, classMetaFieldName, "L" + classMetaInternalName + ";", null, null);
            fv.visitEnd();
            mv.visitTypeInsn(187, classMetaInternalName);
            mv.visitInsn(89);
            mv.visitTypeInsn(187, classInfoImplType.getInternalName());
            mv.visitInsn(89);
            mv.visitLdcInsn(this.type.getClassName());
            mv.visitLdcInsn(metaHolderType);
            mv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;", false);
            mv.visitMethodInsn(183, classInfoImplType.getInternalName(), "<init>", "(Ljava/lang/String;Ljava/lang/ClassLoader;)V", false);
            mv.visitMethodInsn(183, classMetaInternalName, "<init>", "(L" + classInfoType.getInternalName() + ";)V", false);
            mv.visitFieldInsn(179, this.metaHolderInternalName, classMetaFieldName, "L" + classMetaInternalName + ";");
        }
        for (MethodMetaGroup methodMetaGroup : this.methodMetaGroups) {
            for (Type methodMetaType : methodMetaGroup.methodMetaTypes()) {
                String methodMetaInternalName = methodMetaType.getInternalName();
                String methodMetaFieldName = "glowroot$method$meta$" + methodMetaGroup.uniqueNum() + '$' + methodMetaInternalName.replace('/', '$');
                FieldVisitor fv = cw.visitField(25, methodMetaFieldName, "L" + methodMetaInternalName + ";", null, null);
                fv.visitEnd();
                mv.visitTypeInsn(187, methodMetaInternalName);
                mv.visitInsn(89);
                mv.visitTypeInsn(187, methodInfoImplType.getInternalName());
                mv.visitInsn(89);
                mv.visitLdcInsn(methodMetaGroup.methodName());
                WeavingClassVisitor.loadType(mv, methodMetaGroup.methodReturnType(), metaHolderType);
                mv.visitTypeInsn(187, "java/util/ArrayList");
                mv.visitInsn(89);
                ImmutableList<Type> methodParameterTypes = methodMetaGroup.methodParameterTypes();
                mv.visitLdcInsn(methodParameterTypes.size());
                mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V", false);
                for (int i = 0; i < methodParameterTypes.size(); ++i) {
                    mv.visitInsn(89);
                    WeavingClassVisitor.loadType(mv, (Type)methodParameterTypes.get(i), metaHolderType);
                    mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
                    mv.visitInsn(87);
                }
                mv.visitLdcInsn(this.type.getClassName());
                mv.visitLdcInsn(metaHolderType);
                mv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;", false);
                mv.visitMethodInsn(183, methodInfoImplType.getInternalName(), "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/util/List;Ljava/lang/String;Ljava/lang/ClassLoader;)V", false);
                mv.visitMethodInsn(183, methodMetaInternalName, "<init>", "(L" + methodInfoType.getInternalName() + ";)V", false);
                mv.visitFieldInsn(179, this.metaHolderInternalName, methodMetaFieldName, "L" + methodMetaInternalName + ";");
            }
        }
        mv.visitLabel(l1);
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitVarInsn(58, 0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, bytecodeType.getInternalName(), "logThrowable", "(Ljava/lang/Throwable;)V", false);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(191);
        mv.visitLabel(l3);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        ClassLoaders.defineClass(ClassNames.fromInternalName(this.metaHolderInternalName), bytes, this.loader);
    }

    private static void loadType(MethodVisitor mv, Type type, Type ownerType) {
        switch (type.getSort()) {
            case 0: {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 1: {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 2: {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 3: {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 4: {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 5: {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 6: {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 7: {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 8: {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 9: {
                WeavingClassVisitor.loadArrayType(mv, type, ownerType);
                break;
            }
            default: {
                WeavingClassVisitor.loadObjectType(mv, type, ownerType);
            }
        }
    }

    private static void loadArrayType(MethodVisitor mv, Type type, Type ownerType) {
        WeavingClassVisitor.loadType(mv, type.getElementType(), ownerType);
        mv.visitLdcInsn(type.getDimensions());
        mv.visitMethodInsn(184, bytecodeUtilType.getInternalName(), "getArrayClass", "(Ljava/lang/Class;I)Ljava/lang/Class;", false);
    }

    private static void loadObjectType(MethodVisitor mv, Type type, Type ownerType) {
        mv.visitLdcInsn(type.getClassName());
        mv.visitInsn(3);
        mv.visitLdcInsn(ownerType);
        mv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;", false);
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", false);
    }

    private static String[] getInterfacesIncludingShimsAndMixins(String[] interfaces, List<ShimType> shimTypes, List<MixinType> mixinTypes) {
        if (mixinTypes.isEmpty() && shimTypes.isEmpty()) {
            return interfaces;
        }
        HashSet<String> interfacesIncludingShimsAndMixins = Sets.newHashSet();
        if (interfaces != null) {
            interfacesIncludingShimsAndMixins.addAll(Arrays.asList(interfaces));
        }
        for (ShimType matchedShimType : shimTypes) {
            interfacesIncludingShimsAndMixins.add(matchedShimType.iface().getInternalName());
        }
        for (MixinType matchedMixinType : mixinTypes) {
            for (Type mixinInterface : matchedMixinType.interfaces()) {
                interfacesIncludingShimsAndMixins.add(mixinInterface.getInternalName());
            }
        }
        return Iterables.toArray(interfacesIncludingShimsAndMixins, String.class);
    }

    private boolean isInitWithMixins(String name) {
        return name.equals("<init>") && !this.mixinTypes.isEmpty();
    }

    @RequiresNonNull(value={"type"})
    private MethodVisitor visitInitWithMixins(int access, String name, String descriptor, @Nullable String signature, String[] exceptions, List<Advice> matchingAdvisors) {
        MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
        mv = new InitMixins(mv, access, name, descriptor, this.mixinTypes, this.type);
        for (Advice advice : matchingAdvisors) {
            if (advice.pointcut().timerName().isEmpty()) continue;
            logger.warn("cannot add timer to <clinit> or <init> methods at this time");
            break;
        }
        return this.newWeavingMethodVisitor(access, name, descriptor, matchingAdvisors, mv);
    }

    @RequiresNonNull(value={"type"})
    private MethodVisitor visitMethodWithAdvice(MethodVisitor mv, int access, String name, String descriptor, List<Advice> matchingAdvisors) {
        return this.newWeavingMethodVisitor(access, name, descriptor, matchingAdvisors, mv);
    }

    @RequiresNonNull(value={"type"})
    private WeavingMethodVisitor newWeavingMethodVisitor(int access, String name, String descriptor, List<Advice> matchingAdvisors, MethodVisitor mv) {
        Integer methodMetaUniqueNum = this.collectMetasAtMethod(matchingAdvisors, name, descriptor);
        this.usedAdvisors.addAll(matchingAdvisors);
        return new WeavingMethodVisitor(mv, this.frames, access, name, descriptor, this.type, matchingAdvisors, this.metaHolderInternalName, methodMetaUniqueNum, this.loader == null);
    }

    private @Nullable Integer collectMetasAtMethod(Iterable<Advice> matchingAdvisors, String methodName, String methodDesc) {
        HashSet<Type> methodMetaTypes = Sets.newHashSet();
        for (Advice matchingAdvice : matchingAdvisors) {
            this.classMetaTypes.addAll(matchingAdvice.classMetaTypes());
            methodMetaTypes.addAll(matchingAdvice.methodMetaTypes());
        }
        Integer methodMetaUniqueNum = null;
        if (!methodMetaTypes.isEmpty()) {
            methodMetaUniqueNum = ++this.methodMetaCounter;
            this.methodMetaGroups.add(ImmutableMethodMetaGroup.builder().methodName(methodName).methodReturnType(Type.getReturnType(methodDesc)).addMethodParameterTypes(Type.getArgumentTypes(methodDesc)).uniqueNum(methodMetaUniqueNum).addAllMethodMetaTypes(methodMetaTypes).build());
        }
        if (!(this.classMetaTypes.isEmpty() && methodMetaTypes.isEmpty() || this.metaHolderInternalName != null)) {
            this.metaHolderInternalName = "org/glowroot/agent/weaving/MetaHolder" + metaHolderCounter.incrementAndGet();
        }
        return methodMetaUniqueNum;
    }

    @RequiresNonNull(value={"type"})
    private void addShim(ShimType shimType) {
        for (java.lang.reflect.Method reflectMethod : shimType.shimMethods()) {
            Method method = Method.getMethod(reflectMethod);
            Shim shim = reflectMethod.getAnnotation(Shim.class);
            Preconditions.checkNotNull(shim);
            if (shim.value().length != 1) {
                throw new IllegalStateException("@Shim annotation must have exactly one value when used on methods");
            }
            Method targetMethod = Method.getMethod(shim.value()[0]);
            MethodVisitor mv = this.cw.visitMethod(1, method.getName(), method.getDescriptor(), null, null);
            mv.visitCode();
            int i = 0;
            mv.visitVarInsn(25, i++);
            for (Type argumentType : method.getArgumentTypes()) {
                mv.visitVarInsn(argumentType.getOpcode(21), i++);
            }
            mv.visitMethodInsn(182, this.type.getInternalName(), targetMethod.getName(), targetMethod.getDescriptor(), false);
            mv.visitInsn(method.getReturnType().getOpcode(172));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    @RequiresNonNull(value={"type"})
    private void addMixin(ClassNode mixinClassNode) {
        List<FieldNode> fieldNodes = mixinClassNode.fields;
        for (FieldNode fieldNode : fieldNodes) {
            if (!Modifier.isTransient(fieldNode.access)) {
                throw new IllegalStateException("@Mixin fields must be marked transient: " + mixinClassNode.name);
            }
            fieldNode.accept(this);
        }
        List<MethodNode> methodNodes = mixinClassNode.methods;
        for (MethodNode mn : methodNodes) {
            if (mn.name.equals("<init>")) continue;
            String[] exceptions = Iterables.toArray(mn.exceptions, String.class);
            MethodVisitor mv = this.cw.visitMethod(mn.access, mn.name, mn.desc, mn.signature, exceptions);
            mn.accept(new MethodRemapper(mv, new SimpleRemapper(mixinClassNode.name, this.type.getInternalName())));
        }
    }

    @RequiresNonNull(value={"type"})
    private void overrideAndWeaveInheritedMethod(AnalyzedMethod inheritedMethod) {
        String superName = this.analyzedClass.superName();
        Preconditions.checkNotNull(superName);
        String[] exceptions = new String[inheritedMethod.exceptions().size()];
        for (int i = 0; i < inheritedMethod.exceptions().size(); ++i) {
            exceptions[i] = ClassNames.toInternalName((String)inheritedMethod.exceptions().get(i));
        }
        List<Advice> advisors = WeavingClassVisitor.removeSuperseded(inheritedMethod.advisors());
        MethodVisitor mv = this.cw.visitMethod(1, inheritedMethod.name(), inheritedMethod.getDesc(), inheritedMethod.signature(), exceptions);
        mv = this.visitMethodWithAdvice(mv, 1, inheritedMethod.name(), inheritedMethod.getDesc(), advisors);
        Preconditions.checkNotNull(mv);
        GeneratorAdapter mg = new GeneratorAdapter(mv, 1, inheritedMethod.name(), inheritedMethod.getDesc());
        mg.visitCode();
        mg.loadThis();
        mg.loadArgs();
        Type superType = Type.getObjectType(ClassNames.toInternalName(superName));
        Method method = new Method(inheritedMethod.name(), inheritedMethod.getDesc());
        mg.invokeConstructor(superType, method);
        mg.returnValue();
        mg.endMethod();
    }

    private static List<Advice> removeSuperseded(List<Advice> advisors) {
        if (advisors.size() < 2) {
            return advisors;
        }
        HashSet<String> suppressionKeys = Sets.newHashSet();
        for (Advice advice : advisors) {
            String suppressionKey = advice.pointcut().suppressionKey();
            if (suppressionKey.isEmpty()) continue;
            suppressionKeys.add(suppressionKey);
        }
        if (suppressionKeys.isEmpty()) {
            return advisors;
        }
        ArrayList<Advice> filteredAdvisors = Lists.newArrayList();
        for (Advice advice : advisors) {
            String suppressibleUsingKey = advice.pointcut().suppressibleUsingKey();
            if (!suppressibleUsingKey.isEmpty() && suppressionKeys.contains(suppressibleUsingKey)) continue;
            filteredAdvisors.add(advice);
        }
        return filteredAdvisors;
    }

    private static boolean isAbstractOrNativeOrSynthetic(int access) {
        return Modifier.isAbstract(access) || Modifier.isNative(access) || (access & 0x1000) != 0;
    }

    private static void addLoadClassConditional(MethodVisitor mv, Object[] locals) {
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        mv.visitTryCatchBlock(label0, label1, label2, "java/lang/ClassNotFoundException");
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn("org.glowroot.agent");
        mv.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
        Label label3 = new Label();
        mv.visitJumpInsn(153, label3);
        mv.visitLabel(label0);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(3);
        mv.visitInsn(1);
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", false);
        mv.visitLabel(label1);
        mv.visitInsn(176);
        mv.visitLabel(label2);
        mv.visitFrame(-1, locals.length, locals, 1, new Object[]{"java/lang/ClassNotFoundException"});
        mv.visitInsn(87);
        mv.visitLabel(label3);
        mv.visitFrame(-1, locals.length, locals, 0, new Object[0]);
    }

    @Value.Immutable
    static interface MethodMetaGroup {
        public String methodName();

        public Type methodReturnType();

        public ImmutableList<Type> methodParameterTypes();

        public int uniqueNum();

        public ImmutableSet<Type> methodMetaTypes();
    }

    private static class InitMixins
    extends AdviceAdapter {
        private final ImmutableList<MixinType> matchedMixinTypes;
        private final Type type;
        private boolean cascadingConstructor;

        InitMixins(MethodVisitor mv, int access, String name, String descriptor, List<MixinType> matchedMixinTypes, Type type) {
            super(589824, mv, access, name, descriptor);
            this.matchedMixinTypes = ImmutableList.copyOf(matchedMixinTypes);
            this.type = type;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean itf) {
            if (name.equals("<init>") && owner.equals(this.type.getInternalName())) {
                this.cascadingConstructor = true;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, itf);
        }

        @Override
        protected void onMethodExit(int opcode) {
            if (this.cascadingConstructor) {
                return;
            }
            for (MixinType mixinType : this.matchedMixinTypes) {
                String initMethodName = mixinType.initMethodName();
                if (initMethodName == null) continue;
                this.loadThis();
                this.invokeVirtual(this.type, new Method(initMethodName, "()V"));
            }
        }
    }
}

