/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.weaving;

import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.weaving.ClassAnalyzer;
import org.glowroot.agent.weaving.ShimType;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClassAnalyzer.MatchedShimTypes", generator="Immutables")
@Immutable
final class ImmutableMatchedShimTypes
implements ClassAnalyzer.MatchedShimTypes {
    private final ImmutableList<ShimType> reweavable;
    private final ImmutableList<ShimType> nonReweavable;

    private ImmutableMatchedShimTypes(ImmutableList<ShimType> reweavable, ImmutableList<ShimType> nonReweavable) {
        this.reweavable = reweavable;
        this.nonReweavable = nonReweavable;
    }

    @JsonProperty(value="reweavable")
    public ImmutableList<ShimType> reweavable() {
        return this.reweavable;
    }

    @JsonProperty(value="nonReweavable")
    public ImmutableList<ShimType> nonReweavable() {
        return this.nonReweavable;
    }

    public final ImmutableMatchedShimTypes withReweavable(ShimType ... elements) {
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedShimTypes(newValue, this.nonReweavable);
    }

    public final ImmutableMatchedShimTypes withReweavable(Iterable<? extends ShimType> elements) {
        if (this.reweavable == elements) {
            return this;
        }
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedShimTypes(newValue, this.nonReweavable);
    }

    public final ImmutableMatchedShimTypes withNonReweavable(ShimType ... elements) {
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedShimTypes(this.reweavable, newValue);
    }

    public final ImmutableMatchedShimTypes withNonReweavable(Iterable<? extends ShimType> elements) {
        if (this.nonReweavable == elements) {
            return this;
        }
        ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMatchedShimTypes(this.reweavable, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMatchedShimTypes && this.equalTo(0, (ImmutableMatchedShimTypes)another);
    }

    private boolean equalTo(int synthetic, ImmutableMatchedShimTypes another) {
        return this.reweavable.equals(another.reweavable) && this.nonReweavable.equals(another.nonReweavable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reweavable.hashCode();
        h += (h << 5) + this.nonReweavable.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MatchedShimTypes").omitNullValues().add("reweavable", this.reweavable).add("nonReweavable", this.nonReweavable).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMatchedShimTypes fromJson(Json json) {
        Builder builder = ImmutableMatchedShimTypes.builder();
        if (json.reweavable != null) {
            builder.addAllReweavable(json.reweavable);
        }
        if (json.nonReweavable != null) {
            builder.addAllNonReweavable(json.nonReweavable);
        }
        return builder.build();
    }

    public static ImmutableMatchedShimTypes copyOf(ClassAnalyzer.MatchedShimTypes instance) {
        if (instance instanceof ImmutableMatchedShimTypes) {
            return (ImmutableMatchedShimTypes)instance;
        }
        return ImmutableMatchedShimTypes.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClassAnalyzer.MatchedShimTypes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<ShimType> reweavable = ImmutableList.builder();
        private ImmutableList.Builder<ShimType> nonReweavable = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ClassAnalyzer.MatchedShimTypes instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllReweavable(instance.reweavable());
            this.addAllNonReweavable(instance.nonReweavable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReweavable(ShimType element) {
            this.reweavable.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReweavable(ShimType ... elements) {
            this.reweavable.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reweavable(Iterable<? extends ShimType> elements) {
            this.reweavable = ImmutableList.builder();
            return this.addAllReweavable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllReweavable(Iterable<? extends ShimType> elements) {
            this.reweavable.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonReweavable(ShimType element) {
            this.nonReweavable.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonReweavable(ShimType ... elements) {
            this.nonReweavable.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nonReweavable(Iterable<? extends ShimType> elements) {
            this.nonReweavable = ImmutableList.builder();
            return this.addAllNonReweavable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNonReweavable(Iterable<? extends ShimType> elements) {
            this.nonReweavable.addAll(elements);
            return this;
        }

        public ImmutableMatchedShimTypes build() {
            return new ImmutableMatchedShimTypes((ImmutableList)this.reweavable.build(), (ImmutableList)this.nonReweavable.build());
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClassAnalyzer.MatchedShimTypes", generator="Immutables")
    static final class Json
    implements ClassAnalyzer.MatchedShimTypes {
        @Nullable
        List<ShimType> reweavable = ImmutableList.of();
        @Nullable
        List<ShimType> nonReweavable = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="reweavable")
        public void setReweavable(List<ShimType> reweavable) {
            this.reweavable = reweavable;
        }

        @JsonProperty(value="nonReweavable")
        public void setNonReweavable(List<ShimType> nonReweavable) {
            this.nonReweavable = nonReweavable;
        }

        @Override
        public List<ShimType> reweavable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ShimType> nonReweavable() {
            throw new UnsupportedOperationException();
        }
    }
}

